/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import java.security.KeyStore;

public class ProtectionParameterCreatorFactory {
    public static ProtectionParameterCreator newPasswordProtectionCreater() {
        return new PasswordProtectionCreator();
    }

    public static ProtectionParameterCreator newNullProtectionCreater() {
        return new NullProtectionCreator();
    }

    private static class NullProtectionCreator
    implements ProtectionParameterCreator {
        private NullProtectionCreator() {
        }

        public KeyStore.ProtectionParameter getParameter(String password) {
            return null;
        }
    }

    private static class PasswordProtectionCreator
    implements ProtectionParameterCreator {
        private PasswordProtectionCreator() {
        }

        public KeyStore.ProtectionParameter getParameter(String password) {
            return new KeyStore.PasswordProtection(password.toCharArray());
        }
    }

    public static interface ProtectionParameterCreator {
        public KeyStore.ProtectionParameter getParameter(String var1);
    }
}

