/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.certrequest.BasicCertificateRequestFile;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.CMSCertificateRequestFile;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.CertSortComparator;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.ProtectionParameterCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.PrivateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.PublicKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreDefaultCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreModifyCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordExpiry;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordStash;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import java.io.File;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreItemFactory {
    private static final boolean REMOVE_SIGNERS_ENABLED = KeymanSettings.Setting.NoDefaultCertsFunctionEnabled.getBoolean();

    public static KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> createKeyStore(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, Collection<? extends Entry> entries) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor, entries);
        switch (descriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory.CMSDatabaseDescriptor)descriptor, entries, false);
            }
            case JCEKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, entries, true, false);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, entries, false, false);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory.PKCS12DatabaseDescriptor)descriptor, entries, false);
            }
        }
        throw new RuntimeException("not implemented for database type " + descriptor.getType());
    }

    public static KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> createKeyStore(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        Debug.entering();
        switch (descriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory.CMSDatabaseDescriptor)descriptor, null, !REMOVE_SIGNERS_ENABLED);
            }
            case JCEKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, null, true, !REMOVE_SIGNERS_ENABLED);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, null, false, !REMOVE_SIGNERS_ENABLED);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory.PKCS12DatabaseDescriptor)descriptor, null, !REMOVE_SIGNERS_ENABLED);
            }
        }
        throw new RuntimeException("not implemented for database type " + descriptor.getType());
    }

    public static KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> loadKeystore(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        Debug.entering();
        switch (descriptor.getType()) {
            case CMS: {
                Debug.exiting();
                return KeyStoreItemFactory.newCMSKeyStoreItem((DatabaseDescriptorFactory.CMSDatabaseDescriptor)descriptor);
            }
            default: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, true);
            }
            case JKS: {
                Debug.exiting();
                return KeyStoreItemFactory.newBasicKeyStoreItem(descriptor, false);
            }
            case PKCS12: 
            case PKCS12S2: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS12KeyStoreItem((DatabaseDescriptorFactory.PKCS12DatabaseDescriptor)descriptor);
            }
            case PKCS11Direct: {
                Debug.exiting();
                return KeyStoreItemFactory.newPKCS11ImplKeyStoreItem((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor)descriptor);
            }
            case MSCapi: {
                Debug.exiting();
                return KeyStoreItemFactory.newMSCAPIKeyStoreItem(descriptor);
            }
            case PKCS11Config: 
        }
        Debug.exiting();
        return KeyStoreItemFactory.newPKCS11ImplKeyStoreItem((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor)descriptor);
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> newBasicKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean allowSecretKeys) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor);
        Debug.exiting();
        return KeyStoreItemFactory.getBasicKeyStoreItem(descriptor, false, allowSecretKeys);
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> newBasicKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, Collection<? extends Entry> entries, boolean allowSecretKeys, boolean addCACerts) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor, entries);
        KeyStoreItemFactory.validateFileName(descriptor);
        KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> item = KeyStoreItemFactory.getBasicKeyStoreItem(descriptor, true, allowSecretKeys);
        if (entries != null) {
            item.addAll(entries, false, true, KeyStoreItem.ValidationMode.ADD);
        }
        if (addCACerts) {
            KeyStoreItemFactory.addCACerts(item);
        }
        item.save();
        Debug.exiting(item);
        return item;
    }

    private static void validateFileName(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
        Debug.entering(descriptor);
        try {
            if (KeyStoreItemFactory.outputFilesExist(descriptor.getFileNameString())) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_EXISTS, descriptor.getFileNameString());
            }
        }
        catch (SecurityException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_READ_PERMISSION, (Throwable)e, descriptor.getFileNameString());
        }
    }

    private static void addCACerts(KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item) throws KeyManagerException {
        Debug.entering(item);
        Iterator<String> iterator = CACertificates.getAliases();
        while (iterator.hasNext()) {
            String alias = iterator.next();
            item.addAll(CACertificates.getCACertificates(alias), false, false, KeyStoreItem.ValidationMode.ADD);
        }
        Debug.exiting();
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> getBasicKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean create, boolean allowSecretKeys) throws CancelledException, KeyManagerException {
        EntryBagFactory.EntryBag<Entry> bagCollection;
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy = descriptor.getType().getCreater().create(descriptor, create);
        proxy.getKeyStore();
        EntryInterfaceFactory.EntryInterface<CertificateRequestKeyItem, DatabaseDescriptorFactory.DatabaseDescriptor> file = create ? BasicCertificateRequestFile.createRequestFile(descriptor.getFileNameString(), descriptor.getPassword(), DatabaseDescriptorFactory.DatabaseDescriptor.class) : BasicCertificateRequestFile.loadRequestFile(descriptor.getFileNameString(), descriptor.getPassword(), DatabaseDescriptorFactory.DatabaseDescriptor.class);
        EntryBagFactory.EntryBag<CertificateItem> certBag = EntryBagFactory.newKeyStoreCertificateBag(proxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateKeyItem> keyBag = EntryBagFactory.newKeyStoreKeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
        if (allowSecretKeys) {
            EntryBagFactory.EntryBag<SecretKeyItem> secretKeyBag = EntryBagFactory.newKeyStoreSecretKeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
            bagCollection = EntryBagFactory.newBagCollection(certBag, keyBag, secretKeyBag);
        } else {
            bagCollection = EntryBagFactory.newBagCollection(certBag, keyBag);
        }
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.DatabaseDescriptor> keyStoreInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(bagCollection, descriptor, proxy);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.DatabaseDescriptor> compoundInterface = EntryInterfaceFactory.newCompoundEntryInterface(descriptor, keyStoreInterface, file);
        KeyStoreItemImpl<DatabaseDescriptorFactory.DatabaseDescriptor> item = new KeyStoreItemImpl<DatabaseDescriptorFactory.DatabaseDescriptor>(compoundInterface, descriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory.DatabaseDescriptor.class);
        return item;
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.CMSDatabaseDescriptor> newCMSKeyStoreItem(DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor, Collection<? extends Entry> entries, boolean addCACerts) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor, entries);
        KeyStoreItemFactory.validateFileName(descriptor);
        KeyStoreItem<DatabaseDescriptorFactory.CMSDatabaseDescriptor> item = KeyStoreItemFactory.getCMSKeyStoreItem(descriptor, true);
        item.clear();
        if (entries != null) {
            item.addAll(entries, false, true, KeyStoreItem.ValidationMode.ADD);
        }
        if (addCACerts) {
            KeyStoreItemFactory.addCACerts(item);
        }
        item.save();
        Debug.exiting(item);
        return item;
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.CMSDatabaseDescriptor> newCMSKeyStoreItem(DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getCMSKeyStoreItem(descriptor, false);
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.CMSDatabaseDescriptor> getCMSKeyStoreItem(DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor, boolean create) throws CancelledException, KeyManagerException {
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy = descriptor.getType().getCreater().create(descriptor, create);
        proxy.getKeyStore();
        CMSCertificateRequestFile file = create ? CMSCertificateRequestFile.createRequestFile(descriptor.getFileName(), descriptor.getPassword()) : CMSCertificateRequestFile.loadRequestFile(descriptor.getFileName(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CMSCertificateItem> certBag = EntryBagFactory.newCMSKeyStoreCertificateBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CMSKeyItem> keyBag = EntryBagFactory.newCMSKeyStoreKeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<Entry> bagCollection = EntryBagFactory.newBagCollection(certBag, keyBag);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.CMSDatabaseDescriptor> keyStoreInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(bagCollection, descriptor, proxy);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.CMSDatabaseDescriptor> compoundInterface = EntryInterfaceFactory.newCompoundEntryInterface(descriptor, keyStoreInterface, file);
        CMSKeyStoreItemImpl item = new CMSKeyStoreItemImpl(compoundInterface, descriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()));
        return item;
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> newPKCS12KeyStoreItem(DatabaseDescriptorFactory.PKCS12DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getPKCS12KeyStoreItem(descriptor, false);
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> getPKCS12KeyStoreItem(DatabaseDescriptorFactory.PKCS12DatabaseDescriptor descriptor, boolean create) throws CancelledException, KeyManagerException {
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> keyStoreInterface;
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy = descriptor.getType().getCreater().create(descriptor, create);
        proxy.getKeyStore();
        EntryBagFactory.EntryBag<CertificateItem> certBag = EntryBagFactory.newKeyStoreCertificateBag(proxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateKeyItem> keyBag = EntryBagFactory.newKeyStoreKeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateRequestKeyItem> certReqBag = EntryBagFactory.newPKCS11CertRequestBag(proxy, null, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), null, descriptor.getPassword());
        EntryBagFactory.EntryBag<Entry> bagCollection = EntryBagFactory.newBagCollection(certBag, keyBag, certReqBag);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> compoundInterface = keyStoreInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(bagCollection, descriptor, proxy);
        KeyStoreItemImpl<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> item = new KeyStoreItemImpl<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor>(compoundInterface, descriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory.PKCS12DatabaseDescriptor.class);
        if (descriptor.isPfxFile()) {
            KeyStoreItemFactory.doPfx(proxy.getKeyStore(), descriptor.getPassword());
            item.refresh();
        }
        return item;
    }

    private static void doPfx(KeyStore keyStore, String password) throws KeyManagerException {
        String keyAlias = null;
        try {
            Enumeration<String> en = keyStore.aliases();
            ArrayList<String> aliases = Collections.list(en);
            for (String alias : aliases) {
                if (!keyStore.isCertificateEntry(alias)) continue;
                Certificate cert = keyStore.getCertificate(alias);
                keyStore.deleteEntry(alias);
                keyAlias = keyStore.getCertificateAlias(cert);
                if (keyAlias == null || keyStore.isCertificateEntry(keyAlias)) {
                    keyStore.setCertificateEntry(alias, cert);
                    continue;
                }
                Key relabelKey = keyStore.getKey(keyAlias, password.toCharArray());
                Certificate[] relabelChain = keyStore.getCertificateChain(keyAlias);
                keyStore.deleteEntry(keyAlias);
                keyStore.setKeyEntry(alias, relabelKey, password.toCharArray(), relabelChain);
            }
        }
        catch (KeyStoreException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.UNRECOVERABLE_ENTRY, (Throwable)e, keyAlias);
        }
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> newPKCS12KeyStoreItem(DatabaseDescriptorFactory.PKCS12DatabaseDescriptor descriptor, Collection<? extends Entry> entries, boolean addCACerts) throws KeyManagerException, CancelledException {
        Debug.entering(descriptor, entries, addCACerts);
        KeyStoreItemFactory.validateFileName(descriptor);
        KeyStoreItem<DatabaseDescriptorFactory.PKCS12DatabaseDescriptor> item = KeyStoreItemFactory.getPKCS12KeyStoreItem(descriptor, true);
        if (entries != null) {
            item.addAll(entries, false, true, KeyStoreItem.ValidationMode.ADD);
        }
        if (addCACerts) {
            KeyStoreItemFactory.addCACerts(item);
        }
        item.save();
        Debug.exiting(item);
        return item;
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor> newPKCS11ImplKeyStoreItem(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getPKCS11ImplKeyStoreItem(descriptor);
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor> getPKCS11ImplKeyStoreItem(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor descriptor) throws CancelledException, KeyManagerException {
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy = descriptor.getType().getCreater().create(descriptor, false);
        KeyStoreItemImpl secondaryItem = null;
        if (descriptor.getSecondaryDescriptor() != null) {
            secondaryItem = (KeyStoreItemImpl)KeyStoreItemFactory.loadKeystore(descriptor.getSecondaryDescriptor());
        }
        TypeDisplayerFactory.TypeDisplayer<Entry> displayer = descriptor instanceof DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig ? TypeDisplayerFactory.newPKCS11EntryDisplayer(((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig)descriptor).getTokenLabel()) : TypeDisplayerFactory.newPKCS11EntryDisplayer(((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect)descriptor).getSlotNumber() + "");
        EntryBagFactory.EntryBag<CertificateItem> certBag = EntryBagFactory.newPKCS11CertificateBag(proxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), displayer, descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateKeyItem> keyBag = EntryBagFactory.newPKCS11KeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), displayer, descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateRequestKeyItem> certReqBag = EntryBagFactory.newPKCS11CertRequestBag(proxy, descriptor.getProvider(), ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), displayer, descriptor.getPassword());
        EntryBagFactory.EntryBag<SecretKeyItem> secretKeyBag = EntryBagFactory.newPKCS11SecretKeyBag(proxy, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), displayer, descriptor.getPassword());
        EntryBagFactory.EntryBag<Entry> primaryBag = EntryBagFactory.newBagCollection(certBag, keyBag, certReqBag, secretKeyBag);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor> primaryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(primaryBag, descriptor, proxy);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor> entryInterface = secondaryItem != null ? EntryInterfaceFactory.newPrimarySecondaryInterface(descriptor, primaryInterface, secondaryItem.entryInterface) : primaryInterface;
        KeyStoreItemImpl<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor> item = new KeyStoreItemImpl<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor>(entryInterface, descriptor, KeyCreatorFactory.getPKCS11KeyCreator(descriptor.getProvider()), DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor.class);
        return item;
    }

    public static KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> newMSCAPIKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException, CancelledException {
        return KeyStoreItemFactory.getMSCAPIKeyStoreItem(descriptor);
    }

    private static KeyStoreItem<DatabaseDescriptorFactory.DatabaseDescriptor> getMSCAPIKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws CancelledException, KeyManagerException {
        descriptor.setPassword("");
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy = descriptor.getType().getCreater().create(descriptor, false);
        KeyStoreProxyCreatorFactory.KeyStoreProxy proxy2 = KeyStoreProxyCreatorFactory.newMSCapiKeyStoreCreater(KeyStoreProxyCreatorFactory.MSCapiType.MY).create(descriptor, false);
        EntryBagFactory.EntryBag<CertificateItem> certBag = EntryBagFactory.newKeyStoreCertificateBag(proxy, ProtectionParameterCreatorFactory.newNullProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<CertificateKeyItem> keyBag = EntryBagFactory.newKeyStoreKeyBag(proxy2, ProtectionParameterCreatorFactory.newPasswordProtectionCreater(), descriptor.getPassword());
        EntryBagFactory.EntryBag<Entry> bag = EntryBagFactory.newBagCollection(certBag, keyBag);
        EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface = EntryInterfaceFactory.newKeyStoreProxyEntryInterface(bag, descriptor, proxy);
        KeyStoreItemImpl<DatabaseDescriptorFactory.DatabaseDescriptor> item = new KeyStoreItemImpl<DatabaseDescriptorFactory.DatabaseDescriptor>(entryInterface, descriptor, KeyCreatorFactory.getDefaultKeyCreator(KeymanUtil.getJCEProviderName()), DatabaseDescriptorFactory.DatabaseDescriptor.class);
        return item;
    }

    private static boolean outputFilesExist(String fileName) {
        return new File(fileName).exists();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CMSKeyStoreItemImpl
    extends KeyStoreItemImpl<DatabaseDescriptorFactory.CMSDatabaseDescriptor>
    implements KeyStoreDefaultCert,
    KeyStoreModifyCert,
    KeyStorePasswordExpiry,
    KeyStorePasswordStash {
        private static Map<KeyStoreItem.ValidationMode, List<EntryValidatorFactory.EntryValidator>> entryValidators = null;

        public CMSKeyStoreItemImpl(EntryInterfaceFactory.EntryInterface<Entry, DatabaseDescriptorFactory.CMSDatabaseDescriptor> entryInterface, DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor, KeyCreatorFactory.KeyCreator keyCreator) {
            super(entryInterface, descriptor, keyCreator, DatabaseDescriptorFactory.CMSDatabaseDescriptor.class);
        }

        @Override
        public void setDefaultCertificate(String label) throws KeyManagerException {
            Object entry = this.getItem(label);
            if (!(entry instanceof CMSKeyItem)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL, label);
            }
            CMSKeyItem item = (CMSKeyItem)entry;
            item.setDefault(true);
            this.addValidItem(item);
        }

        @Override
        public String getDefaultCertificate() throws KeyManagerException {
            Collection<CertificateKeyItem> personalCerts = this.getPersonalCerts();
            for (CertificateKeyItem item : personalCerts) {
                if (item instanceof CMSKeyItem) {
                    if (!((CMSKeyItem)item).isDefault()) continue;
                    return item.getLabel();
                }
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_ITEM_TYPE, item.getClass().toString());
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_DEFAULT_CERTIFICATE);
        }

        @Override
        public void modifyCertificate(String label, boolean trust) throws KeyManagerException {
            Object entry = this.getItem(label);
            if (!(entry instanceof CMSCertificateItem)) {
                if (entry instanceof CMSKeyItem) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.CANNOT_MODIFY_PERSONAL_CERT_TRUST);
                }
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_CERTIFICATE_TYPE, label, entry.getClass().toString());
            }
            CMSCertificateItem item = (CMSCertificateItem)entry;
            item.setTrusted(trust);
            this.addValidItem(item);
            this.save();
        }

        @Override
        public Date getPasswordExpiry() throws KeyManagerException {
            if (((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.getDescriptor()).getPasswordExpiryTime() == 0) {
                return null;
            }
            return new Date((long)((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.getDescriptor()).getPasswordExpiryTime() * 1000L);
        }

        @Override
        public void stashPassword() throws KeyManagerException {
            this.useStash(true);
            this.save();
        }

        public void useStash(boolean value) {
            ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.getDescriptor()).setStash(value);
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.Expire)) {
                Calendar cal = Calendar.getInstance();
                cal.add(6, params.getExpire());
                ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.getDescriptor()).setPasswordExpiryTimeSinceEpoch((int)(cal.getTimeInMillis() / 1000L));
            }
            if (params.isParameterPresent(Constants.Parameter.StashPassword)) {
                this.useStash(params.isStash());
            }
            super.changePassword(params);
            ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.getDescriptor()).setPasswordProtected(!this.getPassword().equals(KeymanSettings.PASSWORDLESS_CMS_PASSWORD));
        }

        @Override
        protected List<EntryValidatorFactory.EntryValidator> getEntryValidators(KeyStoreItem.ValidationMode mode) {
            if (entryValidators == null) {
                entryValidators = new HashMap<KeyStoreItem.ValidationMode, List<EntryValidatorFactory.EntryValidator>>();
                ArrayList<EntryValidatorFactory.EntryValidator> validators = new ArrayList<EntryValidatorFactory.EntryValidator>();
                validators.addAll(super.getEntryValidators(KeyStoreItem.ValidationMode.IMPORT));
                validators.add(EntryValidatorFactory.newPrivateKeyTypeValidator(DSAPrivateKey.class));
                entryValidators.put(KeyStoreItem.ValidationMode.ADD, validators);
                entryValidators.put(KeyStoreItem.ValidationMode.IMPORT, validators);
            }
            return entryValidators.get((Object)mode);
        }

        @Override
        public void validate() throws KeyManagerException {
            if (this.getPasswordExpiry() != null && this.getPasswordExpiry().before(Calendar.getInstance().getTime())) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.DATABASE_PASSWORD_EXPIRED, this.getPasswordExpiry().toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyStoreItemImpl<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends EntryInterfaceFactory.AbstractEntryInterface<T>
    implements KeyStoreItem<T> {
        private static final Map<KeyStoreItem.ValidationMode, List<EntryValidatorFactory.EntryValidator>> entryValidators = new HashMap<KeyStoreItem.ValidationMode, List<EntryValidatorFactory.EntryValidator>>();
        protected EntryInterfaceFactory.EntryInterface<Entry, T> entryInterface;
        private final Class<T> castClass;
        private final KeyCreatorFactory.KeyCreator keyCreator;

        public KeyStoreItemImpl(EntryInterfaceFactory.EntryInterface<Entry, T> entryInterface, T descriptor, KeyCreatorFactory.KeyCreator keyCreator, Class<T> c) {
            super(entryInterface, descriptor);
            this.entryInterface = entryInterface;
            this.keyCreator = keyCreator;
            this.castClass = c;
        }

        protected void addValidItem(Entry item) throws KeyManagerException {
            this.entryInterface.add(item);
            try {
                this.save();
            }
            catch (KeyManagerException e) {
                this.entryInterface.delete(item);
                throw e;
            }
        }

        private void validateEntry(Entry item, KeyStoreItem.ValidationMode mode) throws KeyManagerException {
            List<EntryValidatorFactory.EntryValidator> validators = this.getEntryValidators(mode);
            for (EntryValidatorFactory.EntryValidator validator : validators) {
                validator.validate(item, this);
            }
        }

        protected List<EntryValidatorFactory.EntryValidator> getEntryValidators(KeyStoreItem.ValidationMode mode) {
            return entryValidators.get((Object)mode);
        }

        @Override
        public void addAll(Collection<? extends Entry> items, boolean ignoreDuplicates, boolean ignoreInvalidEntries, KeyStoreItem.ValidationMode mode) throws KeyManagerException {
            for (Entry entry : items) {
                try {
                    this.validateEntry(entry, mode);
                    this.entryInterface.add(entry);
                }
                catch (KeyManagerException e) {
                    if (e.getReason() == KeyManagerException.ExceptionReason.ENTRY_EXISTS_FOR_KEY && ignoreDuplicates || e.getReason() == KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE && ignoreInvalidEntries) continue;
                    throw e;
                }
            }
            this.save();
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            this.entryInterface.changePassword(params);
            this.save();
        }

        @Override
        public boolean checkPassword(String password) {
            return this.entryInterface.getDescriptor().getPassword().equals(password);
        }

        @Override
        public void clear() throws KeyManagerException {
            ArrayList<String> aliases = new ArrayList<String>(this.entryInterface.getAliases());
            for (String alias : aliases) {
                this.entryInterface.delete(alias);
            }
            this.save();
        }

        @Override
        public void close() throws KeyManagerException {
            this.entryInterface.close();
        }

        @Override
        public void delete() throws KeyManagerException {
            this.entryInterface.delete();
        }

        @Override
        public Collection<String> getAliases() {
            TreeSet<String> returnSet = new TreeSet<String>(ComparatorFactory.newCollatedStringComparator());
            returnSet.addAll(this.entryInterface.getAliases());
            return returnSet;
        }

        @Override
        public CertificateItem getCertificate(String label) throws KeyManagerException {
            Object entry = this.entryInterface.getItem(label);
            if (entry instanceof CertificateItem) {
                return (CertificateItem)entry;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_CERTIFICATE_FOR_LABEL, label);
        }

        private static <T extends Entry> Set<T> getEntries(EntryInterfaceFactory.EntryInterface<Entry, ?> entryInterface, FilterFactory.Filter<Entry> filter, Class<T> instanceT) throws KeyManagerException {
            TreeSet<Entry> returnVal = new TreeSet<Entry>(new CertSortComparator(entryInterface));
            Collection<String> aliases = entryInterface.getAliases();
            ArrayList tempCollection = new ArrayList();
            for (String alias : aliases) {
                Object t = entryInterface.getItem(alias);
                tempCollection.add(t);
            }
            Collection<Entry> filtered = filter.filter(tempCollection);
            for (Entry entry : filtered) {
                returnVal.add((Entry)instanceT.cast(entry));
            }
            return returnVal;
        }

        @Override
        public T getDescriptor() {
            return (T)((DatabaseDescriptorFactory.DatabaseDescriptor)this.castClass.cast(this.entryInterface.getDescriptor()));
        }

        @Override
        public Entry getEntry(PublicKey key) throws KeyManagerException {
            ArrayList<PublicKeyItem> items = new ArrayList<PublicKeyItem>();
            items.addAll(this.getCertificates());
            items.addAll(this.getCertificateRequests());
            for (PublicKeyItem item : items) {
                try {
                    PublicKey pk = item.getPublicKey();
                    if (!pk.equals(key)) continue;
                    return (Entry)((Object)item);
                }
                catch (UnsupportedOperationException e) {
                }
            }
            return null;
        }

        @Override
        public Collection<CertificateItem> getCertificates() throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateItem.class), CertificateItem.class);
        }

        protected Collection<CertificateRequestKeyItem> getCertificateRequests() throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateRequestKeyItem.class), CertificateRequestKeyItem.class);
        }

        protected Collection<CertificateKeyItem> getPersonalCerts() throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateKeyItem.class), CertificateKeyItem.class);
        }

        protected Collection<SecretKeyItem> getSecretKeys() throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(SecretKeyItem.class), SecretKeyItem.class);
        }

        @Override
        public KeyStoreInfo getInfo() throws KeyManagerException {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            entries.addAll(this.getCertificates());
            entries.addAll(this.getCertificateRequests());
            entries.addAll(this.getSecretKeys());
            return new KeyStoreInfo((DatabaseDescriptorFactory.DatabaseDescriptor)this.getDescriptor(), this.getKeyCreator(), (List<Entry>)entries, (Collection<Class<? extends Entry>>)this.entryInterface.getSupportedTypes());
        }

        @Override
        public String getPassword() {
            return this.getDescriptor().getPassword();
        }

        public Collection<CertificateItem> getSignerCerts() throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getListWhichFilter(Constants.ListFilter.CA), CertificateItem.class);
        }

        @Override
        public String receiveCertificate(Collection<CertificateItem> newCerts) throws KeyManagerException {
            Entry tempEntry;
            block5: {
                List<CertificateItem> orderedChain = EntryFactory.reorderCertChain(newCerts);
                CertificateItem newCert = orderedChain.remove(0);
                tempEntry = this.getEntry(newCert.getPublicKey());
                if (tempEntry == null || !(tempEntry instanceof PrivateKeyItem)) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_REQUEST_FOR_CERTIFICATE);
                }
                PrivateKey privateKey = ((PrivateKeyItem)((Object)tempEntry)).getPrivateKey();
                Certificate[] chain = new Certificate[]{newCert.getCert()};
                CertificateKeyItem certKeyItem = EntryFactory.newKeyItem(tempEntry.getLabel(), privateKey, chain);
                try {
                    this.addAll(orderedChain, true, false, KeyStoreItem.ValidationMode.ADD);
                    this.addValidItem(certKeyItem);
                    this.refresh();
                    if (this.getDescriptor().getType() == Constants.DatabaseType.CMS && tempEntry instanceof CertificateRequestItem) {
                        this.delete(tempEntry);
                    }
                    if (tempEntry instanceof PrivateKeyItem && !((PrivateKeyItem)((Object)tempEntry)).getPrivateKey().equals(certKeyItem.getPrivateKey())) {
                        this.delete(tempEntry);
                    }
                }
                catch (KeyManagerException e) {
                    if (e.getReason() == KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL) break block5;
                    throw e;
                }
            }
            return tempEntry.getLabel();
        }

        @Override
        public void validate() throws KeyManagerException {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof String) {
                return this.getDescriptor().getFileName().equals(new File((String)obj).getAbsolutePath());
            }
            return super.equals(obj);
        }

        @Override
        public Collection<? extends Entry> getEntries(Class<? extends Entry> c) throws KeyManagerException {
            return KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(c), c);
        }

        @Override
        public <E extends Entry> E getEntry(String label, Class<E> c, KeyManagerException.ExceptionReason reason) throws KeyManagerException {
            Object entry = this.entryInterface.getItem(label);
            if (c.isInstance(entry)) {
                return (E)((Entry)c.cast(entry));
            }
            throw new KeyManagerException(reason, label);
        }

        @Override
        public boolean supportsEntry(Class<? extends Entry> c) {
            return this.entryInterface.getEntryBag(c) != null;
        }

        @Override
        public void add(Entry item) throws KeyManagerException {
            this.validateEntry(item, KeyStoreItem.ValidationMode.ADD);
            this.addValidItem(item);
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            super.delete(label);
            this.save();
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            super.delete(entry);
            this.save();
        }

        @Override
        protected void reload() throws CancelledException, KeyManagerException {
            this.entryInterface.refresh();
        }

        @Override
        public void save() throws KeyManagerException {
            this.entryInterface.save();
        }

        @Override
        public KeyCreatorFactory.KeyCreator getKeyCreator() {
            return this.keyCreator;
        }

        static {
            entryValidators.put(KeyStoreItem.ValidationMode.ADD, new ArrayList());
            entryValidators.put(KeyStoreItem.ValidationMode.IMPORT, new ArrayList());
            entryValidators.get((Object)KeyStoreItem.ValidationMode.ADD).add(EntryValidatorFactory.newDuplicateLabelValidator());
            entryValidators.get((Object)KeyStoreItem.ValidationMode.IMPORT).add(EntryValidatorFactory.newDuplicateKeyValidator());
            entryValidators.get((Object)KeyStoreItem.ValidationMode.IMPORT).add(EntryValidatorFactory.newDuplicateLabelValidator());
        }
    }
}

