/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.PrivateKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import java.security.PrivateKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryValidatorFactory {
    public static EntryValidator newDuplicateLabelValidator() {
        return new DuplicateLabelValidator();
    }

    public static EntryValidator newDuplicateKeyValidator() {
        return new DuplicateKeyValidator();
    }

    public static <T extends PrivateKey> EntryValidator newPrivateKeyTypeValidator(Class<T> notPermitted) {
        return new PrivateKeyTypeValidator<T>(notPermitted);
    }

    private static class DuplicateKeyValidator
    implements EntryValidator {
        private DuplicateKeyValidator() {
        }

        public void validate(Entry entry, KeyStoreItem keyStore) throws KeyManagerException {
        }
    }

    private static class DuplicateLabelValidator
    implements EntryValidator {
        private DuplicateLabelValidator() {
        }

        public void validate(Entry entry, KeyStoreItem keyStore) throws KeyManagerException {
            CertificateItem certificateItemImpl;
            Entry duplicate;
            if (keyStore.contains(entry.getLabel()) && entry instanceof CertificateItem && (duplicate = keyStore.getEntry((certificateItemImpl = (CertificateItem)entry).getPublicKey())) == null) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.ENTRY_EXISTS_FOR_LABEL, entry.getLabel());
            }
        }
    }

    public static interface EntryValidator {
        public void validate(Entry var1, KeyStoreItem var2) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivateKeyTypeValidator<T extends PrivateKey>
    implements EntryValidator {
        private Class<T> notPermitted;

        public PrivateKeyTypeValidator(Class<T> notPermitted) {
            this.notPermitted = notPermitted;
        }

        @Override
        public void validate(Entry entry, KeyStoreItem keyStore) throws KeyManagerException {
            PrivateKeyItem item;
            PrivateKey key;
            if (entry instanceof PrivateKeyItem && this.notPermitted.isInstance(key = (item = (PrivateKeyItem)((Object)entry)).getPrivateKey())) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_TYPE_FOR_KEYSTORE, key.getAlgorithm().toString(), keyStore.getDescriptor().getType().toString());
            }
        }
    }
}

