/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.StateMachineFactory;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.smime.SMIMEMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateParserFactory {
    public static CertificateParser<File> getCertificateParser() {
        return new CompoundParser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ASCIIParser
    implements CertificateParser<byte[]> {
        private ASCIIParser() {
        }

        @Override
        public Collection<? extends Certificate> getCertificates(byte[] inputData, String provider) throws KeyManagerException {
            String fileString = new String(inputData);
            if (!fileString.contains("-----BEGIN CERTIFICATE-----")) {
                throw new UnsuitableParserException();
            }
            try {
                int start = 0;
                int end = 0;
                CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
                ArrayList<? extends Certificate> certs = new ArrayList<Certificate>();
                while ((start = fileString.indexOf("-----BEGIN CERTIFICATE-----", end)) != -1) {
                    end = fileString.indexOf("-----END CERTIFICATE-----", start);
                    String subString = fileString.substring(start, end + "-----END CERTIFICATE-----".length());
                    certs.addAll(cf.generateCertificates(new ByteArrayInputStream(subString.getBytes())));
                }
                return certs;
            }
            catch (NoSuchProviderException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, KeymanUtil.getJCEProviderName());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CORRUPT_CERTIFICATE, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryParser
    implements CertificateParser<byte[]> {
        private BinaryParser() {
        }

        @Override
        public Collection<? extends Certificate> getCertificates(byte[] inputData, String provider) throws KeyManagerException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
                return cf.generateCertificates(new BufferedInputStream(new ByteArrayInputStream(inputData)));
            }
            catch (CertificateException e) {
                Debug.throwing(e);
                throw new UnsuitableParserException();
            }
            catch (NoSuchProviderException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, KeymanUtil.getJCEProviderName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CertificateParser<T> {
        public Collection<? extends Certificate> getCertificates(T var1, String var2) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundParser
    implements CertificateParser<File> {
        private Collection<CertificateParser<byte[]>> parsers = new ArrayList<CertificateParser<byte[]>>();

        public CompoundParser() {
            this.parsers.add(new ASCIIParser());
            this.parsers.add(new PKCS7MimeParser());
            this.parsers.add(new BinaryParser());
        }

        @Override
        public Collection<? extends Certificate> getCertificates(File file, String provider) throws KeyManagerException {
            byte[] fileData;
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                fileData = new byte[((InputStream)is).available()];
                for (int i = 0; i < fileData.length; ++i) {
                    fileData[i] = (byte)((InputStream)is).read();
                }
                ((InputStream)is).close();
            }
            catch (FileNotFoundException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INPUT_FILE_NOT_FOUND, (Throwable)e, file.toString());
            }
            catch (IOException e) {
                if (e.getMessage() != null) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e, e.getMessage());
            }
            for (CertificateParser<byte[]> parser : this.parsers) {
                try {
                    return parser.getCertificates(fileData, provider);
                }
                catch (UnsuitableParserException e) {
                }
                catch (KeyManagerException e) {
                    if (e.getReason() == KeyManagerException.ExceptionReason.INVALID_CERTIFICATE_FILE || e.getReason() == KeyManagerException.ExceptionReason.CORRUPT_CERTIFICATE) {
                        e.addDetail(file.getAbsolutePath());
                    }
                    throw e;
                }
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_CERTIFICATE_FILE, file.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS7MimeParser
    implements CertificateParser<byte[]> {
        private PKCS7MimeParser() {
        }

        @Override
        public Collection<? extends Certificate> getCertificates(byte[] inputData, String provider) throws KeyManagerException {
            try {
                String[] lines = new String(inputData).split("\n");
                StateMachineFactory.PKCS7MimeParser parser = StateMachineFactory.getPKCS7MimeParser();
                for (String line : lines) {
                    parser.handle(line);
                }
                SMIMEMessage msg = new SMIMEMessage(parser.getString().getBytes(), provider);
                if (msg.getContentInfo() != null) {
                    ContentInfo info = msg.getContentInfo();
                    SignedData signedData = (SignedData)info.getContent();
                    return Arrays.asList(signedData.getCertificates());
                }
                throw new IOException("No content info in file.");
            }
            catch (Exception e) {
                Debug.throwing(e);
                throw new UnsuitableParserException();
            }
        }
    }

    private static class UnsuitableParserException
    extends RuntimeException {
        private UnsuitableParserException() {
        }
    }
}

