/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.BrowseAction;
import com.ibm.gsk.ikeyman.gui.panels.FileNameEnum;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileNamePanel
extends KeymanPanel
implements ItemListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private MnemonicLabel comboLabel = null;
    private JComboBox dbTypeCombo = null;
    private MnemonicLabel fileNameLabel = null;
    private JTextField fileNameField = null;
    private JButton browseBtn = null;
    private MnemonicLabel jLabel11 = null;
    private JTextField locationField = null;
    private boolean fileNameLocationChanged = false;
    private boolean fileNameLocationEventEnabled = false;
    private GUIConstants.DialogMode mode;
    private KeymanPanel textPanel = null;
    private KeymanPanel mainPanel = null;
    private FileName databaseName = null;
    private BrowseAction browseAction = new BrowseAction(this);

    protected FileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
        this.mode = mode;
        this.databaseName = databaseName;
        this.initialize();
        this.populateNameAndLocation();
        this.fileNameLocationEventEnabled = true;
    }

    protected FileName getDatabaseName() {
        return this.databaseName;
    }

    private void initialize() {
        this.jLabel11 = new MnemonicLabel();
        this.jLabel11.setText(Messages.getStringWithMnemonics("Label.Location"));
        this.jLabel11.setName(ControlNames.FileNamePanelLocationLabel.toString());
        this.fileNameLabel = new MnemonicLabel();
        this.fileNameLabel.setText(this.getFileNameLabel());
        this.fileNameLabel.setName(ControlNames.FileNamePanelFileNameLabel.toString());
        this.setSize(507, 106);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.extraInitialize();
    }

    protected void extraInitialize() {
    }

    protected abstract String getComboLabel();

    protected abstract String getFileNameLabel();

    protected abstract Object[] getComboValues();

    protected abstract FileFilter getFileFilter();

    protected abstract Map<Object, String> getDefaultLocationMap();

    protected abstract String getComboTooltip();

    protected abstract String getFileNameTooltip();

    protected String getLocationTooltip() {
        return Messages.getString("Tooltip.FileLocation");
    }

    protected boolean fileNameFieldEnabled() {
        return true;
    }

    protected boolean locationFieldEnabled() {
        return true;
    }

    protected boolean browseButtonEnabled() {
        return true;
    }

    public void updateDefaultLocation() {
        this.getDefaultLocationMap().put(this.getComboValue(), this.getFile().getParent());
    }

    private String getDefaultLocation() {
        if (this.getDefaultLocationMap().containsKey(this.getComboValue())) {
            return this.getDefaultLocationMap().get(this.getComboValue());
        }
        return this.getDatabaseName().getDirectory();
    }

    protected FileName getDefaultFileName() {
        String fileName = ((FileNameEnum)this.getComboValue()).getDefaultFileName();
        String location = this.getDefaultLocation();
        return new FileName(new File(location, fileName));
    }

    protected JComboBox getDbTypeCombo() {
        if (this.dbTypeCombo == null) {
            this.dbTypeCombo = new JComboBox<Object>(this.getComboValues());
            this.dbTypeCombo.setSelectedIndex(0);
            this.dbTypeCombo.addItemListener(this);
            this.dbTypeCombo.setToolTipText(this.getComboTooltip());
            this.dbTypeCombo.getAccessibleContext().setAccessibleDescription(this.getComboTooltip());
            this.dbTypeCombo.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.getComboLabel()));
            this.dbTypeCombo.setName(ControlNames.FileNamePanelCombo.toString());
        }
        return this.dbTypeCombo;
    }

    protected Object getComboValue() {
        return this.dbTypeCombo.getSelectedItem();
    }

    protected JLabel getComboLabelControl() {
        if (this.comboLabel == null) {
            this.comboLabel = new MnemonicLabel();
            this.comboLabel.setText(this.getComboLabel());
            this.comboLabel.setName(ControlNames.FileNamePanelComboLabel.toString());
        }
        return this.comboLabel;
    }

    private JTextField getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JTextField();
            this.fileNameField.setColumns(30);
            this.fileNameField.setToolTipText(this.getFileNameTooltip());
            this.fileNameField.getDocument().addDocumentListener(this);
            this.fileNameField.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.getFileNameLabel()));
            this.fileNameField.getAccessibleContext().setAccessibleDescription(this.getFileNameTooltip());
            this.fileNameField.setName(ControlNames.FileNamePanelFileNameField.toString());
        }
        return this.fileNameField;
    }

    private JButton getBrowseBtn() {
        if (this.browseBtn == null) {
            this.browseBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Browse"), ControlNames.FileNamePanelBrowseButton);
            this.browseBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileNamePanel.this.browseAction();
                }
            });
        }
        return this.browseBtn;
    }

    private void browseAction() {
        File f = this.browseAction.getFileName(this.getFileFilter(), this.getSelectedFile(), this.getMode());
        if (f != null) {
            this.locationField.setText(f.getParent());
            this.fileNameField.setText(f.getName());
        }
    }

    private JTextField getLocationField() {
        if (this.locationField == null) {
            this.locationField = new JTextField();
            this.locationField.setColumns(30);
            this.locationField.setName(ControlNames.FileNamePanelLocationField.toString());
            this.locationField.setToolTipText(this.getLocationTooltip());
            this.locationField.getDocument().addDocumentListener(this);
            this.locationField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Location"));
            this.locationField.getAccessibleContext().setAccessibleDescription(this.getLocationTooltip());
        }
        return this.locationField;
    }

    public File getSelectedFile() {
        return new File(this.locationField.getText(), this.fileNameField.getText());
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(10, 5, 4, 0);
            gridBagConstraints6.ipadx = 50;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.fill = 3;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.ipady = 10;
            gridBagConstraints.ipadx = 5;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(10, 10, 4, 4);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.ipady = -5;
            gridBagConstraints4.ipadx = 3;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.insets = new Insets(5, 5, 4, 7);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 4);
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.fill = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 4);
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.ipady = 5;
            gridBagConstraints2.ipadx = 59;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(5, 10, 10, 4);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.ipady = 5;
            gridBagConstraints1.ipadx = 53;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(5, 10, 4, 4);
            this.textPanel = new KeymanPanel();
            this.textPanel.setLayout(new GridBagLayout());
            this.textPanel.add((Component)this.fileNameLabel, gridBagConstraints1);
            this.textPanel.add((Component)this.jLabel11, gridBagConstraints2);
            this.textPanel.add((Component)this.getFileNameField(), gridBagConstraints3);
            this.textPanel.add((Component)this.getLocationField(), gridBagConstraints5);
            this.textPanel.add((Component)this.getBrowseBtn(), gridBagConstraints4);
            if (this.getComboLabelControl() != null) {
                this.textPanel.add((Component)this.getComboLabelControl(), gridBagConstraints);
                this.textPanel.add((Component)this.getDbTypeCombo(), gridBagConstraints6);
                this.getComboLabelControl().setLabelFor(this.getDbTypeCombo());
            }
            this.jLabel11.setLabelFor(this.locationField);
            this.fileNameLabel.setLabelFor(this.fileNameField);
        }
        return this.textPanel;
    }

    public abstract ParameterMap getParameters() throws KeyManagerException;

    protected File getFile() {
        return new File(this.locationField.getText(), this.fileNameField.getText());
    }

    public boolean isValidInput() {
        if (this.fileNameField.isEnabled() && this.fileNameField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.FileName")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        if (this.locationField.isEnabled() && this.locationField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.Location")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        return true;
    }

    protected GUIConstants.DialogMode getMode() {
        return this.mode;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new KeymanPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getTextPanel(), "Center");
        }
        return this.mainPanel;
    }

    public void setMode(GUIConstants.DialogMode mode) {
        this.mode = mode;
    }

    private void populateNameAndLocation() {
        FileName name = this.getDefaultFileName();
        this.fileNameField.setText(name != null ? name.getFile() : "");
        this.locationField.setText(name != null ? name.getDirectory() + File.separatorChar : "");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.dbTypeCombo)) {
            this.fileNameLocationEventEnabled = false;
            if (!this.fileNameLocationChanged) {
                this.populateNameAndLocation();
            }
            this.fileNameField.setEnabled(this.fileNameFieldEnabled());
            this.locationField.setEnabled(this.locationFieldEnabled());
            this.browseBtn.setEnabled(this.browseButtonEnabled());
            this.fileNameLocationEventEnabled = true;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleInputFieldChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleInputFieldChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleInputFieldChange();
    }

    private void handleInputFieldChange() {
        if (this.fileNameLocationEventEnabled) {
            this.fileNameLocationChanged = true;
        }
    }

    public void setFile(String string) {
        FileName name = new FileName(string);
        this.fileNameField.setText(name.getFile());
        this.locationField.setText(name.getDirectory());
    }
}

