/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DatabaseInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel typeLabel = null;
    private JLabel fileNameLabel = null;
    private JLabel tokenLabel = null;
    private JTextField typeField = null;
    private JTextField fileNameField = null;
    private JTextField tokenLabelField = null;

    public DatabaseInfoPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.ipadx = 327;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(3, 7, 6, 4);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.ipadx = 327;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(3, 7, 2, 4);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.ipadx = 327;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 7, 2, 4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(3, 5, 10, 7);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.ipadx = 9;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(3, 5, 6, 17);
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.ipadx = 13;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 6, 27);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 11;
        this.tokenLabel = new JLabel();
        this.tokenLabel.setText(Messages.getString("Label.TokenLabel"));
        this.tokenLabel.setName(ControlNames.DatabaseInfoPanelTokenLabelLabel.toString());
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setText(Messages.getString("Label.FileName"));
        this.fileNameLabel.setName(ControlNames.DatabaseInfoPanelFileNameLabel.toString());
        this.typeLabel = new JLabel();
        this.typeLabel.setText(Messages.getString("Label.DBType"));
        this.typeLabel.setName(ControlNames.DatabaseInfoPanelDBTypeLabel.toString());
        this.setSize(431, 110);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("Label.KeyDatabaseInfo"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.add((Component)this.fileNameLabel, gridBagConstraints1);
        this.add((Component)this.tokenLabel, gridBagConstraints2);
        this.add((Component)this.getTypeField(), gridBagConstraints3);
        this.add((Component)this.getFileNameField(), gridBagConstraints4);
        this.add((Component)this.getTokenLabelField(), gridBagConstraints5);
        this.setName(ControlNames.DatabaseInfoPanel.toString());
    }

    private JTextField getTypeField() {
        if (this.typeField == null) {
            this.typeField = new JTextField();
            this.typeField.setEnabled(true);
            this.typeField.setEditable(false);
            this.typeField.setFocusable(false);
            this.typeField.getAccessibleContext().setAccessibleName(Messages.getString("Label.DBType"));
        }
        return this.typeField;
    }

    private JTextField getFileNameField() {
        if (this.fileNameField == null) {
            this.fileNameField = new JTextField();
            this.fileNameField.setEnabled(true);
            this.fileNameField.setEditable(false);
            this.fileNameField.setFocusable(false);
            this.fileNameField.getAccessibleContext().setAccessibleName(Messages.getString("Label.FileName"));
        }
        return this.fileNameField;
    }

    private JTextField getTokenLabelField() {
        if (this.tokenLabelField == null) {
            this.tokenLabelField = new JTextField();
            this.tokenLabelField.setEnabled(true);
            this.tokenLabelField.setEditable(false);
            this.tokenLabelField.setFocusable(false);
            this.tokenLabelField.getAccessibleContext().setAccessibleName(Messages.getString("Label.TokenLabel"));
        }
        return this.tokenLabelField;
    }

    public void refreshDatabase(KeyStoreInfo keyStoreItem) {
        if (keyStoreItem != null) {
            this.typeField.setText(keyStoreItem.getDescriptor().getType().toString());
            this.fileNameField.setText(keyStoreItem.getDescriptor().getFileNameString());
            if (keyStoreItem.getDescriptor() instanceof DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor) {
                String slotText = ((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptor)keyStoreItem.getDescriptor()).getName();
                this.tokenLabelField.setText(slotText);
            } else {
                this.tokenLabelField.setText("");
            }
        } else {
            this.typeField.setText("");
            this.fileNameField.setText("");
            this.tokenLabelField.setText("");
        }
    }
}

