/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.gui.panels.CertRequestButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.gui.panels.PersonalCertsButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.SecretKeyButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.SignerCertsButtonPanel;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractUnloadableEntry;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentsPanel
extends KeymanPanel {
    private static final String comboAction = "ComboAction";
    private static final long serialVersionUID = 1L;
    private KeymanPanel eastPanel = null;
    private JList itemList = null;
    private PersonalCertsButtonPanel personalCertsButtonPanel = null;
    private CertRequestButtonPanel certRequestButtonPanel = null;
    private SignerCertsButtonPanel signerCertsButtonPanel = null;
    private SecretKeyButtonPanel secretKeyButtonPanel = null;
    private Entry[] personalCerts = null;
    private Entry[] signerCerts = null;
    private Entry[] certRequests = null;
    private Entry[] secretKeys = null;
    private DatabaseDescriptorFactory.DatabaseDescriptor descriptor = null;
    private JScrollPane jScrollPane = null;
    private JPanel centrePanel = null;
    private JComboBox listSelectCombo = null;

    public ContentsPanel() {
        this.initialize();
        this.listSelectCombo.setSelectedIndex(0);
    }

    private void initialize() {
        this.setSize(588, 473);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("Label.KeyDatabaseContent"), 2, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getEastPanel(), "East");
        this.add((Component)this.getCentrePanel(), "Center");
        this.setName(ControlNames.ContentsPanel.toString());
    }

    private JPanel getEastPanel() {
        if (this.eastPanel == null) {
            this.eastPanel = new KeymanPanel();
            this.eastPanel.setLayout(new CardLayout());
            this.eastPanel.add((Component)this.getPersonalCertsButtonPanel(), this.getPersonalCertsButtonPanel().getName());
            this.eastPanel.add((Component)this.getCertRequestButtonPanel(), this.getCertRequestButtonPanel().getName());
            this.eastPanel.add((Component)this.getSignerCertsButtonPanel(), this.getSignerCertsButtonPanel().getName());
            this.eastPanel.add((Component)this.getSecretKeyButtonPanel(), this.getSecretKeyButtonPanel().getName());
        }
        return this.eastPanel;
    }

    private JComboBox getListSelectCombo() {
        if (this.listSelectCombo == null) {
            this.listSelectCombo = new JComboBox<ListSelectItem>(ListSelectItem.getSupportedValues());
            this.listSelectCombo.setActionCommand(comboAction);
            this.listSelectCombo.addActionListener(this);
            this.listSelectCombo.setToolTipText(Messages.getString("Tooltip.ObjectsInDB"));
            this.listSelectCombo.getAccessibleContext().setAccessibleName(Messages.getString("Accessibility.Name.ListSelectCombo"));
            this.listSelectCombo.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.ObjectsInDB"));
            this.listSelectCombo.setName(ControlNames.ContentsPanelListSelectCombo.toString());
        }
        return this.listSelectCombo;
    }

    private JList getItemList() {
        if (this.itemList == null) {
            this.itemList = new JList();
            this.itemList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ContentsPanel.this.itemDoubleClickedHandler();
                    }
                }
            });
            this.itemList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof AbstractUnloadableEntry) {
                        this.setForeground(Color.RED);
                    } else if (value instanceof CertificateKeyItem && !CommandFactory.isValidCertPath(((CertificateItem)value).getLabel())) {
                        this.setBackground(Color.YELLOW);
                    }
                    return this;
                }
            });
            this.itemList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    boolean hasUncoverable = false;
                    if (!e.getValueIsAdjusting()) {
                        List<Object> selectedValuesList = null;
                        try {
                            selectedValuesList = ContentsPanel.this.itemList.getSelectedValuesList();
                        }
                        catch (NoSuchMethodError e1) {
                            Object[] objectArray = ContentsPanel.this.itemList.getSelectedValues();
                            selectedValuesList = new ArrayList();
                            for (Object o : objectArray) {
                                selectedValuesList.add(o);
                            }
                        }
                        for (Object e2 : selectedValuesList) {
                            if (!(e2 instanceof AbstractUnloadableEntry)) continue;
                            ContentsPanel.this.disableUncoverableButtons();
                            hasUncoverable = true;
                            break;
                        }
                        if (!hasUncoverable && selectedValuesList.size() > 0) {
                            ContentsPanel.this.updateButtons(true);
                        }
                    }
                }
            });
        }
        return this.itemList;
    }

    private void disableUncoverableButtons() {
        ListSelectItem selectedItem = (ListSelectItem)((Object)this.listSelectCombo.getSelectedItem());
        if (selectedItem != null) {
            if (selectedItem.equals((Object)ListSelectItem.PersonalCerts)) {
                this.personalCertsButtonPanel.disableUncoverableButtons();
            } else if (selectedItem.equals((Object)ListSelectItem.SignerCerts)) {
                this.signerCertsButtonPanel.disableUncoverableButtons();
            } else if (selectedItem.equals((Object)ListSelectItem.CertificateRequests)) {
                this.certRequestButtonPanel.disableUncoverableButtons();
            } else if (selectedItem.equals((Object)ListSelectItem.SecretKeys)) {
                this.secretKeyButtonPanel.disableUncoverableButtons();
            }
        }
    }

    private void itemDoubleClickedHandler() {
        if (this.itemList.getSelectedIndex() != -1) {
            Constants.CommandType commandType = ((ListSelectItem)((Object)this.listSelectCombo.getSelectedItem())).getDefaultCommand();
            this.fireActionPerformed(new ActionEvent(this, 0, commandType.toString()));
        }
    }

    private PersonalCertsButtonPanel getPersonalCertsButtonPanel() {
        if (this.personalCertsButtonPanel == null) {
            this.personalCertsButtonPanel = new PersonalCertsButtonPanel();
            this.personalCertsButtonPanel.setName("personalCertsButtonPanel");
            this.personalCertsButtonPanel.addActionListener(this);
        }
        return this.personalCertsButtonPanel;
    }

    private CertRequestButtonPanel getCertRequestButtonPanel() {
        if (this.certRequestButtonPanel == null) {
            this.certRequestButtonPanel = new CertRequestButtonPanel();
            this.certRequestButtonPanel.setName("certRequestButtonPanel");
            this.certRequestButtonPanel.addActionListener(this);
        }
        return this.certRequestButtonPanel;
    }

    private SignerCertsButtonPanel getSignerCertsButtonPanel() {
        if (this.signerCertsButtonPanel == null) {
            this.signerCertsButtonPanel = new SignerCertsButtonPanel();
            this.signerCertsButtonPanel.setName("signerCertsButtonPanel");
            this.signerCertsButtonPanel.addActionListener(this);
        }
        return this.signerCertsButtonPanel;
    }

    private SecretKeyButtonPanel getSecretKeyButtonPanel() {
        if (this.secretKeyButtonPanel == null) {
            this.secretKeyButtonPanel = new SecretKeyButtonPanel();
            this.secretKeyButtonPanel.setName("secretKeyButtonPanel");
            this.secretKeyButtonPanel.addActionListener(this);
        }
        return this.secretKeyButtonPanel;
    }

    private void updateDisplay() {
        Entry[] displayList = null;
        String tooltip = null;
        switch ((ListSelectItem)((Object)this.listSelectCombo.getSelectedItem())) {
            case PersonalCerts: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getPersonalCertsButtonPanel().getName());
                displayList = this.personalCerts;
                tooltip = Messages.getString("Tooltip.PersonalCertList");
                break;
            }
            case SignerCerts: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getSignerCertsButtonPanel().getName());
                displayList = this.signerCerts;
                tooltip = Messages.getString("Tooltip.CAList");
                break;
            }
            case CertificateRequests: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getCertRequestButtonPanel().getName());
                displayList = this.certRequests;
                tooltip = Messages.getString("Tooltip.CertReqList");
                break;
            }
            case SecretKeys: {
                ((CardLayout)this.eastPanel.getLayout()).show(this.eastPanel, this.getSecretKeyButtonPanel().getName());
                displayList = this.secretKeys;
                tooltip = Messages.getString("Tooltip.SecretKeyList");
            }
        }
        this.itemList.setToolTipText(tooltip);
        if (displayList == null) {
            this.eastPanel.setEnabled(false);
            this.itemList.setListData(new String[0]);
        } else {
            this.eastPanel.setEnabled(true);
            this.itemList.setListData(displayList);
            if (displayList.length > 0) {
                this.itemList.setSelectedIndex(0);
                this.updateButtons(true);
            } else {
                this.updateButtons(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(comboAction)) {
            this.updateDisplay();
            this.fireActionPerformed(new ActionEvent(this, this.listSelectCombo.getSelectedIndex(), Constants.CommandType.RefreshLists.toString()));
        } else {
            super.actionPerformed(e);
        }
    }

    public void refreshDatabase(KeyStoreInfo keyStoreItem) {
        if (keyStoreItem != null) {
            this.personalCerts = keyStoreItem.getPersonalCerts().toArray(new Entry[0]);
            this.signerCerts = keyStoreItem.getSignerCerts().toArray(new Entry[0]);
            this.certRequests = keyStoreItem.getCertificateRequests().toArray(new Entry[0]);
            this.secretKeys = keyStoreItem.getSecretKeys().toArray(new Entry[0]);
            this.descriptor = keyStoreItem.getDescriptor();
            if (ListSelectItem.updateSupportedValues(keyStoreItem)) {
                this.listSelectCombo.setModel(new DefaultComboBoxModel<ListSelectItem>(ListSelectItem.getSupportedValues()));
            }
        } else {
            this.personalCerts = null;
            this.signerCerts = null;
            this.certRequests = null;
            this.secretKeys = null;
            this.descriptor = null;
        }
        this.updateDisplay();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getItemList());
        }
        return this.jScrollPane;
    }

    private JPanel getCentrePanel() {
        if (this.centrePanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.ipady = 270;
            gridBagConstraints3.ipadx = 148;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 5, 6, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.ipady = 1;
            gridBagConstraints2.ipadx = 375;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(5, 5, 4, 11);
            this.centrePanel = new JPanel();
            this.centrePanel.setLayout(new GridBagLayout());
            this.centrePanel.add((Component)this.getListSelectCombo(), gridBagConstraints2);
            this.centrePanel.add((Component)this.getJScrollPane(), gridBagConstraints3);
        }
        return this.centrePanel;
    }

    public Entry getSelectedEntry() {
        return (Entry)this.itemList.getSelectedValue();
    }

    public Collection<Entry> getSelectedEntries() {
        Object[] selected = this.itemList.getSelectedValues();
        ArrayList<Entry> returnList = new ArrayList<Entry>();
        for (Object obj : selected) {
            returnList.add((Entry)obj);
        }
        return returnList;
    }

    private void updateButtons(boolean isItemSelected) {
        ListSelectItem selectedItem = (ListSelectItem)((Object)this.listSelectCombo.getSelectedItem());
        if (selectedItem != null) {
            if (selectedItem.equals((Object)ListSelectItem.PersonalCerts)) {
                this.personalCertsButtonPanel.updateButtons(isItemSelected, this.descriptor);
            } else if (selectedItem.equals((Object)ListSelectItem.SignerCerts)) {
                this.signerCertsButtonPanel.updateButtons(isItemSelected, this.descriptor);
            } else if (selectedItem.equals((Object)ListSelectItem.CertificateRequests)) {
                this.certRequestButtonPanel.updateButtons(isItemSelected, this.descriptor);
            } else if (selectedItem.equals((Object)ListSelectItem.SecretKeys)) {
                this.secretKeyButtonPanel.updateButtons(isItemSelected, this.descriptor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListSelectItem {
        PersonalCerts("Label.PersonalCertificates", CertificateKeyItem.class, Constants.CommandType.DisplayCert, null),
        SignerCerts("Label.SignerCertificates", CertificateItem.class, Constants.CommandType.DisplayCert, null),
        CertificateRequests("Label.CertificateRequests", CertificateRequestKeyItem.class, Constants.CommandType.DisplayCertRequest, null),
        SecretKeys("Label.SecretKeys", SecretKeyItem.class, Constants.CommandType.DisplaySecretKey, KeymanSettings.Setting.SecretKeyFunctionEnabled);

        private String stringValueKey;
        private boolean supported = true;
        private Class<? extends Entry> entryClass;
        private Constants.CommandType commandType;
        private KeymanSettings.Setting enabledSetting;

        private ListSelectItem(String valueKey, Class<? extends Entry> entryClass, Constants.CommandType type, KeymanSettings.Setting enabledSetting) {
            this.stringValueKey = valueKey;
            this.entryClass = entryClass;
            this.commandType = type;
            this.enabledSetting = enabledSetting;
        }

        public String toString() {
            return Messages.getString(this.stringValueKey);
        }

        public static boolean updateSupportedValues(KeyStoreInfo info) {
            boolean changed = false;
            for (ListSelectItem item : ListSelectItem.values()) {
                boolean isSupported = info.isEntrySupported(item.entryClass);
                changed |= isSupported != item.supported;
                item.supported = isSupported;
            }
            return changed;
        }

        public static ListSelectItem[] getSupportedValues() {
            ListSelectItem[] allValues = ListSelectItem.values();
            ArrayList<ListSelectItem> supportedValues = new ArrayList<ListSelectItem>();
            for (ListSelectItem value : allValues) {
                if (!value.supported || !value.isEnabled()) continue;
                supportedValues.add(value);
            }
            return supportedValues.toArray(new ListSelectItem[0]);
        }

        private boolean isEnabled() {
            return this.enabledSetting == null ? true : this.enabledSetting.getBoolean();
        }

        public Constants.CommandType getDefaultCommand() {
            return this.commandType;
        }
    }
}

