/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CertificateDataPanel
extends InputPanelFactory.InputJPanel {
    private static final X509Version[] versions = X509Version.values();
    private static final Integer[] keySizes = new Integer[]{new Integer(512), new Integer(1024), new Integer(2048), new Integer(4096)};
    private static final Integer[] keySizesEC = new Integer[]{new Integer(192), new Integer(224), new Integer(256), new Integer(384), new Integer(521)};
    private static final long serialVersionUID = 1L;
    private JLabel keyLabelLabel = null;
    private JLabel versionLabel = null;
    private JLabel keySizeLabel = null;
    private JLabel cnLabel = null;
    private JLabel orgLabel = null;
    private JLabel ouLabel = null;
    private JLabel localityLabel = null;
    private JLabel stateProvinceLabel = null;
    private JLabel zipLabel = null;
    private JLabel countryLabel = null;
    private JLabel validityLabel = null;
    private JLabel jLabel11 = null;
    private JLabel jLabel12 = null;
    private JLabel jLabel13 = null;
    private JLabel jLabel14 = null;
    private JLabel signatureAlgorithmLabel = null;
    private JTextField labelField = null;
    private JTextField commonNameField = null;
    private JTextField organizationField = null;
    private JTextField organizationUnitField = null;
    private JTextField localityField = null;
    private JTextField stateField = null;
    private JTextField zipCodeField = null;
    private JComboBox versionCombo = null;
    private boolean isKeySizeText = true;
    private JComboBox keySizeCombo = null;
    private JComboBox keySizeComboEC = null;
    private JComboBox countryCombo = null;
    private JComboBox signatureAlgorithmCombo = null;
    private JFormattedTextField validityField = null;
    private JPanel validtyPanel = null;
    private JLabel jLabel15 = null;
    private InputPanelFactory.InputDialogType inputDialogType = InputPanelFactory.InputDialogType.SelfsignedCertificate;
    private JLabel jLabel111 = null;
    private JLabel jLabel1111 = null;
    private JTextField emailField = null;
    private JTextField ipField = null;
    private JTextField dnsField = null;
    private JLabel emailOptionalLbl = null;
    private JLabel emailLbl = null;
    private JLabel ipLbl = null;
    private JLabel dnsLbl = null;
    private JLabel ipOptionalLbl = null;
    private JLabel dnsOptionalLbl = null;
    private JLabel sanLbl = null;
    private JLabel jLabel1112 = null;

    public CertificateDataPanel(InputPanelFactory.InputDialogType inputDialogType) {
        this.inputDialogType = inputDialogType;
        this.initialize();
    }

    protected CertificateDataPanel() {
        this.initialize();
    }

    private void initialize() {
        this.jLabel1112 = new JLabel(Messages.getString("Label.Optional"));
        this.sanLbl = new JLabel(Messages.getString("Label.SAN"));
        this.sanLbl.setName(ControlNames.CertificateDataPanelSanLabel.toString());
        this.dnsOptionalLbl = new JLabel(Messages.getString("Label.Optional"));
        this.ipOptionalLbl = new JLabel(Messages.getString("Label.Optional"));
        this.dnsLbl = new MnemonicLabel(Messages.getStringWithMnemonics("Label.DNS"));
        this.dnsLbl.setName(ControlNames.CertificateDataPanelDNSLabel.toString());
        this.ipLbl = new MnemonicLabel(Messages.getStringWithMnemonics("Label.IP"));
        this.ipLbl.setName(ControlNames.CertificateDataPanelIPLabel.toString());
        this.emailLbl = new MnemonicLabel(Messages.getStringWithMnemonics("Label.Email"));
        this.emailLbl.setName(ControlNames.CertificateDataPanelEmailLabel.toString());
        this.emailOptionalLbl = new JLabel(Messages.getString("Label.Optional"));
        this.jLabel1111 = new JLabel();
        this.jLabel1111.setText(Messages.getString("Label.Optional"));
        this.jLabel111 = new JLabel();
        this.jLabel111.setText(Messages.getString("Label.Optional"));
        this.jLabel14 = new JLabel(Messages.getString("Label.Optional"));
        this.jLabel13 = new JLabel(Messages.getString("Label.Optional"));
        this.jLabel12 = new JLabel(Messages.getString("Label.Optional"));
        this.jLabel11 = new JLabel(Messages.getString("Label.Optional"));
        this.jLabel11.setName(ControlNames.CertificateDataPanelOptionalLabel.toString());
        this.validityLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.ValidityPeriod"));
        this.validityLabel.setName(ControlNames.CertificateDataPanelValidityLabel.toString());
        this.countryLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.CountryOrRegion"));
        this.countryLabel.setName(ControlNames.CertificateDataPanelCountryOrRegionLabel.toString());
        this.zipLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.Zip"));
        this.zipLabel.setName(ControlNames.CertificateDataPanelZipLabel.toString());
        this.stateProvinceLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.StateProvince"));
        this.stateProvinceLabel.setName(ControlNames.CertificateDataPanelStateProvinceLabel.toString());
        this.localityLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.Locality"));
        this.localityLabel.setName(ControlNames.CertificateDataPanelLocalityLabel.toString());
        this.ouLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.OU"));
        this.ouLabel.setName(ControlNames.CertificateDataPanelOULabel.toString());
        this.orgLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.Org"));
        this.orgLabel.setName(ControlNames.CertificateDataPanelOrgLabel.toString());
        this.cnLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.CN"));
        this.cnLabel.setName(ControlNames.CertificateDataPanelCNLabel.toString());
        this.signatureAlgorithmLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.SigAlg"));
        this.signatureAlgorithmLabel.setName(ControlNames.CertificateDataPanelSigAlgLabel.toString());
        this.keySizeLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.KeySize"));
        this.keySizeLabel.setName(ControlNames.CertificateDataPanelKeySizeLabel.toString());
        this.versionLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.Version"));
        this.versionLabel.setName(ControlNames.CertificateDataPanelVersionLabel.toString());
        this.keyLabelLabel = new MnemonicLabel(Messages.getStringWithMnemonics("Label.KeyLabel"));
        this.keyLabelLabel.setName(ControlNames.CertificateDataPanelKeyLabelLabel.toString());
        this.setSize(399, 365);
        this.setLayout(new GridBagLayout());
        this.setName(ControlNames.CertificateDataPanel.toString());
        this.addComponent(this, this.keyLabelLabel, 0, 0, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.keySizeLabel, 0, 2, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.cnLabel, 0, 4, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.orgLabel, 0, 5, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.ouLabel, 0, 6, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.localityLabel, 0, 7, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.stateProvinceLabel, 0, 8, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.zipLabel, 0, 9, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.countryLabel, 0, 10, new Insets(0, 10, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel11, 1, 4, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel12, 1, 5, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel13, 1, 6, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel14, 1, 7, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel111, 1, 8, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel1111, 1, 9, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.jLabel1112, 1, 10, new Insets(0, 0, 0, 0), 1, 17, 0);
        this.addComponent(this, this.getLabelField(), 2, 0, new Insets(3, 5, 3, 5), 1, 17, 2, 1.0);
        this.addComponent(this, this.getCommonNameField(), 2, 4, new Insets(3, 5, 3, 5), 1, 17, 2);
        this.addComponent(this, this.getOrganizationField(), 2, 5, new Insets(3, 5, 3, 5), 1, 17, 2);
        this.addComponent(this, this.getOrganizationUnitField(), 2, 6, new Insets(3, 5, 3, 5), 1, 17, 2);
        this.addComponent(this, this.getLocalityField(), 2, 7, new Insets(3, 5, 3, 5), 1, 17, 2);
        this.addComponent(this, this.getStateField(), 2, 8, new Insets(3, 5, 3, 100), 1, 17, 2);
        this.addComponent(this, this.getZipCodeField(), 2, 9, new Insets(3, 5, 3, 100), 1, 17, 2);
        this.keySizeCombo = this.getKeySizeCombo(keySizes);
        this.addComponent(this, this.keySizeCombo, 2, 2, new Insets(3, 5, 3, 0), 1, 17, 0);
        this.keySizeComboEC = this.getKeySizeCombo(keySizesEC);
        this.addComponent(this, this.keySizeComboEC, 2, 2, new Insets(3, 5, 3, 0), 1, 17, 0);
        this.keySizeComboEC.setEnabled(this.isKeySizeText);
        this.keySizeComboEC.setVisible(this.isKeySizeText);
        this.keySizeCombo.setEnabled(!this.isKeySizeText);
        this.keySizeCombo.setVisible(!this.isKeySizeText);
        this.addComponent(this, this.getCountryCombo(), 2, 10, new Insets(3, 5, 3, 0), 1, 17, 3);
        if (this.inputDialogType == InputPanelFactory.InputDialogType.SelfsignedCertificate) {
            this.addComponent(this, this.versionLabel, 0, 1, new Insets(0, 10, 0, 0), 1, 17, 0);
            this.addComponent(this, this.validityLabel, 0, 11, new Insets(0, 10, 0, 0), 1, 17, 0);
            this.addComponent(this, this.getVersionCombo(), 2, 1, new Insets(3, 5, 3, 0), 1, 17, 3);
            this.addComponent(this, this.getValidityField(), 2, 11, new Insets(3, 5, 0, 0), 1, 17, 0);
            this.jLabel15 = new JLabel(Messages.getString("Label.Days"));
            this.addComponent(this, this.jLabel15, 2, 11, new Insets(3, 70, 0, 0), 1, 17, 0);
            this.versionLabel.setLabelFor(this.getVersionCombo());
            this.validityLabel.setLabelFor(this.getValidityField());
        }
        if (KeymanSettings.Setting.SANEnabled.getBoolean().booleanValue()) {
            this.addComponent(this, this.getEmailField(), 2, 13, new Insets(3, 5, 3, 5), 1, 17, 1);
            this.addComponent(this, this.getIpField(), 2, 14, new Insets(3, 5, 3, 5), 1, 17, 1);
            this.addComponent(this, this.getDnsField(), 2, 15, new Insets(3, 5, 3, 5), 1, 17, 1);
            this.addComponent(this, this.emailLbl, 0, 13, new Insets(0, 20, 0, 0), 1, 17, 0);
            this.addComponent(this, this.ipLbl, 0, 14, new Insets(0, 20, 0, 0), 1, 17, 0);
            this.addComponent(this, this.dnsLbl, 0, 15, new Insets(0, 20, 0, 0), 1, 17, 0);
            this.addComponent(this, this.emailOptionalLbl, 1, 13, new Insets(0, 0, 0, 0), 1, 17, 0);
            this.addComponent(this, this.ipOptionalLbl, 1, 14, new Insets(0, 0, 0, 0), 1, 17, 0);
            this.addComponent(this, this.dnsOptionalLbl, 1, 15, new Insets(0, 0, 0, 0), 1, 17, 0);
            this.addComponent(this, this.sanLbl, 0, 12, new Insets(4, 10, 3, 0), 2, 17, 0);
            this.emailLbl.setLabelFor(this.getEmailField());
            this.ipLbl.setLabelFor(this.getIpField());
            this.dnsLbl.setLabelFor(this.getDnsField());
        }
        if (KeymanSettings.Setting.SignatureAlgorithmFunctionEnabled.getBoolean().booleanValue()) {
            this.addComponent(this, this.signatureAlgorithmLabel, 0, 3, new Insets(0, 10, 0, 0), 1, 17, 0);
            this.signatureAlgorithmCombo = this.getSignatureAlgorithmCombo();
            this.addComponent(this, this.signatureAlgorithmCombo, 2, 3, new Insets(3, 5, 3, 0), 1, 17, 3);
            this.signatureAlgorithmCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CertificateDataPanel.this.isKeySizeText = KeymanUtil.getKeyType(CertificateDataPanel.this.getSigAlg().toString()).equals("EC");
                    CertificateDataPanel.this.keySizeComboEC.setEnabled(CertificateDataPanel.this.isKeySizeText);
                    CertificateDataPanel.this.keySizeComboEC.setVisible(CertificateDataPanel.this.isKeySizeText);
                    CertificateDataPanel.this.keySizeCombo.setEnabled(!CertificateDataPanel.this.isKeySizeText);
                    CertificateDataPanel.this.keySizeCombo.setVisible(!CertificateDataPanel.this.isKeySizeText);
                    if (CertificateDataPanel.this.isKeySizeText) {
                        CertificateDataPanel.this.keySizeLabel.setLabelFor(CertificateDataPanel.this.keySizeComboEC);
                    } else {
                        CertificateDataPanel.this.keySizeLabel.setLabelFor(CertificateDataPanel.this.keySizeCombo);
                    }
                }
            });
            this.signatureAlgorithmLabel.setLabelFor(this.signatureAlgorithmCombo);
        }
        this.keyLabelLabel.setLabelFor(this.getLabelField());
        if (this.isKeySizeText) {
            this.keySizeLabel.setLabelFor(this.keySizeComboEC);
        } else {
            this.keySizeLabel.setLabelFor(this.keySizeCombo);
        }
        this.cnLabel.setLabelFor(this.getCommonNameField());
        this.orgLabel.setLabelFor(this.getOrganizationField());
        this.ouLabel.setLabelFor(this.getOrganizationUnitField());
        this.localityLabel.setLabelFor(this.getLocalityField());
        this.stateProvinceLabel.setLabelFor(this.getStateField());
        this.zipLabel.setLabelFor(this.getZipCodeField());
        this.countryLabel.setLabelFor(this.getCountryCombo());
        this.resetFields();
    }

    private JTextField getLabelField() {
        if (this.labelField == null) {
            this.labelField = new JTextField();
            this.labelField.setToolTipText(Messages.getString("Tooltip.KeyLabel"));
            this.labelField.getAccessibleContext().setAccessibleName(Messages.getString("Label.KeyLabel"));
            this.labelField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.KeyLabel"));
            this.labelField.setName(ControlNames.CertificateDataPanelKeyLabelField.toString());
        }
        return this.labelField;
    }

    private JTextField getCommonNameField() {
        if (this.commonNameField == null) {
            this.commonNameField = new JTextField(KeymanUtil.getHostName());
            this.commonNameField.setToolTipText(Messages.getString("Tooltip.CommonName"));
            this.commonNameField.getAccessibleContext().setAccessibleName(Messages.getString("Label.CN"));
            this.commonNameField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.CommonName"));
            this.commonNameField.setName(ControlNames.CertificateDataPanelCNField.toString());
        }
        return this.commonNameField;
    }

    private JTextField getOrganizationField() {
        if (this.organizationField == null) {
            this.organizationField = new JTextField();
            this.organizationField.setToolTipText(Messages.getString("Tooltip.Organization"));
            this.organizationField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Org"));
            this.organizationField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Organization"));
            this.organizationField.setName(ControlNames.CertificateDataPanelOrgField.toString());
        }
        return this.organizationField;
    }

    private JTextField getOrganizationUnitField() {
        if (this.organizationUnitField == null) {
            this.organizationUnitField = new JTextField();
            this.organizationUnitField.setToolTipText(Messages.getString("Tooltip.OU"));
            this.organizationUnitField.getAccessibleContext().setAccessibleName(Messages.getString("Label.OU"));
            this.organizationUnitField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.OU"));
            this.organizationUnitField.setName(ControlNames.CertificateDataPanelOUField.toString());
        }
        return this.organizationUnitField;
    }

    private JTextField getLocalityField() {
        if (this.localityField == null) {
            this.localityField = new JTextField();
            this.localityField.setToolTipText(Messages.getString("Tooltip.Locality"));
            this.localityField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Locality"));
            this.localityField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Locality"));
            this.localityField.setName(ControlNames.CertificateDataPanelLocalityField.toString());
        }
        return this.localityField;
    }

    private JTextField getStateField() {
        if (this.stateField == null) {
            this.stateField = new JTextField();
            this.stateField.setToolTipText(Messages.getString("Tooltip.StateProvince"));
            this.stateField.setColumns(10);
            this.stateField.getAccessibleContext().setAccessibleName(Messages.getString("Label.StateProvince"));
            this.stateField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.StateProvince"));
            this.stateField.setName(ControlNames.CertificateDataPanelStateField.toString());
        }
        return this.stateField;
    }

    private JTextField getZipCodeField() {
        if (this.zipCodeField == null) {
            this.zipCodeField = new JTextField();
            this.zipCodeField.setToolTipText(Messages.getString("Tooltip.Zipcode"));
            this.zipCodeField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Zip"));
            this.zipCodeField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Zipcode"));
            this.zipCodeField.setName(ControlNames.CertificateDataPanelZipCodeField.toString());
        }
        return this.zipCodeField;
    }

    private JComboBox getVersionCombo() {
        if (this.versionCombo == null) {
            this.versionCombo = new JComboBox<X509Version>(versions);
            this.versionCombo.setToolTipText(Messages.getString("Tooltip.Version"));
            this.versionCombo.getAccessibleContext().setAccessibleName(Messages.getString("Label.Version"));
            this.versionCombo.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Version"));
            this.versionCombo.setName(ControlNames.CertificateDataPanelVersionCombo.toString());
        }
        return this.versionCombo;
    }

    private JComboBox getKeySizeCombo(Integer[] sizes) {
        JComboBox<Integer> cb = new JComboBox<Integer>(sizes);
        cb.setToolTipText(Messages.getString("Tooltip.KeySize"));
        cb.getAccessibleContext().setAccessibleName(Messages.getString("Label.KeySize"));
        cb.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.KeySize"));
        cb.setName(ControlNames.CertificateDataPanelKeySizeCombo.toString());
        return cb;
    }

    private JTextField getKeySizeField() {
        JTextField f = new JTextField();
        f.setToolTipText(Messages.getString("Tooltip.KeySize"));
        f.getAccessibleContext().setAccessibleName(Messages.getString("Label.KeySize"));
        f.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.KeySize"));
        f.setName(ControlNames.CertificateDataPanelKeySizeCombo.toString());
        return f;
    }

    private JComboBox getCountryCombo() {
        if (this.countryCombo == null) {
            this.countryCombo = new JComboBox<String>(KeymanUtil.ISO_3166_ORDERED_COUNTRY_CODES);
            this.countryCombo.setToolTipText(Messages.getString("Tooltip.CountryRegion"));
            this.countryCombo.getAccessibleContext().setAccessibleName(Messages.getString("Label.CountryOrRegion"));
            this.countryCombo.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.CountryRegion"));
            this.countryCombo.setName(ControlNames.CertificateDataPanelCountryCombo.toString());
        }
        return this.countryCombo;
    }

    private JComboBox getSignatureAlgorithmCombo() {
        JComboBox<Constants.SignatureAlgorithms> cb = new JComboBox<Constants.SignatureAlgorithms>(Constants.SignatureAlgorithms.getSupportedValues());
        cb.setToolTipText(Messages.getString("Tooltip.SignatureAlgorithm"));
        cb.getAccessibleContext().setAccessibleName(Messages.getString("Label.SigAlg"));
        cb.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.SignatureAlgorithm"));
        cb.setName(ControlNames.CertificateDataPanelSignatureAlgorithmCombo.toString());
        return cb;
    }

    private JFormattedTextField getValidityField() {
        if (this.validityField == null) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
            format.setMaximumIntegerDigits(KeymanSettings.VALID_PASSWORD_EXPIRY_RANGE.getMaximumDigits());
            this.validityField = new JFormattedTextField(format);
            this.validityField.setColumns(5);
            this.validityField.setToolTipText(Messages.getString("Tooltip.ValidityPeriod"));
            this.validityField.getAccessibleContext().setAccessibleName(Messages.getString("Label.ValidityPeriod"));
            this.validityField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.ValidityPeriod"));
            this.validityField.setName(ControlNames.CertificateDataPanelValidityField.toString());
        }
        return this.validityField;
    }

    private JPanel getValidtyPanel() {
        if (this.validtyPanel == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.anchor = 17;
            gridBagConstraints26.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints26.gridx = 1;
            this.jLabel15 = new JLabel();
            this.jLabel15.setText(Messages.getString("Label.Days"));
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.insets = new Insets(3, 5, 3, 0);
            gridBagConstraints25.ipadx = 0;
            gridBagConstraints25.gridy = 0;
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.fill = 3;
            this.validtyPanel = new JPanel();
            this.validtyPanel.setLayout(new GridBagLayout());
            this.validtyPanel.add((Component)this.getValidityField(), gridBagConstraints25);
            this.validtyPanel.add((Component)this.jLabel15, gridBagConstraints26);
        }
        return this.validtyPanel;
    }

    private String getKeyLabel() {
        if (this.labelField.getText().equals("")) {
            return null;
        }
        return this.labelField.getText();
    }

    private X509Version getVersion() {
        if (this.inputDialogType == InputPanelFactory.InputDialogType.SelfsignedCertificate) {
            return (X509Version)this.versionCombo.getSelectedItem();
        }
        return null;
    }

    private Constants.SignatureAlgorithms getSigAlg() {
        return (Constants.SignatureAlgorithms)((Object)this.signatureAlgorithmCombo.getSelectedItem());
    }

    private String getValidity() {
        if (this.inputDialogType == InputPanelFactory.InputDialogType.SelfsignedCertificate) {
            if (this.validityField.getText().trim().equals("")) {
                return null;
            }
            return this.validityField.getText();
        }
        return null;
    }

    private DisplayItemFactory.DNItem getDN() throws KeyManagerException {
        return DisplayItemFactory.getDNItem(this.commonNameField.getText(), this.organizationUnitField.getText(), this.organizationField.getText(), this.localityField.getText(), this.stateField.getText(), this.zipCodeField.getText(), (String)this.countryCombo.getSelectedItem());
    }

    private Integer getKeySize() {
        if (this.isKeySizeText) {
            return (Integer)this.keySizeComboEC.getSelectedItem();
        }
        return (Integer)this.keySizeCombo.getSelectedItem();
    }

    public void getParameters(ParameterMap map) throws KeyManagerException {
        this.handleParameter(map, Constants.Parameter.Label, this.getKeyLabel());
        this.handleParameter(map, Constants.Parameter.X509Version, this.getVersion());
        this.handleParameter(map, Constants.Parameter.Size, this.getKeySize());
        this.handleParameter(map, Constants.Parameter.DN, this.getDN());
        this.handleParameter(map, Constants.Parameter.Expire, this.getValidity());
        this.handleParameter(map, Constants.Parameter.SigAlg, (Object)this.getSigAlg());
        this.handleParameter(map, Constants.Parameter.SanEmailAddress, this.getEmail());
        this.handleParameter(map, Constants.Parameter.SanIpAddress, this.getIp());
        this.handleParameter(map, Constants.Parameter.SanDnsName, this.getDns());
    }

    private void handleParameter(ParameterMap map, Constants.Parameter param, Object value) throws KeyManagerException {
        if (value != null) {
            map.put(param, value);
        } else {
            map.remove(param);
        }
    }

    private String getEmail() {
        if (this.emailField == null || this.emailField.getText().equals("")) {
            return null;
        }
        return this.emailField.getText();
    }

    private String getIp() {
        if (this.ipField == null || this.ipField.getText().equals("")) {
            return null;
        }
        return this.ipField.getText();
    }

    private String getDns() {
        if (this.dnsField == null || this.dnsField.getText().equals("")) {
            return null;
        }
        return this.dnsField.getText();
    }

    private JTextField getEmailField() {
        if (this.emailField == null) {
            this.emailField = new JTextField();
            this.emailField.setToolTipText(Messages.getString("Tooltip.EmailAddress"));
            this.emailField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Email"));
            this.emailField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.EmailAddress"));
            this.emailField.setName(ControlNames.CertificateDataPanelEmailField.toString());
        }
        return this.emailField;
    }

    private JTextField getIpField() {
        if (this.ipField == null) {
            this.ipField = new JTextField();
            this.ipField.setToolTipText(Messages.getString("Tooltip.IPAddress"));
            this.ipField.getAccessibleContext().setAccessibleName(Messages.getString("Label.IP"));
            this.ipField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.IPAddress"));
            this.ipField.setName(ControlNames.CertificateDataPanelIPField.toString());
        }
        return this.ipField;
    }

    private JTextField getDnsField() {
        if (this.dnsField == null) {
            this.dnsField = new JTextField();
            this.dnsField.setToolTipText(Messages.getString("Tooltip.DNSName"));
            this.dnsField.getAccessibleContext().setAccessibleName(Messages.getString("Label.DNS"));
            this.dnsField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.DNSName"));
            this.dnsField.setName(ControlNames.CertificateDataPanelDnsField.toString());
        }
        return this.dnsField;
    }

    public void resetFields() {
        this.labelField.setText("");
        this.commonNameField.setText(KeymanUtil.getHostName());
        this.organizationField.setText("");
        this.organizationUnitField.setText("");
        this.localityField.setText("");
        this.stateField.setText("");
        this.zipCodeField.setText("");
        this.countryCombo.setSelectedIndex(0);
        if (this.isKeySizeText) {
            this.keySizeCombo.setSelectedItem(KeymanSettings.Setting.DefaultKeySize.getInteger());
        } else {
            this.keySizeCombo.setSelectedItem(KeymanSettings.Setting.DefaultKeySize.getInteger());
        }
        if (this.inputDialogType == InputPanelFactory.InputDialogType.SelfsignedCertificate) {
            this.versionCombo.setSelectedIndex(2);
            this.validityField.setText(KeymanSettings.Setting.DefaultCertExpire.getInteger() + "");
        }
        if (KeymanSettings.Setting.SANEnabled.getBoolean().booleanValue()) {
            this.emailField.setText("");
            this.ipField.setText("");
            this.dnsField.setText("");
        }
        if (KeymanSettings.Setting.SignatureAlgorithmFunctionEnabled.getBoolean().booleanValue()) {
            this.signatureAlgorithmCombo.setSelectedItem((Object)Constants.SignatureAlgorithms.get(KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM));
        }
        this.labelField.requestFocusInWindow();
    }

    public boolean isValidInput(StringBuffer errorMessage) {
        this.labelField.setText(this.labelField.getText() == null ? null : this.labelField.getText().trim());
        if (CertificateDataPanel.isEmpty(this.labelField)) {
            errorMessage.append(MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.CertLabel")));
            return false;
        }
        if (CertificateDataPanel.isEmpty(this.validityField)) {
            errorMessage.append(MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.CertValidity")));
            return false;
        }
        return true;
    }

    private static boolean isEmpty(JTextField field) {
        return field != null && field.getText().trim().equals("");
    }
}

