/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanelFactory;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class FileNameDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private FileNamePanel fileNamePanel = null;
    private GUIConstants.DialogMode mode;
    private FileNamePanelFactory.PanelType panelType;
    private FileName databaseName;

    public FileNameDialog(Frame owner, GUIConstants.DialogMode mode, FileNamePanelFactory.PanelType panelType, FileName databaseName) {
        super(owner);
        this.mode = mode;
        this.setModal(true);
        this.panelType = panelType;
        this.databaseName = databaseName;
        this.initialize();
        this.setTitle(FileNameDialog.getTitleString(mode));
    }

    private static String getTitleString(GUIConstants.DialogMode mode) {
        switch (mode) {
            case New: {
                return Messages.getString("GUI.Title.New");
            }
            case Open: {
                return Messages.getString("GUI.Title.Open");
            }
        }
        return "";
    }

    private void initialize() {
        this.setSize(667, 173);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.buttonPanel.getOkBtn());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 1;
            GridBagConstraints constraints2 = new GridBagConstraints();
            constraints2.gridx = 0;
            constraints2.gridy = 1;
            constraints2.insets = new Insets(0, 0, 5, 0);
            this.jContentPane.add((Component)this.getDatabaseNamePanel(), constraints);
            this.jContentPane.add((Component)this.getButtonPanel(), constraints2);
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK, GUIConstants.Actions.Cancel);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        if (this.fileNamePanel.isValidInput()) {
            this.fileNamePanel.updateDefaultLocation();
            this.setDialogResult(GUIConstants.DialogResult.OK);
            this.setVisible(false);
        }
    }

    private FileNamePanel getDatabaseNamePanel() {
        if (this.fileNamePanel == null) {
            this.fileNamePanel = FileNamePanelFactory.newPanel(this.panelType, this.mode, this.databaseName);
        }
        return this.fileNamePanel;
    }

    public ParameterMap getParameters() throws KeyManagerException {
        return this.fileNamePanel.getParameters();
    }

    public static ParameterMap getFileData(Frame frame, GUIConstants.DialogMode mode, FileNamePanelFactory.PanelType panelType, FileName databaseName) throws KeyManagerException, CancelledException {
        FileNameDialog dialog = new FileNameDialog(frame, mode, panelType, databaseName);
        dialog.setVisible(true);
        try {
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                ParameterMap parameterMap = dialog.getParameters();
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            dialog.dispose();
        }
    }

    protected void resetHandler() {
    }
}

