/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import java.util.HashMap;
import java.util.Map;

public class KeyStoreLoaderFactory {
    public static KeyStoreLoader newBasicKeyStoreLoader() {
        return new BasicKeyStoreLoader();
    }

    public static KeyStoreLoader newCachedKeyStoreLoader() {
        return new CachedKeyStoreLoader();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BasicKeyStoreLoader
    implements KeyStoreLoader {
        private BasicKeyStoreLoader() {
        }

        @Override
        public KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws CancelledException, KeyManagerException {
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = KeyStoreItemFactory.loadKeystore(descriptor);
            return item;
        }

        @Override
        public KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getValidKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getKeyStoreItem(descriptor);
            item.validate();
            return item;
        }

        @Override
        public void closeKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedKeyStoreLoader
    extends BasicKeyStoreLoader {
        protected static final Map<DatabaseDescriptorFactory.DatabaseDescriptor, KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor>> keystoreItems = new HashMap<DatabaseDescriptorFactory.DatabaseDescriptor, KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor>>();

        private CachedKeyStoreLoader() {
        }

        @Override
        public KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws CancelledException, KeyManagerException {
            if (keystoreItems.containsKey(descriptor)) {
                KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = keystoreItems.get(descriptor);
                item.refresh();
                return item;
            }
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = super.getKeyStoreItem(descriptor);
            keystoreItems.put(descriptor, item);
            return item;
        }

        @Override
        public void closeKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
            if (keystoreItems.containsKey(descriptor)) {
                keystoreItems.get(descriptor).close();
                keystoreItems.remove(descriptor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyStoreLoader {
        public KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor var1) throws CancelledException, KeyManagerException;

        public KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> getValidKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor var1) throws KeyManagerException;

        public void closeKeyStoreItem(DatabaseDescriptorFactory.DatabaseDescriptor var1) throws KeyManagerException;
    }
}

