/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BufferFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordDataHashGenerator;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.pkcs10.CertificationRequest;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class RequestRecordDataHashGeneratorFactory {
    private RequestRecordDataHashGeneratorFactory() {
        throw new UnsupportedOperationException();
    }

    public static RequestRecordDataHashGenerator newRequestRecordDataHashGenerator() {
        return new RequestRecordDataHashGeneratorImpl();
    }

    private static class RequestRecordDataHashGeneratorImpl
    implements RequestRecordDataHashGenerator {
        private static final String HASH_ALG = "SHA1";

        RequestRecordDataHashGeneratorImpl() {
        }

        private Buffer generateHash(byte[] data) throws NoSuchAlgorithmException, NullPointerException, IOException {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            byte[] hash = md.digest(data);
            ByteSequence buffer = IntableByteSequenceFactory.newIntableByteSequence(md.getDigestLength()).append(ByteSequenceFactory.newByteSequence(hash));
            return BufferFactory.newBuffer(buffer.getInputStream());
        }

        public Buffer generateSubjectPublicKeyInfoHash(CertificationRequest certRequest) throws NoSuchAlgorithmException, NullPointerException, IOException, InvalidKeyException {
            return this.generateHash(certRequest.getCertRequestInfo().getSubjectPublicKeyInfo().getEncoded());
        }
    }
}

