/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9JavaStackFrame;
import java.io.IOException;
import java.util.Vector;

public class J9Thread
extends GenericThread {
    private Vector frames = new Vector();
    private String nativeId;
    private static int nameOffset = -1;
    private static J9Class javaLangThreadClass;
    private static Dump theDump;

    public J9Thread(J9Thread thread) {
        super(thread);
        this.frames = (Vector)thread.frames.clone();
        this.nativeId = thread.nativeId;
    }

    public J9Thread(String id, String obj, String state, String monitor, String nativeID) {
        super(id, obj, state, monitor);
        this.nativeId = nativeID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null == this.threadName || this.threadName.equals("!unable to establish! (dis os run?)")) {
            String name = " !unknown! ";
            if (null != this.javaLangThreadObjectAddress) {
                long lAddr = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.javaLangThreadObjectAddress));
                if (null == javaLangThreadClass) {
                    javaLangThreadClass = J9Thread.getJLTClass();
                }
                if (null != javaLangThreadClass && -1 != nameOffset) {
                    try {
                        long addrOfString = theDump.readPtr(lAddr + (long)nameOffset);
                        name = J9JVMUtils.getStringValue(addrOfString, 0);
                    }
                    catch (IOException ioe) {
                        boolean x = true;
                    }
                }
            } else {
                name = "  !! non Java thread !!";
            }
            this.threadName = name;
        }
        sb.append("  Name    : " + this.threadName + "\n");
        sb.append("  Id      : " + this.threadId + "\n");
        sb.append("  NativeId: " + this.nativeId + "\n");
        if (null != this.javaLangThreadObjectAddress) {
            sb.append("  Obj     : " + this.javaLangThreadObjectAddress + " (java/lang/Thread) \n");
        }
        sb.append("  State   : " + this.state);
        if (null != this.monitorId) {
            sb.append("  MonitorId: " + this.monitorId);
        }
        if (0 != this.frames.size()) {
            sb.append("\n\tStack:\n");
            for (int i = 0; i < this.frames.size(); ++i) {
                J9JavaStackFrame frameInfo = (J9JavaStackFrame)this.frames.get(i);
                if (null == frameInfo) continue;
                sb.append("\t\t" + frameInfo.toString() + "\n");
            }
        } else {
            sb.append("\n\t No Stack available");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void printHeader(StringBuffer sb) {
        sb.append("Info for thread - " + this.threadId + "\n===============================\n");
    }

    public boolean isJavaThread() {
        boolean bRet = true;
        if (null == this.javaLangThreadObjectAddress) {
            bRet = false;
        }
        return bRet;
    }

    public String getThreadDetails() {
        if (null == this.threadDetails) {
            if (!this.isJavaThread()) {
                this.threadName = "** Not a Java Thread **";
                this.threadDetails = " Non-java thread ";
            } else {
                int nextQuotePos;
                String ts = DumpUtils.stripOff0x(this.javaLangThreadObjectAddress);
                ts = DumpUtils.padToPtrSize(ts);
                long addr = DumpUtils.parseLongHex(ts);
                J9Class threadClass = J9JVMConsole.getClass("java/lang/Thread");
                this.threadDetails = threadClass.formatObject(addr);
                int quotePos = this.threadDetails.indexOf("\"");
                if (-1 != quotePos && -1 != (nextQuotePos = this.threadDetails.indexOf("\"", quotePos + 1))) {
                    this.threadName = this.threadDetails.substring(quotePos + 1, nextQuotePos);
                }
            }
        }
        return this.threadDetails;
    }

    public String getThreadName() {
        if (null == this.threadName && null == this.threadDetails) {
            this.getThreadDetails();
        }
        return this.threadName;
    }

    public void addFrame(String method, String pc, String arguments) {
        J9JavaStackFrame frameDetails = new J9JavaStackFrame(method, pc, arguments);
        this.frames.add(frameDetails);
    }

    private static J9Class getJLTClass() {
        J9Class j9c = null;
        j9c = J9JVMConsole.getClass("java/lang/Thread");
        if (null == j9c) {
            Console.reportError(" !!! No java/lang/Thread definition available !!!", null);
        } else {
            nameOffset = j9c.getFieldOffset("name");
        }
        return j9c;
    }

    public Vector getFrames() {
        return this.frames;
    }

    public String getNativeId() {
        return this.nativeId;
    }

    public GenericThread getNativeThread() {
        if (this.getNativeId() != null) {
            return J9JVMConsole.getKnownThread(this.getNativeId());
        }
        return null;
    }

    static {
        theDump = DumpConsole.getTheDump();
    }
}

