/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.J9Class;

public class J9Static {
    private J9Class myClass;
    private String staticName;
    private long value;
    private String signature;
    private int modifiers;

    public J9Static(J9Class ownerClass, String name, String sig, String modifiersIn, String value) {
        this.myClass = ownerClass;
        this.staticName = name;
        this.signature = sig;
        String temp = DumpUtils.stripOff0x(value);
        modifiersIn = DumpUtils.stripOff0x(modifiersIn);
        if (modifiersIn.length() == 8) {
            modifiersIn = modifiersIn.substring(1);
        }
        this.modifiers = Integer.parseInt(modifiersIn, 16);
        this.value = DumpUtils.parseLongHex(temp);
        ownerClass.addStatic(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String modString = ClassField.convertModifier(this.modifiers);
        sb.append("\tname: " + this.staticName);
        sb.append("  \tmodifiers:" + modString);
        sb.append("  \tvalue: 0x" + Long.toHexString(this.value));
        sb.append("  \tsig: " + this.signature);
        return sb.toString();
    }

    public String getSignature() {
        return this.signature;
    }

    public long getValue() {
        return this.value;
    }
}

