/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class DumpFileProtocolListener
implements DumpFile {
    private final PrintWriter _log;
    private final DumpFile _delegate;

    public DumpFileProtocolListener(DumpFile delegate) throws IOException {
        this._log = new PrintWriter(new FileWriter(delegate.getDumpName() + ".transcript." + System.currentTimeMillis()));
        this._delegate = delegate;
    }

    public void close() throws IOException {
        this._delegate.close();
        this._log.close();
    }

    public String getDumpName() {
        return this._delegate.getDumpName();
    }

    public long getFilePointer() throws IOException {
        this._log.print("getFilePointer()");
        try {
            long filePointer = this._delegate.getFilePointer();
            this._log.print(Long.toHexString(filePointer));
            long l = filePointer;
            return l;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public long length() throws IOException {
        this._log.print("length()");
        try {
            long length = this._delegate.length();
            this._log.print(length);
            long l = length;
            return l;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public int read() throws IOException {
        this._log.print("read()");
        try {
            int toReturn = this._delegate.read();
            this._log.print(Integer.toHexString(toReturn));
            int n = toReturn;
            return n;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public int read(byte[] buf) throws IOException {
        this._log.print("read(buf)");
        try {
            int read = this._delegate.read(buf);
            this._log.print(" read=" + read + ", buf =");
            this.printBuf(buf, 0, read);
            int n = read;
            return n;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    private void printBuf(byte[] buf, int start, int read) {
        if (read <= 0) {
            return;
        }
        for (int i = start; i < start + read; ++i) {
            this._log.print(" " + Integer.toHexString(buf[i]));
        }
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        this._log.print("read(buf,offset,length)");
        try {
            int read = this._delegate.read(b, offset, length);
            this._log.print("read(buf,offset,length) - read=" + read + ", buf =");
            this.printBuf(b, offset, read);
            int n = read;
            return n;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public byte readByte() throws IOException {
        this._log.print("readByte()");
        try {
            byte b = this._delegate.readByte();
            this._log.print("readByte() - " + Integer.toHexString(b));
            byte by = b;
            return by;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this._log.print("readFully(b,off,len) ");
        try {
            this._delegate.readFully(b, off, len);
            this._log.print("buf =");
            this.printBuf(b, 0, len);
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public void readFully(byte[] b) throws IOException {
        this._log.print("readFully(b) ");
        try {
            this._delegate.readFully(b);
            this._log.print("buf =");
            this.printBuf(b, 0, b.length);
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public int readInt() throws IOException {
        this._log.print("readInt() ");
        try {
            int read = this._delegate.readInt();
            this._log.print(read);
            int n = read;
            return n;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public long readLong() throws IOException {
        this._log.print("readLong() ");
        try {
            long read = this._delegate.readLong();
            this._log.print(read);
            long l = read;
            return l;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public short readShort() throws IOException {
        this._log.print("readShort() ");
        try {
            short read = this._delegate.readShort();
            this._log.print(read);
            short s = read;
            return s;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public int readUnsignedByte() throws IOException {
        this._log.print("readUnsignedByte() ");
        try {
            int read = this._delegate.readUnsignedByte();
            this._log.print(Integer.toHexString(read));
            int n = read;
            return n;
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }

    public void seek(long position) throws IOException {
        try {
            this._log.print("seek " + position);
            this._delegate.seek(position);
        }
        catch (IOException e) {
            this._log.print("x");
            throw e;
        }
        finally {
            this._log.println();
        }
    }
}

