/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.p2.model.internal.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.InvalidSyntaxException;

public class FilterReader {
    public static final byte EQUAL = 1;
    public static final byte APPROX = 2;
    public static final byte GREATER = 3;
    public static final byte LESS = 4;
    public static final byte PRESENT = 5;
    public static final byte SUBSTRING = 6;
    public static final byte AND = 7;
    public static final byte OR = 8;
    public static final byte NOT = 9;

    public static FilterPart readFilter(String filter) throws CoreException {
        try {
            Parser p = new Parser(filter);
            return p.parse();
        }
        catch (InvalidSyntaxException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", e.getMessage(), (Throwable)e));
            throw ce;
        }
    }

    public static class FilterPart {
        private final String fName;
        private final String fValue;
        private final byte fComp;
        private final ArrayList fChildren;

        public FilterPart(byte compOp, String name, String value) {
            this.fName = name;
            this.fValue = value;
            this.fComp = compOp;
            this.fChildren = new ArrayList(0);
        }

        public void addChild(FilterPart part) {
            this.fChildren.add(part);
        }

        public String getName() {
            return this.fName;
        }

        public String getValue() {
            return this.fValue;
        }

        public byte getOperation() {
            return this.fComp;
        }
    }

    private static class Parser {
        private final String filterstring;
        private final char[] filterChars;
        private int pos;

        Parser(String filterstring) {
            this.filterstring = filterstring;
            this.filterChars = filterstring.toCharArray();
            this.pos = 0;
        }

        FilterPart parse() throws InvalidSyntaxException {
            FilterPart filter;
            try {
                filter = this.parse_filter();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InvalidSyntaxException(Messages.FilterReader_errEnd, this.filterstring);
            }
            if (this.pos != this.filterChars.length) {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errUnexpectedChars, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            return filter;
        }

        private FilterPart parse_filter() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_missingLParen, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            FilterPart filter = this.parse_filtercomp();
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != ')') {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_missingRParen, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
            return filter;
        }

        private FilterPart parse_filtercomp() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filterChars[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    return this.parse_and();
                }
                case '|': {
                    ++this.pos;
                    return this.parse_or();
                }
                case '!': {
                    ++this.pos;
                    return this.parse_not();
                }
            }
            return this.parse_item();
        }

        private FilterPart parse_and() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_missingLParen, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            ArrayList<FilterPart> operands = new ArrayList<FilterPart>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterPart child = this.parse_filter();
                operands.add(child);
            }
            FilterPart ret = new FilterPart(7, null, null);
            for (FilterPart child : operands) {
                ret.addChild(child);
            }
            return ret;
        }

        private FilterPart parse_or() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_missingLParen, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            ArrayList<FilterPart> operands = new ArrayList<FilterPart>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterPart child = this.parse_filter();
                operands.add(child);
            }
            FilterPart ret = new FilterPart(8, null, null);
            for (FilterPart child : operands) {
                ret.addChild(child);
            }
            return ret;
        }

        private FilterPart parse_not() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_missingLParen, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            FilterPart child = this.parse_filter();
            FilterPart ret = new FilterPart(9, null, null);
            ret.addChild(child);
            return ret;
        }

        private FilterPart parse_item() throws InvalidSyntaxException {
            String attr = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filterChars[this.pos]) {
                case '~': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterPart(2, attr, this.parse_value());
                }
                case '>': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterPart(3, attr, this.parse_value());
                }
                case '<': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new FilterPart(4, attr, this.parse_value());
                }
                case '=': {
                    if (this.filterChars[this.pos + 1] == '*') {
                        int oldpos = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filterChars[this.pos] == ')') {
                            return new FilterPart(5, attr, null);
                        }
                        this.pos = oldpos;
                    }
                    ++this.pos;
                    Object string = this.parse_substring();
                    if (string instanceof String) {
                        return new FilterPart(1, attr, (String)string);
                    }
                    return new FilterPart(6, attr, null);
                }
            }
            throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errInvalidOperator, (Object)this.filterstring.substring(this.pos)), this.filterstring);
        }

        private String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int begin = this.pos;
            int end = this.pos;
            char c = this.filterChars[this.pos];
            while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    end = this.pos;
                }
                c = this.filterChars[this.pos];
            }
            int length = end - begin;
            if (length == 0) {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errMissingAttr, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            return new String(this.filterChars, begin, length);
        }

        private String parse_value() throws InvalidSyntaxException {
            StringBuffer sb = new StringBuffer(this.filterChars.length - this.pos);
            block5: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errMissingFilter, (Object)this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                        sb.append(c);
                        ++this.pos;
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (sb.length() == 0) {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errMissingFilter, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            return sb.toString();
        }

        private Object parse_substring() throws InvalidSyntaxException {
            Object single;
            int size;
            StringBuffer sb = new StringBuffer(this.filterChars.length - this.pos);
            ArrayList<String> operands = new ArrayList<String>(10);
            block6: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        if (sb.length() <= 0) break block6;
                        operands.add(sb.toString());
                        break block6;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errValue, (Object)this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '*': {
                        if (sb.length() > 0) {
                            operands.add(sb.toString());
                        }
                        sb.setLength(0);
                        operands.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                        sb.append(c);
                        ++this.pos;
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            if ((size = operands.size()) == 0) {
                throw new InvalidSyntaxException(Messages.bind((String)Messages.FilterReader_errMissingFilter, (Object)this.filterstring.substring(this.pos)), this.filterstring);
            }
            if (size == 1 && (single = operands.get(0)) != null) {
                return single;
            }
            return operands.toArray(new String[size]);
        }

        private void skipWhiteSpace() {
            int length = this.filterChars.length;
            while (this.pos < length && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }
}

