/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.ConnectionParameter;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQProvider;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointGroup;
import com.ibm.net.rdma.jverbs.verbs.DeregisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.MemoryRegion;
import com.ibm.net.rdma.jverbs.verbs.PostReceiveMethod;
import com.ibm.net.rdma.jverbs.verbs.PostSendMethod;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.ReceiveWorkRequest;
import com.ibm.net.rdma.jverbs.verbs.RegisterMemoryRegionMethod;
import com.ibm.net.rdma.jverbs.verbs.SendWorkRequest;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;

public class RdmaEndpoint {
    private static int CONN_STATE_INITIALIZED = 0;
    private static int CONN_STATE_ADDR_RESOLVED = 1;
    private static int CONN_STATE_ROUTE_RESOLVED = 2;
    private static int CONN_STATE_RESOURCES_ALLOCATED = 3;
    private static int CONN_STATE_CONNECTED = 4;
    private static int CONN_STATE_CLOSED = 5;
    private static byte INITIATOR_DEPTH = (byte)5;
    private static byte RESPONDER_RESOURCES = (byte)5;
    private static byte RETRY_COUNT = (byte)7;
    protected int endpointId;
    protected RdmaEndpointGroup<? extends RdmaEndpoint> group;
    private boolean isServerSide;
    protected ConnectionId idPriv;
    protected QueuePair qp;
    protected ProtectionDomain pd;
    protected RdmaCQProvider cqProcessor;
    protected int access;
    private boolean isInitialized;
    private int connectionState;
    private boolean isClosed;

    protected RdmaEndpoint(RdmaEndpointGroup<? extends RdmaEndpoint> rdmaEndpointGroup, ConnectionId connectionId) throws IllegalArgumentException, IOException {
        this.endpointId = rdmaEndpointGroup.getNextId();
        this.group = rdmaEndpointGroup;
        this.idPriv = connectionId;
        this.qp = null;
        this.pd = null;
        this.cqProcessor = null;
        this.isInitialized = false;
        this.isClosed = false;
        this.access = 7;
        this.connectionState = CONN_STATE_INITIALIZED;
    }

    public synchronized void connect(SocketAddress socketAddress, int n) throws IllegalArgumentException, IOException {
        if (this.connectionState != CONN_STATE_INITIALIZED) {
            throw new IOException("endpoint already connected");
        }
        this.idPriv.resolveAddress(null, socketAddress, n);
        try {
            while (this.connectionState < CONN_STATE_ADDR_RESOLVED) {
                this.wait();
            }
            if (this.connectionState != CONN_STATE_ADDR_RESOLVED) {
                throw new IOException("Resolve address failed");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Resolve address failed");
        }
        this.idPriv.resolveRoute(n);
        try {
            while (this.connectionState < CONN_STATE_ROUTE_RESOLVED) {
                this.wait();
            }
            if (this.connectionState != CONN_STATE_ROUTE_RESOLVED) {
                throw new IOException("Resolve route failed");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Resolve route failed");
        }
        this.group.allocateResourcesRaw(this);
        try {
            while (this.connectionState < CONN_STATE_RESOURCES_ALLOCATED) {
                this.wait();
            }
            if (this.connectionState != CONN_STATE_RESOURCES_ALLOCATED) {
                throw new IOException("Resource allocation failed");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Resource allocation failed");
        }
        ConnectionParameter connectionParameter = new ConnectionParameter();
        connectionParameter.setInitiatorDepth(INITIATOR_DEPTH);
        connectionParameter.setResponderResources(RESPONDER_RESOURCES);
        connectionParameter.setRetryCount(RETRY_COUNT);
        this.idPriv.connect(connectionParameter);
        try {
            while (this.connectionState < CONN_STATE_CONNECTED) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Connect failed");
        }
    }

    synchronized void accept() throws IOException {
        this.group.allocateResourcesRaw(this);
        try {
            while (this.connectionState < CONN_STATE_RESOURCES_ALLOCATED) {
                this.wait();
            }
            if (this.connectionState != CONN_STATE_RESOURCES_ALLOCATED) {
                throw new IOException("Resource allocation failed");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Resource allocation failed");
        }
        ConnectionParameter connectionParameter = new ConnectionParameter();
        connectionParameter.setInitiatorDepth(INITIATOR_DEPTH);
        connectionParameter.setResponderResources(RESPONDER_RESOURCES);
        connectionParameter.setRetryCount(RETRY_COUNT);
        this.idPriv.accept(connectionParameter);
        try {
            while (this.connectionState < CONN_STATE_CONNECTED) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Accept Failed");
        }
    }

    protected final synchronized void allocateResources() throws IOException {
        if (!this.isInitialized) {
            this.pd = this.group.createProtectionDomainRaw(this);
            this.cqProcessor = this.group.createCompletionQueueProcessorRaw(this);
            this.qp = this.group.createQueuePairRaw(this);
            this.isInitialized = true;
            this.init();
            this.connectionState = CONN_STATE_RESOURCES_ALLOCATED;
            this.notifyAll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final synchronized void dispatchConnectionEvent(ConnectionEvent connectionEvent) {
        try {
            ConnectionEvent.EventType eventType = connectionEvent.getEventType();
            if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_ADDR_RESOLVED) {
                this.connectionState = CONN_STATE_ADDR_RESOLVED;
                this.notifyAll();
                return;
            }
            if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_ROUTE_RESOLVED) {
                this.connectionState = CONN_STATE_ROUTE_RESOLVED;
                this.notifyAll();
                return;
            }
            if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_ESTABLISHED) {
                this.connectionState = CONN_STATE_CONNECTED;
                this.notifyAll();
                return;
            }
            if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_DISCONNECTED) {
                this.connectionState = CONN_STATE_CLOSED;
                this.notifyAll();
                return;
            }
            if (eventType != ConnectionEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void close() throws IOException {
        try {
            if (!this.isClosed) {
                if (this.connectionState != CONN_STATE_CLOSED) {
                    this.idPriv.disconnect();
                    while (this.connectionState < CONN_STATE_CLOSED) {
                        this.wait();
                    }
                    if (this.connectionState != CONN_STATE_CLOSED) {
                        throw new IOException("Close failed, connectionState " + this.connectionState + ", ep " + this.getEndpointId());
                    }
                }
                this.idPriv.destroyQueuePair();
                this.idPriv.destroy();
                this.group.unregisterEndpoint(this);
                this.isClosed = true;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Closed failed");
        }
    }

    public synchronized boolean isConnected() {
        return this.connectionState == CONN_STATE_CONNECTED;
    }

    public synchronized boolean isClosed() {
        return this.connectionState == CONN_STATE_CLOSED;
    }

    public SocketAddress getSourceAddress() throws IOException {
        return this.idPriv.getSourceAddress();
    }

    public int getSourcePort() throws IOException {
        return this.idPriv.getSourcePort();
    }

    public SocketAddress getDestinationAddress() throws IOException {
        return this.idPriv.getDestinationAddress();
    }

    public int getDestinationPort() throws IOException {
        return this.idPriv.getDestinationPort();
    }

    protected RdmaCQProvider getCQProcessor() {
        return this.cqProcessor;
    }

    public RegisterMemoryRegionMethod registerMemory(ByteBuffer byteBuffer) throws IllegalArgumentException, IOException {
        return this.pd.registerMemoryRegion(byteBuffer, this.access);
    }

    public PostReceiveMethod preparePostReceive(List<ReceiveWorkRequest> list) throws IllegalArgumentException, IOException {
        return this.qp.preparePostReceive(list);
    }

    public PostSendMethod preparePostSend(List<SendWorkRequest> list) throws IllegalArgumentException, IOException {
        return this.qp.preparePostSend(list);
    }

    public void deregisterMemory(MemoryRegion memoryRegion) throws IllegalArgumentException, IOException {
        ((DeregisterMemoryRegionMethod)this.pd.deregisterMemoryRegion(memoryRegion).execute()).free();
    }

    public ConnectionId getConnectionId() {
        return this.idPriv;
    }

    public QueuePair getQueuePair() {
        return this.qp;
    }

    protected boolean isServerSide() {
        return this.isServerSide;
    }

    protected int getEndpointId() {
        return this.endpointId;
    }

    void setServerSide(boolean bl) {
        this.isServerSide = bl;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.pd;
    }

    protected synchronized void init() throws IOException {
    }
}

