/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.cm.ConnectionParameter;
import com.ibm.net.rdma.jverbs.cm.EventChannel;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.cm.RdmaCM;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairInitAttribute;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.net.SocketAddress;

public class ConnectionId {
    private RdmaCM connection;
    protected PortSpace portSpace = PortSpace.RDMA_PS_TCP;
    protected EventChannel connectionChannel = null;
    protected VerbsContext verbs = null;
    protected QueuePair queuePair = null;

    protected ConnectionId(EventChannel eventChannel, PortSpace portSpace) throws IOException {
        this.connection = RdmaCM.open();
        this.connectionChannel = eventChannel;
        this.portSpace = portSpace;
    }

    public PortSpace getPortSpace() {
        return this.portSpace;
    }

    public EventChannel getEventChannel() {
        return this.connectionChannel;
    }

    public VerbsContext getVerbsContext() throws IOException {
        return this.verbs;
    }

    public QueuePair getQueuePair() {
        return this.queuePair;
    }

    protected void setVerbsContext(VerbsContext verbsContext) {
        this.verbs = verbsContext;
    }

    protected void setQueuePair(QueuePair queuePair) {
        this.queuePair = queuePair;
    }

    public QueuePair createQueuePair(ProtectionDomain protectionDomain, QueuePairInitAttribute queuePairInitAttribute) throws IllegalArgumentException, IOException {
        return this.connection.createQueuePair(this, protectionDomain, queuePairInitAttribute);
    }

    public void bindAddress(SocketAddress socketAddress) throws IllegalArgumentException, IOException {
        this.connection.bindAddress(this, socketAddress);
    }

    public void listen(int n) throws IOException {
        this.connection.listen(this, n);
    }

    public void resolveAddress(SocketAddress socketAddress, SocketAddress socketAddress2, int n) throws IllegalArgumentException, IOException {
        this.connection.resolveAddress(this, socketAddress, socketAddress2, n);
    }

    public void resolveRoute(int n) throws IllegalArgumentException, IOException {
        this.connection.resolveRoute(this, n);
    }

    public void connect(ConnectionParameter connectionParameter) throws IllegalArgumentException, IOException {
        this.connection.connect(this, connectionParameter);
    }

    public void accept(ConnectionParameter connectionParameter) throws IllegalArgumentException, IOException {
        this.connection.accept(this, connectionParameter);
    }

    public void disconnect() throws IOException {
        this.connection.disconnect(this);
    }

    public SocketAddress getSourceAddress() throws IOException {
        return this.connection.getSourceAddress(this);
    }

    public SocketAddress getDestinationAddress() throws IOException {
        return this.connection.getDestinationAddress(this);
    }

    public int getSourcePort() throws IOException {
        return this.connection.getSourcePort(this);
    }

    public int getDestinationPort() throws IOException {
        return this.connection.getDestinationPort(this);
    }

    public void destroyQueuePair() throws IOException {
        this.connection.destroyQueuePair(this);
    }

    public static ConnectionId create(EventChannel eventChannel, PortSpace portSpace) throws IllegalArgumentException, IOException {
        RdmaCM rdmaCM = RdmaCM.open();
        return rdmaCM.createConnectionId(eventChannel, portSpace);
    }

    public void destroy() throws IOException {
        this.connection.destroyConnectionId(this);
    }
}

