/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.util.PkBase64Constants;
import java.io.IOException;
import java.io.InputStream;

public class PkBase64InputStream
extends InputStream
implements PkBase64Constants {
    private static Debug debug;
    private static final Object className;
    private static final int NOT_BASE_64 = -1;
    private static final int WHITE_SPACE = -2;
    private static final int END_OF_INPUT = -3;
    private static final int EQUALS = -4;
    private static final byte[] mapper;
    private InputStream in;
    private int last_read;
    private int next_read;
    private int state;
    private byte carry;

    public PkBase64InputStream(InputStream in) throws IOException {
        this.in = in;
        this.state = 0;
        this.carry = 0;
        this.last_read = this.reallyRead();
    }

    @Override
    public int read() throws IOException {
        int result = this.last_read;
        this.last_read = this.reallyRead();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public int lastChar() {
        return this.next_read;
    }

    private int reallyRead() throws IOException {
        block11: while (true) {
            if (this.state == 4) {
                return -1;
            }
            this.next_read = this.in.read();
            byte next = mapper[this.next_read + 1];
            switch (next) {
                case -2: {
                    continue block11;
                }
                case -3: 
                case -1: {
                    this.state = 4;
                    return -1;
                }
                case -4: {
                    if (this.state == 2) {
                        next = mapper[this.in.read() + 1];
                    } else if (this.state != 3 && debug != null) {
                        debug.text(0L, className, "reallyRead", "Found '=' in the wrong place");
                    }
                    do {
                        this.next_read = this.in.read();
                    } while (mapper[this.next_read + 1] == -2);
                    this.state = 4;
                    return -1;
                }
            }
            switch (this.state++) {
                case 0: {
                    this.carry = next;
                    continue block11;
                }
                case 1: {
                    int result = this.carry << 2 | next >> 4;
                    this.carry = (byte)(next & 0xF);
                    return result;
                }
                case 2: {
                    int result = this.carry << 4 | next >> 2;
                    this.carry = (byte)(next & 3);
                    return result;
                }
                case 3: {
                    this.state = 0;
                    return this.carry << 6 | next;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    static {
        int i;
        debug = Debug.getInstance((String)"keycertmanage");
        className = "com.ibm.security.certclient.PkBase64InputStream";
        mapper = new byte[257];
        for (i = 1; i < 257; ++i) {
            PkBase64InputStream.mapper[i] = -1;
        }
        for (i = 0; i < base64Values.length; ++i) {
            PkBase64InputStream.mapper[PkBase64InputStream.base64Values[i] + '\u0001'] = (byte)i;
        }
        PkBase64InputStream.mapper[14] = -2;
        PkBase64InputStream.mapper[11] = -2;
        PkBase64InputStream.mapper[0] = -3;
        PkBase64InputStream.mapper[62] = -4;
    }
}

