/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.fmt;

import com.ibm.crypto.provider.PBMParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfRepEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkEvent;
import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkGnrlRepEvent;
import com.ibm.security.certclient.base.PkGnrlReqEvent;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkIoException;
import com.ibm.security.certclient.base.PkKrecRepEvent;
import com.ibm.security.certclient.base.PkKrecReqEvent;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.base.PkRevoRepEvent;
import com.ibm.security.certclient.base.PkRevoReqEvent;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.util.PkArray;
import com.ibm.security.certclient.util.PkString;
import com.ibm.security.cmp.CertOrEncCert;
import com.ibm.security.cmp.CertRepMessage;
import com.ibm.security.cmp.CertResponse;
import com.ibm.security.cmp.CertifiedKeyPair;
import com.ibm.security.cmp.ErrorMsgContent;
import com.ibm.security.cmp.InfoTypeAndValue;
import com.ibm.security.cmp.PKIBody;
import com.ibm.security.cmp.PKIFreeText;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmp.RevDetails;
import com.ibm.security.cmp.RevDetailsv2;
import com.ibm.security.cmp.RevPassphraseInfoValue;
import com.ibm.security.cmp.RevRepContent;
import com.ibm.security.cmp.RevReqContent;
import com.ibm.security.cmp.RevReqContentv2;
import com.ibm.security.crmf.CertReqMessages;
import com.ibm.security.crmf.CertReqMsg;
import com.ibm.security.crmf.CertRequest;
import com.ibm.security.crmf.CertTemplate;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.crmf.OptionalValidity;
import com.ibm.security.crmf.PKIPublicationInfo;
import com.ibm.security.crmf.POPOPrivKey;
import com.ibm.security.crmf.POPOSigningKey;
import com.ibm.security.crmf.ProofOfPossession;
import com.ibm.security.crmf.SinglePubInfo;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PkCmpEventFormatter
extends PkEventFormatter
implements PkConstants {
    private static final String sccsid = "%Z% %M% %I%    %W% %G% %U%";
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static Object className = "com.ibm.security.certclient.fmt.PkCmpEventFormatter";
    private static final PKIStatusInfo statusOk = new PKIStatusInfo(0, null, null);
    private static ObjectIdentifier TPKI_ENROLL_OID = PkCmpEventFormatter.getOID();
    private static final int MESSAGE_BODY_CERTCONF = 24;
    private static final Map<Class, Integer> types = new HashMap<Class, Integer>();
    private BigInteger certReqId = BigInteger.valueOf(0L);
    private final String SIG_PROBS = "Problems signing. Change the exception being thrown";

    private static final ObjectIdentifier getOID() {
        try {
            return new ObjectIdentifier("1.3.6.1.4.1.2.13.5.7.1.3");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PkEvent readEvent(Object source, InputStream is, PkReqEvent req) throws PkException, IOException {
        PkEvent ev;
        block49: {
            boolean messageProtected;
            PKIHeader hdr;
            Object body;
            PKIMessage msg;
            block48: {
                msg = new PKIMessage(new DerValue(is).toByteArray());
                body = msg.getBody();
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "msg is {0}", (Object)msg.toString());
                }
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "msg body type is {0}", (Object)new Integer(msg.getBodyType()));
                }
                hdr = msg.getHeader();
                if (debug != null) {
                    debug.text(0L, className, "readEvent", "#####  sender kid is msg body type is {0}", (Object)hdr.getSenderKID());
                }
                messageProtected = msg.getProtection() != null;
                boolean isCMPv1 = hdr.getPvno().equals(BIG_ONE);
                if (debug != null) {
                    debug.text(0L, className, "readEvent", " isCmpV1 is {0}", (Object)new Boolean(isCMPv1).toString());
                }
                if (msg.getBodyType() != 0 && msg.getBodyType() != 11 && msg.getBodyType() != 12 && msg.getBodyType() != 24 && !isCMPv1) {
                    if (debug != null) {
                        debug.text(0L, className, "readEvent", " reset CMP version to 1 ");
                    }
                    isCMPv1 = true;
                }
                if (!isCMPv1) break block48;
                switch (msg.getBodyType()) {
                    case 0: {
                        PkAttrs attrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)body);
                        attrs.add("cert.oper.messageProtected", 2, new Boolean(messageProtected));
                        attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                        attrs.add("cert.oper.RECIPIENT_DN", 2, hdr.getRecipient());
                        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        attrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        ev = new PkInitReqEvent(source, msg, attrs);
                        break;
                    }
                    case 1: {
                        PrivateKey privateKey = (PrivateKey)req.getAttrs().getValue("cert.oper.privateKeyEE", null);
                        X509CertImpl c = this.getCert((CertRepMessage)body, privateKey);
                        if (c == null) {
                            req.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                            if (debug != null) {
                                debug.text(0L, className, "readEvent", "passThru set to true");
                            }
                        }
                        req.getAttrs().add("cert.oper.responseHeader", 2, hdr);
                        ev = new PkInitRepEvent(source, msg, req, (Certificate)c);
                        break;
                    }
                    case 2: {
                        PkAttrs attrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)body);
                        attrs.add("cert.oper.messageProtected", 2, new Boolean(messageProtected));
                        attrs.add("TMP_MSG_HDR", 2, hdr);
                        attrs.add("cert.oper.responseHeader", 2, hdr);
                        attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                        attrs.add("cert.oper.RECIPIENT_DN", 2, hdr.getRecipient());
                        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        ev = new PkSecnReqEvent(source, msg, attrs);
                        break;
                    }
                    case 3: {
                        PrivateKey privateKey = (PrivateKey)req.getAttrs().getValue("cert.oper.privateKeyEE", null);
                        X509CertImpl c = this.getCert((CertRepMessage)body, privateKey);
                        req.getAttrs().repOrAdd("cert.oper.responseHeader", 2, hdr);
                        if (c == null) {
                            req.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                            if (debug != null) {
                                debug.text(0L, className, "readEvent", "passThru set to true");
                            }
                        } else if (debug != null) {
                            debug.text(0L, className, "readEvent", "passThru set to false as private key available");
                        }
                        ev = new PkSecnRepEvent(source, msg, req, (Certificate)c);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        throw new UnsupportedOperationException(PkNLSConstants.CMPEVENT_UNSUPPORTED_EVENT + msg.getBodyType());
                    }
                    case 7: {
                        ev = new PkKupdReqEvent(source, msg, PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)body));
                        break;
                    }
                    case 8: {
                        ev = new PkKupdRepEvent(source, msg, req, (Certificate)this.getCert((CertRepMessage)body, null));
                        break;
                    }
                    case 9: {
                        ev = new PkKrecReqEvent(source, msg, null);
                        break;
                    }
                    case 10: {
                        ev = new PkKrecRepEvent(source, msg, req);
                        break;
                    }
                    case 11: {
                        PkAttrs attrs = PkCmpEventFormatter.getAttrsFromRevReqContent((RevReqContent)body);
                        if (attrs.getValue("x509.info.key", null) != null) {
                            attrs.add("x509.info.certrevopublickey", 2, attrs.getValue("x509.info.key"));
                        }
                        attrs.add("TMP_MSG_HDR", 2, hdr);
                        attrs.add("cert.oper.messageProtected", 2, new Boolean(messageProtected));
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "case-rr, msgProtected is {0}", (Object)new Boolean(messageProtected));
                        }
                        if (messageProtected) {
                            attrs.add("PASSTHRU", 2, Boolean.TRUE);
                        }
                        attrs.add("x509.info.algorithmID", 2, hdr.getProtectionAlg());
                        attrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        attrs.add("cert.oper.certRevocationPassphrase", 2, hdr.getGeneralInfo());
                        ev = new PkRevoReqEvent(source, msg, attrs);
                        break;
                    }
                    case 12: {
                        ev = new PkRevoRepEvent(source, msg, req);
                        break;
                    }
                    case 13: {
                        PkAttrs attrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)body);
                        attrs.add("cert.oper.RECIPIENT_DN", 2, hdr.getRecipient());
                        attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                        attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                        attrs.add("cert.oper.CMP_VERSION", 2, BIG_ONE);
                        ev = new PkXcerReqEvent(source, msg, attrs);
                        break;
                    }
                    case 14: {
                        req.getAttrs().add("cert.oper.responseHeader", 2, hdr);
                        ev = new PkXcerRepEvent(source, msg, req, (Certificate)this.getCert((CertRepMessage)body, null));
                        break;
                    }
                    case 19: {
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "######### from message_body_conf, msg is {0}", (Object)msg);
                        }
                        PkAttrs attrs = new PkAttrs();
                        PkCmpEventFormatter.add(attrs, "HDR", msg.getHeader());
                        attrs.add("cert.oper.certRevocationPassphrase", 2, hdr.getGeneralInfo());
                        attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                        ev = new PkConfReqEvent(source, msg, attrs);
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "########## the confReqEvent is {0}", (Object)ev);
                            break;
                        }
                        break block49;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: {
                        throw new UnsupportedOperationException(PkNLSConstants.CMPEVENT_UNSUPPORTED_EVENT + msg.getBodyType());
                    }
                    case 21: {
                        ev = new PkGnrlReqEvent(source, msg, null);
                        break;
                    }
                    case 22: {
                        ev = new PkGnrlRepEvent(source, msg, req);
                        break;
                    }
                    case 23: {
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "############ MESSAGE_BODY_ERROR... body ={0} ", body);
                        }
                        this.throwException((ErrorMsgContent)body);
                        ev = null;
                        break;
                    }
                    default: {
                        throw new PkIoException(PkNLSConstants.CMPEVENT_INVALID_PKI_MESSAGE_TAG + msg.getBodyType());
                    }
                }
                break block49;
            }
            switch (msg.getBodyType()) {
                case 0: {
                    PkAttrs attrs = PkCmpEventFormatter.getAttrsFromCertReqMessages((CertReqMessages)body);
                    attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                    attrs.add("cert.oper.RECIPIENT_DN", 2, hdr.getRecipient());
                    attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                    attrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    ev = new PkInitReqEvent(source, msg, attrs);
                    break;
                }
                case 1: {
                    PrivateKey privateKey = (PrivateKey)req.getAttrs().getValue("cert.oper.privateKeyEE", null);
                    X509CertImpl c = this.getCert((CertRepMessage)body, privateKey);
                    if (c == null) {
                        req.getAttrs().add("PASSTHRU", 2, Boolean.TRUE);
                        if (debug != null) {
                            debug.text(0L, className, "readEvent", "passThru set to true");
                        }
                    }
                    req.getAttrs().add("cert.oper.responseHeader", 2, hdr);
                    req.getAttrs().add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    ev = new PkInitRepEvent(source, msg, req, (Certificate)c);
                    break;
                }
                case 11: {
                    PkAttrs attrs = PkCmpEventFormatter.getAttrsFromRevReqContent((RevReqContentv2)body);
                    attrs.add("TMP_MSG_HDR", 2, hdr);
                    attrs.add("cert.oper.messageProtected", 2, new Boolean(messageProtected));
                    attrs.add("x509.info.algorithmID", 2, hdr.getProtectionAlg());
                    attrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    ev = new PkRevoReqEvent(source, msg, attrs);
                    break;
                }
                case 12: {
                    PkAttrs attrs = req.getAttrs();
                    attrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    attrs.add("cert.oper.responseHeader", 2, hdr);
                    attrs.add("cert.oper.PROVIDER", 2, PkEeFactory.getProvider());
                    ev = new PkRevoRepEvent(source, msg, req);
                    break;
                }
                case 24: {
                    if (debug != null) {
                        debug.text(0L, className, "readEvent", "from message_body_conf -v2, msg is {0}", (Object)msg);
                    }
                    PkAttrs attrs = new PkAttrs();
                    attrs.add("cert.oper.CMP_VERSION", 2, BIG_TWO);
                    PkCmpEventFormatter.add(attrs, "HDR", msg.getHeader());
                    attrs.add("cert.oper.certRevocationPassphrase", 2, hdr.getGeneralInfo());
                    attrs.add("cert.oper.SenderKeyIdentifier", 2, hdr.getSenderKID());
                    ev = new PkConfReqEvent(source, msg, attrs);
                    if (debug == null) break;
                    debug.text(0L, className, "readEvent", "########## the confReqEvent is {0}", (Object)ev);
                    break;
                }
                default: {
                    throw new PkIoException(PkNLSConstants.CMPEVENT_INVALID_PKI_MESSAGE_TAG + msg.getBodyType());
                }
            }
        }
        return ev;
    }

    @Override
    public void writeException(Exception e, OutputStream out) throws IOException {
        Throwable wE;
        PkException myE;
        boolean[] failureInfo = null;
        PKIFreeText freeText = null;
        ErrorMsgContent errorMsgContent = null;
        if (e.getMessage() != null) {
            String emsg = new String(e.getMessage().getBytes("UTF-8"), "UTF-8");
            if (debug != null) {
                debug.text(0L, className, "writeException..", "emsg is {0}", (Object)emsg);
            }
            freeText = new PKIFreeText(new String[]{emsg});
        } else if (e instanceof PkException && (myE = (PkException)e).hasWrappedException() && (wE = myE.getWrappedException()).getMessage() != null) {
            freeText = new PKIFreeText(new String[]{wE.getMessage()});
        }
        if (e instanceof PkRejectionException) {
            PkRejectionException exc = (PkRejectionException)e;
            failureInfo = exc.getFailureInfo();
        }
        PKIStatusInfo statusInfo = new PKIStatusInfo(2, freeText, failureInfo);
        errorMsgContent = new ErrorMsgContent(statusInfo, null, null);
        GeneralName sender = new GeneralName((GeneralNameInterface)new X500Name(""));
        GeneralName recipient = new GeneralName((GeneralNameInterface)new X500Name(""));
        PKIHeader header = new PKIHeader(BIG_ONE, sender, recipient, null, null, null, null, null, null, null, null, null);
        new PKIMessage(header, 23, (Object)errorMsgContent, null, null).encode(out);
    }

    private void throwException(ErrorMsgContent errorMsgContent) throws PkException {
        int status = errorMsgContent.getPKIStatusInfo().getStatus();
        switch (status) {
            case 0: 
            case 1: 
            case 2: {
                Object[] errors = new String[]{};
                PKIStatusInfo statusInfo = null;
                try {
                    statusInfo = errorMsgContent.getPKIStatusInfo();
                    errors = (String[])statusInfo.getStatusString().getFreeText().clone();
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                try {
                    errors = (String[])PkArray.append(errors, errorMsgContent.getErrorDetails().getFreeText());
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                String msg = PkString.join((String[])errors, "\n");
                if (statusInfo == null) {
                    throw new PkRejectionException(msg);
                }
                throw new PkRejectionException(msg, statusInfo.getFailureInfos());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String[] errors = errorMsgContent.getErrorDetails().getFreeText();
                String msg = errors != null && errors.length > 0 ? errors[0] : "";
                throw new PkException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCertReq(PkCertReqEvent req, OutputStream out) throws IOException, PkException {
        BigInteger id;
        PkCmpEventFormatter pkCmpEventFormatter = this;
        synchronized (pkCmpEventFormatter) {
            id = this.certReqId;
            this.certReqId = this.certReqId.add(BigInteger.ONE);
        }
        PkAttrs attrSet = req.getAttrs();
        Boolean messageProtected = (Boolean)req.getAttrs().getValue("cert.oper.messageProtected", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeCertReq", "messageProtected {0}", (Object)messageProtected);
        }
        if (messageProtected.booleanValue()) {
            PKIMessage msg = (PKIMessage)req.getMsg();
            msg.encode(out);
        } else {
            GeneralName sender = new GeneralName((GeneralNameInterface)((X500Name)attrSet.getValue("x509.info.subject")));
            KeyIdentifier senderKid = (KeyIdentifier)attrSet.getValue("cert.oper.SenderKeyIdentifier");
            GeneralName recipient = (GeneralName)attrSet.getValue("cert.oper.RECIPIENT_DN");
            InfoTypeAndValue[] itva = null;
            itva = (InfoTypeAndValue[])attrSet.getValue("cert.oper.certRevocationPassphrase", null);
            CertTemplate certTemplate = new CertTemplate();
            if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
                Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
                Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
                certTemplate.setValidity(new OptionalValidity(notBefore, notAfter));
            }
            PkCmpEventFormatter.addToTempl(certTemplate, attrSet);
            CertRequest certRequest = new CertRequest(id, certTemplate, null);
            ProofOfPossession pop = null;
            try {
                PublicKey publicKey = (PublicKey)attrSet.getValue("x509.info.key");
            }
            catch (NoSuchElementException e) {
                PkException myE = new PkException(e);
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", myE.getMessage());
                }
                throw myE;
            }
            DerOutputStream dosCertRequest = new DerOutputStream();
            certRequest.encode((OutputStream)dosCertRequest);
            boolean isDigitalSig = false;
            boolean bitsSet = false;
            KeyUsageExtension kue = (KeyUsageExtension)attrSet.getValue("x509.info.extensions.KeyUsage", null);
            boolean keyUsageSpecified = true;
            boolean[] ba = null;
            if (kue == null) {
                keyUsageSpecified = false;
            } else {
                ba = kue.getBits();
                if (ba.length == 0) {
                    keyUsageSpecified = false;
                }
            }
            String provider = (String)attrSet.getValue("cert.oper.PROVIDER", null);
            if (provider == null) {
                PkRejectionException myE = new PkRejectionException(PkNLSConstants.NEED_PROVIDER);
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", myE.getMessage());
                }
                throw myE;
            }
            if (keyUsageSpecified) {
                isDigitalSig = ba[0];
            }
            if (isDigitalSig || !keyUsageSpecified) {
                try {
                    String tmpAlg = null;
                    if (debug != null) {
                        debug.text(0L, className, "writeCertReq", "######## from PkCmpEventFormatter... digitalSignature");
                    }
                    PrivateKey privateKey = (PrivateKey)attrSet.getValue("cert.oper.privateKey", null);
                    tmpAlg = (String)attrSet.getValue("x509.info.algorithmName", null);
                    if (privateKey != null) {
                        Signature signature = Signature.getInstance(tmpAlg, provider);
                        signature.initSign(privateKey);
                        signature.update(dosCertRequest.toByteArray());
                        byte[] sign = signature.sign();
                        AlgorithmId algId = (AlgorithmId)attrSet.getValue("x509.info.algorithmID", null);
                        POPOSigningKey poposignKey = new POPOSigningKey(null, algId, sign);
                        pop = new ProofOfPossession(1, (Object)poposignKey);
                    }
                }
                catch (GeneralSecurityException e) {
                    if (debug != null) {
                        debug.text(0L, className, "writeCertReq", e.getMessage());
                    }
                    e.printStackTrace();
                }
            } else {
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", "######## from PkCmpEventFormatter... encipherment");
                }
                POPOPrivKey popoprivKey = new POPOPrivKey(1, (Object)new Integer(0));
                pop = new ProofOfPossession(2, (Object)popoprivKey);
            }
            CertReqMsg certReqMsg = new CertReqMsg(certRequest, pop, null);
            CertReqMessages certReqMessages = new CertReqMessages(new CertReqMsg[]{certReqMsg});
            AlgorithmId pbmalgid = this.generateProtectionAlg(provider);
            BigInteger pvNo = (BigInteger)attrSet.getValue("cert.oper.CMP_VERSION");
            PKIHeader pkiHeader = new PKIHeader(pvNo, sender, recipient, new Date(), pbmalgid, senderKid, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, itva);
            if (debug != null) {
                debug.text(0L, className, "writeCertReq", "pkiHeader ={0} ", (Object)pkiHeader);
            }
            PKIMessage pkiMessage = new PKIMessage(pkiHeader, PkCmpEventFormatter.getBodyType(req), (Object)certReqMessages, null, null);
            PKIMessage pkiMessage1 = null;
            try {
                String initPwd = (String)attrSet.getValue("x509.info.init_pwd");
                pkiMessage1 = initPwd != null ? pkiMessage.protect(initPwd.getBytes()) : pkiMessage;
            }
            catch (Exception e) {
                PkException myE = new PkException(e);
                if (debug != null) {
                    debug.text(0L, className, "writeCertReq", myE.getMessage());
                }
                throw myE;
            }
            pkiMessage1.encode(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSecnReq(PkSecnReqEvent req, OutputStream out) throws IOException, PkException {
        Boolean passThru = (Boolean)req.getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnReq", "passThru = {0}", (Object)passThru);
        }
        Boolean messageProtected = (Boolean)req.getAttrs().getValue("cert.oper.messageProtected", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnReq", "messageProtected {0}", (Object)messageProtected);
        }
        if (passThru.booleanValue() || messageProtected.booleanValue()) {
            PKIMessage msg = (PKIMessage)req.getMsg();
            msg.encode(out);
        } else {
            boolean[] baba;
            BigInteger id;
            PkCmpEventFormatter pkCmpEventFormatter = this;
            synchronized (pkCmpEventFormatter) {
                id = this.certReqId;
                this.certReqId = this.certReqId.add(BigInteger.ONE);
            }
            PkAttrs attrSet = req.getAttrs();
            GeneralName sender = new GeneralName((GeneralNameInterface)((X500Name)attrSet.getValue("x509.info.subject")));
            GeneralName recipient = (GeneralName)attrSet.getValue("cert.oper.RECIPIENT_DN");
            CertTemplate certTemplate = new CertTemplate();
            if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
                Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
                Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
                certTemplate.setValidity(new OptionalValidity(notBefore, notAfter));
            }
            PkCmpEventFormatter.addToTempl(certTemplate, attrSet);
            CertRequest certRequest = new CertRequest(id, certTemplate, null);
            try {
                PublicKey publicKey = (PublicKey)attrSet.getValue("x509.info.key");
            }
            catch (NoSuchElementException e) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", e.getMessage());
                }
                throw new PkException(e);
            }
            DerOutputStream dosCertRequest = new DerOutputStream();
            certRequest.encode((OutputStream)dosCertRequest);
            boolean isDigitalSig = false;
            KeyUsageExtension kue = (KeyUsageExtension)attrSet.getValue("x509.info.extensions.KeyUsage", null);
            isDigitalSig = kue != null ? ((baba = kue.getBits()).length == 0 ? true : baba[0]) : true;
            ProofOfPossession pop = null;
            PrivateKey privateKey = (PrivateKey)attrSet.getValue("cert.oper.privateKey", null);
            if (privateKey != null) {
                if (isDigitalSig) {
                    try {
                        String tmpAlg = (String)attrSet.getValue("x509.info.algorithmName", null);
                        Signature signature = Signature.getInstance(tmpAlg, (String)attrSet.getValue("cert.oper.PROVIDER"));
                        signature.initSign(privateKey);
                        signature.update(dosCertRequest.toByteArray());
                        byte[] sign = signature.sign();
                        AlgorithmId algId = (AlgorithmId)attrSet.getValue("x509.info.algorithmID", null);
                        POPOSigningKey poposignKey = new POPOSigningKey(null, algId, sign);
                        pop = new ProofOfPossession(1, (Object)poposignKey);
                    }
                    catch (Exception e) {
                        if (e instanceof PkException) {
                            if (debug != null) {
                                debug.text(0L, className, "writeSecnReq", e.getMessage());
                            }
                            throw (PkException)e;
                        }
                        PkException myE = new PkException(e);
                        if (debug != null) {
                            debug.text(0L, className, "writeSecnReq", myE.getMessage());
                        }
                        throw myE;
                    }
                } else {
                    POPOPrivKey popoprivKey = new POPOPrivKey(1, (Object)new Integer(0));
                    pop = new ProofOfPossession(2, (Object)popoprivKey);
                }
            }
            CertReqMsg certReqMsg = new CertReqMsg(certRequest, pop, null);
            CertReqMessages certReqMessages = new CertReqMessages(new CertReqMsg[]{certReqMsg});
            String msgProtAlgorithmName = (String)attrSet.getValue("x509.info.messageProtectionAlgorithmName");
            AlgorithmId msgProtAlgId = (AlgorithmId)attrSet.getValue("x509.info.messageProtectionAlgorithmID");
            KeyIdentifier ki = (KeyIdentifier)attrSet.getValue("cert.oper.SenderKeyIdentifier");
            PKIHeader pkiHeader = new PKIHeader(BIG_ONE, sender, recipient, new Date(), msgProtAlgId, ki, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, null);
            DerOutputStream dos = new DerOutputStream();
            pkiHeader.encode((OutputStream)dos);
            PKIBody pbody = new PKIBody(PkCmpEventFormatter.getBodyType(req), (Object)certReqMessages);
            pbody.encode((OutputStream)dos);
            DerOutputStream derOut = new DerOutputStream();
            derOut.write((byte)48, dos);
            byte[] ba = derOut.toByteArray();
            byte[] ba1 = null;
            try {
                String providerName = (String)attrSet.getValue("cert.oper.PROVIDER");
                Signature sig = Signature.getInstance(msgProtAlgorithmName, providerName);
                PrivateKey pKey = (PrivateKey)attrSet.getValue("cert.oper.messageProtectionKey", null);
                if (pKey == null) {
                    PkRejectionException myE = new PkRejectionException(PkNLSConstants.MISSING_PRIVATE_KEY);
                    if (debug != null) {
                        debug.text(0L, className, "writeSecnReq", myE.getMessage());
                    }
                    throw myE;
                }
                sig.initSign(pKey);
                sig.update(ba);
                ba1 = sig.sign();
            }
            catch (NoSuchAlgorithmException e) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", "Exception from writeCertReq (CR case) in cmpeventformatter");
                }
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", e.getMessage());
                    debug.text(0L, className, "writeSecnReq", e.getMessage());
                }
                PkRejectionException myE = new PkRejectionException(PkNLSConstants.NO_SUCH_ALGORITHM_EXCEPTION);
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", myE.getMessage());
                }
                throw myE;
            }
            catch (GeneralSecurityException e) {
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", "Exception from writeCertReq (CR case) in cmpeventformatter");
                }
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", e.getMessage());
                    debug.text(0L, className, "writeSecnReq", e.getMessage());
                }
                PkRejectionException myE = new PkRejectionException(PkNLSConstants.GENERAL_SECURITY_EXCEPTION);
                if (debug != null) {
                    debug.text(0L, className, "writeSecnReq", myE.getMessage());
                }
                throw myE;
            }
            PKIMessage pkiMessage = new PKIMessage(pkiHeader, PkCmpEventFormatter.getBodyType(req), (Object)certReqMessages, ba1, null);
            if (debug != null) {
                debug.text(0L, className, "writeSecnReq", "From writeSecnReq(CR) {0}", (Object)pkiMessage);
            }
            pkiMessage.encode(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXcerReq(PkXcerReqEvent req, OutputStream out) throws IOException, PkException {
        BigInteger id;
        PkCmpEventFormatter pkCmpEventFormatter = this;
        synchronized (pkCmpEventFormatter) {
            id = this.certReqId;
            this.certReqId = this.certReqId.add(BigInteger.ONE);
        }
        PkAttrs attrSet = req.getAttrs();
        GeneralName sender = null;
        GeneralName recipient = null;
        try {
            sender = new GeneralName((GeneralNameInterface)((X500Name)attrSet.getValue("x509.info.subject")));
            recipient = (GeneralName)attrSet.getValue("cert.oper.RECIPIENT_DN");
        }
        catch (NoSuchElementException e) {
            PkException myE = new PkException(e);
            if (debug != null) {
                debug.text(0L, className, "writeXCertReq", myE.getMessage());
            }
            throw myE;
        }
        KeyIdentifier senderKid = (KeyIdentifier)attrSet.getValue("cert.oper.SenderKeyIdentifier");
        CertTemplate certTemplate = new CertTemplate();
        if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
            Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
            Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
            certTemplate.setValidity(new OptionalValidity(notBefore, notAfter));
        }
        PkCmpEventFormatter.addToTempl(certTemplate, attrSet);
        try {
            BasicConstraintsExtension bce = (BasicConstraintsExtension)certTemplate.getExtensions().get("BasicConstraints");
            Boolean bool = (Boolean)bce.get("is_ca");
            if (!bool.booleanValue()) {
                PkRejectionException myE = new PkRejectionException(PkNLSConstants.BASIC_CONSTRAINTS_EXTENSION_MUST_BE_FOR_CA);
                if (debug != null) {
                    debug.text(0L, className, "writeXcerReq", myE.getMessage());
                }
                throw myE;
            }
        }
        catch (IOException x) {
            BasicConstraintsExtension bce = new BasicConstraintsExtension(true, 1);
            certTemplate.addExtension(new Extension[]{bce});
        }
        try {
            PublicKey publicKey = (PublicKey)attrSet.getValue("x509.info.key");
        }
        catch (NoSuchElementException e) {
            PkException myE = new PkException(e);
            if (debug != null) {
                debug.text(0L, className, "writeXCerReq", myE.getMessage());
            }
            throw myE;
        }
        boolean isDigitalSig = false;
        boolean bitsSet = false;
        KeyUsageExtension kue = (KeyUsageExtension)attrSet.getValue("x509.info.extensions.KeyUsage", null);
        if (kue == null) {
            kue = new KeyUsageExtension();
            kue.set("key_certsign", (Object)Boolean.TRUE);
            certTemplate.addExtension(new Extension[]{kue});
        } else {
            boolean[] baba = kue.getBits();
            int length = baba.length;
            if (length == 0) {
                kue = new KeyUsageExtension();
                kue.set("key_certsign", (Object)Boolean.TRUE);
                certTemplate.addExtension(new Extension[]{kue});
            } else {
                boolean properKeyUsage = false;
                int sum = 0;
                for (int i = 0; i < length; ++i) {
                    if (!baba[i]) continue;
                    sum += i;
                }
                if (sum == 5 || sum == 6 || sum == 11) {
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerReq", "keyUsageExtension is ok. sum ={0} ", (Object)new Integer(sum));
                    }
                } else {
                    PkRejectionException myE = new PkRejectionException(PkNLSConstants.CERT_BAD_KEY_USAGE);
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerReq", myE.getMessage());
                    }
                    throw myE;
                }
            }
        }
        CertRequest certRequest = new CertRequest(id, certTemplate, null);
        DerOutputStream dosCertRequest = new DerOutputStream();
        certRequest.encode((OutputStream)dosCertRequest);
        String provider = (String)attrSet.getValue("cert.oper.PROVIDER", null);
        if (provider == null || provider.length() == 0) {
            PkRejectionException myE = new PkRejectionException(PkNLSConstants.NEED_PROVIDER);
            if (debug != null) {
                debug.text(0L, className, "writeXcerReq", myE.getMessage());
            }
            throw myE;
        }
        ProofOfPossession pop = null;
        CertReqMsg certReqMsg = new CertReqMsg(certRequest, pop, null);
        CertReqMessages certReqMessages = new CertReqMessages(new CertReqMsg[]{certReqMsg});
        AlgorithmId pbmalgid = this.generateProtectionAlg(provider);
        BigInteger pvNo = (BigInteger)attrSet.getValue("cert.oper.CMP_VERSION", BIG_ONE);
        PKIHeader pkiHeader = new PKIHeader(pvNo, sender, recipient, new Date(), pbmalgid, senderKid, null, new Long(new Date().getTime()).toString().getBytes(), new Date().toString().getBytes(), null, null, null);
        if (debug != null) {
            debug.text(0L, className, "writeXCerReq", "pkiHeader ={0} ", (Object)pkiHeader);
        }
        PKIMessage pkiMessage = new PKIMessage(pkiHeader, PkCmpEventFormatter.getBodyType(req), (Object)certReqMessages, null, null);
        PKIMessage pkiMessage1 = null;
        try {
            String initPwd = (String)attrSet.getValue("x509.info.init_pwd");
            if (initPwd != null) {
                pkiMessage1 = pkiMessage.protect(initPwd.getBytes());
            }
        }
        catch (Exception e) {
            PkException myE = new PkException(e);
            if (debug != null) {
                debug.text(0L, className, "writeXCertReq", myE.getMessage());
            }
            throw myE;
        }
        if (debug != null) {
            debug.text(0L, className, "writeXCertReq", "pkiMessage1 ={0} ", (Object)pkiMessage1);
        }
        pkiMessage1.encode(out);
    }

    @Override
    public void writeCertRep(PkCertRepEvent rep, OutputStream out) throws IOException, PkException {
        Boolean passThru = (Boolean)rep.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeCertRep", "passThru = {0}", (Object)passThru);
        }
        if (passThru.booleanValue()) {
            PKIMessage msg = (PKIMessage)rep.getMsg();
            msg.encode(out);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)rep.getCert();
            PkAttrs attrs = rep.getReq().getAttrs();
            CertOrEncCert certOrEncCert = null;
            CertifiedKeyPair certifiedKeyPair = null;
            SinglePubInfo[] pInfo = new SinglePubInfo[1];
            PKIPublicationInfo pubInfo = new PKIPublicationInfo(0, pInfo);
            certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, pubInfo);
            PkReqEvent req = rep.getReq();
            PkAttrs attrSet = req.getAttrs();
            this.certReqId = (BigInteger)attrSet.getValue("cert.oper.certReqId");
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            Certificate[] caPubs = (Certificate[])attrSet.getValue("cert.oper.caPubs");
            CertRepMessage certRepMessage = new CertRepMessage(caPubs, new CertResponse[]{certResponse});
            PKIMessage pkiMessage = null;
            if (req instanceof PkInitReqEvent) {
                Boolean ra_enroll = (Boolean)attrSet.getValue("cert.oper.raEnrollment", Boolean.FALSE);
                if (!ra_enroll.booleanValue()) {
                    PKIMessage pkiMessage2 = new PKIMessage((PKIHeader)rep.getReq().getAttrs().getValue("cert.oper.responseHeader"), 1, (Object)certRepMessage, null, null);
                    pkiMessage = null;
                    try {
                        String initPwd = (String)attrSet.getValue("x509.info.init_pwd", null);
                        if (initPwd == null) {
                            pkiMessage = pkiMessage2;
                        }
                        pkiMessage = pkiMessage2.protect(initPwd.getBytes());
                    }
                    catch (Exception e) {
                        if (e instanceof PkException) {
                            if (debug != null) {
                                debug.text(0L, className, "writeCertReq", e.getMessage());
                            }
                            throw (PkException)e;
                        }
                        PkException myE = new PkException(e);
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", myE.getMessage());
                        }
                        throw myE;
                    }
                } else {
                    DerOutputStream dos = new DerOutputStream();
                    PKIHeader pkiHeader = (PKIHeader)rep.getReq().getAttrs().getValue("cert.oper.responseHeader");
                    pkiHeader.encode((OutputStream)dos);
                    PKIBody pbody = new PKIBody(1, (Object)certRepMessage);
                    pbody.encode((OutputStream)dos);
                    DerOutputStream derOut = new DerOutputStream();
                    derOut.write((byte)48, dos);
                    byte[] ba = derOut.toByteArray();
                    byte[] ba1 = null;
                    String providerName = null;
                    try {
                        providerName = PkEeFactory.getProvider();
                        String algorithmName = (String)attrSet.getValue("x509.info.algorithmName");
                        PrivateKey privateKey = (PrivateKey)attrSet.getValue("cert.oper.privateKey", null);
                        if (privateKey != null) {
                            Object algId = null;
                            Signature sig = Signature.getInstance(algorithmName, providerName);
                            sig.initSign(privateKey);
                            sig.update(ba);
                            ba1 = sig.sign();
                        }
                    }
                    catch (GeneralSecurityException e) {
                        PkException myE = new PkException(e);
                        if (debug != null) {
                            debug.text(0L, className, "writeCertReq", myE.getMessage());
                        }
                        throw myE;
                    }
                    Certificate[] extraCerts = new Certificate[]{x509CertImpl};
                    pkiMessage = new PKIMessage(pkiHeader, 1, (Object)certRepMessage, ba1, caPubs);
                }
            } else if (req instanceof PkSecnReqEvent) {
                pkiMessage = new PKIMessage((PKIHeader)rep.getReq().getAttrs().getValue("cert.oper.responseHeader"), 3, (Object)certRepMessage, null, null);
            }
            if (debug != null) {
                debug.text(0L, className, "writeCertRep", "######## in writeCertRep....., pkiMessage = {0}", pkiMessage);
                debug.text(0L, className, "writeCertRep", "writeCertRep/secnReqEvent...., rep = {0}", (Object)rep);
            }
            pkiMessage.encode(out);
        }
    }

    public void writeSecnRep(PkCertRepEvent rep, OutputStream out) throws IOException {
        Boolean passThru = (Boolean)rep.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeSecnRep", "passThru = {0}", (Object)passThru);
        }
        if (passThru.booleanValue()) {
            PKIMessage msg = (PKIMessage)rep.getMsg();
            msg.encode(out);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)rep.getCert();
            CertOrEncCert certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            CertifiedKeyPair certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, null);
            this.certReqId = this.certReqId.add(BigInteger.ONE);
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            CertRepMessage certRepMessage = new CertRepMessage(null, new CertResponse[]{certResponse});
            PKIMessage pkiMessage = new PKIMessage((PKIHeader)rep.getReq().getAttrs().getValue("cert.oper.responseHeader"), 3, (Object)certRepMessage, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeSecnRep", "######## in writeSecnRep....., pkiMessage = {0}", (Object)pkiMessage);
            }
            pkiMessage.encode(out);
        }
    }

    @Override
    public void writeXcerRep(PkXcerRepEvent rep, OutputStream out) throws IOException, PkException {
        Boolean passThru = (Boolean)rep.getReq().getAttrs().getValue("PASSTHRU", Boolean.FALSE);
        if (debug != null) {
            debug.text(0L, className, "writeXCerRep", "passThru = {0}", (Object)passThru);
        }
        if (passThru.booleanValue()) {
            PKIMessage msg = (PKIMessage)rep.getMsg();
            msg.encode(out);
        } else {
            X509CertImpl x509CertImpl = (X509CertImpl)rep.getCert();
            PkAttrs attrs = rep.getReq().getAttrs();
            boolean isDigitalSig = true;
            CertOrEncCert certOrEncCert = null;
            CertifiedKeyPair certifiedKeyPair = null;
            SinglePubInfo[] pInfo = new SinglePubInfo[1];
            PKIPublicationInfo pubInfo = new PKIPublicationInfo(0, pInfo);
            certOrEncCert = new CertOrEncCert((Certificate)x509CertImpl);
            certifiedKeyPair = new CertifiedKeyPair(certOrEncCert, null, pubInfo);
            PkReqEvent req = rep.getReq();
            PkAttrs attrSet = req.getAttrs();
            this.certReqId = (BigInteger)attrSet.getValue("cert.oper.certReqId");
            CertResponse certResponse = new CertResponse(this.certReqId, statusOk, certifiedKeyPair, null);
            Certificate[] caPubs = (Certificate[])attrSet.getValue("cert.oper.caPubs");
            CertRepMessage certRepMessage = new CertRepMessage(caPubs, new CertResponse[]{certResponse});
            PKIMessage pkiMessage = null;
            PKIMessage pkiMessage2 = new PKIMessage((PKIHeader)rep.getReq().getAttrs().getValue("cert.oper.responseHeader"), 14, (Object)certRepMessage, null, null);
            pkiMessage = null;
            try {
                String initPwd = (String)attrSet.getValue("x509.info.init_pwd", null);
                pkiMessage = initPwd == null ? pkiMessage2 : pkiMessage2.protect(initPwd.getBytes());
            }
            catch (Exception e) {
                if (e instanceof PkException) {
                    if (debug != null) {
                        debug.text(0L, className, "writeXCerRep", e.getMessage());
                    }
                    throw (PkException)e;
                }
                PkException myE = new PkException(e);
                if (debug != null) {
                    debug.text(0L, className, "writeXCerRep", myE.getMessage());
                }
                throw myE;
            }
            if (debug != null) {
                debug.text(0L, className, "writeXCerRep", "######## in writeXcerRep....., pkiMessage = {0}", (Object)pkiMessage);
            }
            pkiMessage.encode(out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeRevoReq(PkRevoReqEvent req, OutputStream out) throws IOException, PkException {
        ReasonFlags reasons;
        boolean isFromBrowser;
        boolean removeFromCRL = false;
        CertTemplate certTemplate = new CertTemplate();
        PkAttrs attrSet = req.getAttrs();
        String fromBrowser = (String)attrSet.getValue("FROM_BROWSER", null);
        boolean bl = isFromBrowser = fromBrowser != null;
        if (!isFromBrowser) {
            ReasonFlags reasons2;
            Boolean messageProtected = (Boolean)attrSet.getValue("cert.oper.messageProtected", Boolean.FALSE);
            if (debug != null) {
                debug.text(0L, className, "writeRevoReq", "messageProtected {0}", (Object)messageProtected);
            }
            Boolean passThru = (Boolean)attrSet.getValue("PASSTHRU", Boolean.FALSE);
            if (debug != null) {
                debug.text(0L, className, "writeRevoReq", "passThru {0}", (Object)passThru);
            }
            if (messageProtected.booleanValue() || passThru.booleanValue()) {
                if (debug != null) {
                    debug.text(0L, className, "writeRevoReq", "Send message through");
                }
                PKIMessage msg = (PKIMessage)req.getMsg();
                msg.encode(out);
                return;
            }
            InfoTypeAndValue[] itva = (InfoTypeAndValue[])attrSet.getValue("cert.oper.certRevocationPassphrase", null);
            PrivateKey pKey = (PrivateKey)attrSet.getValue("cert.oper.privateKey", null);
            if (itva == null && pKey == null) {
                throw new PkRejectionException(PkNLSConstants.MSG_CANNOT_BE_PROTECTED);
            }
            String revoPassphrase = null;
            if (itva != null) {
                RevPassphraseInfoValue rP = null;
                try {
                    rP = new RevPassphraseInfoValue(itva[0].getValue());
                    EncryptedValue eV = (EncryptedValue)rP.getValue();
                    revoPassphrase = new String(eV.getEncValue());
                }
                catch (IOException e) {
                    revoPassphrase = null;
                }
            }
            if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
                Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
                Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
                certTemplate.setValidity(new OptionalValidity(notBefore, notAfter));
            }
            PkCmpEventFormatter.addToTempl(certTemplate, attrSet);
            BigInteger otmp = (BigInteger)attrSet.getValue("x509.info.serialNumber", null);
            Date date = (Date)attrSet.getValue("revo.badSinceDate", null);
            if (date == null) {
                PkException myE = new PkException(PkNLSConstants.MISSING_BAD_SINCE_DATE);
                if (debug == null) throw myE;
                debug.text(0L, className, "writeRevoReq", myE.getMessage());
                throw myE;
            }
            Integer Intreason = (Integer)attrSet.getValue("revo.reasonFlags", null);
            if (Intreason == null) {
                reasons2 = null;
            } else {
                boolean[] ba;
                int reason = Intreason;
                if (reason >= 0 && reason <= 8 && reason != 7) {
                    ba = new boolean[8];
                    for (int i = 0; i < ba.length; ++i) {
                        ba[i] = false;
                    }
                } else {
                    PkRejectionException myE = new PkRejectionException(PkNLSConstants.INCORRECT_REASON);
                    if (debug == null) throw myE;
                    debug.text(0L, className, "writeRevoReq", myE.getMessage());
                    throw myE;
                }
                if (reason != 8) {
                    ba[reason] = true;
                } else {
                    removeFromCRL = true;
                    ba[0] = true;
                }
                reasons2 = new ReasonFlags(ba);
            }
            CRLExtensions crlExt = (CRLExtensions)attrSet.getValue("revo.extensions", null);
            if (removeFromCRL) {
                CRLReasonCodeExtension r = new CRLReasonCodeExtension(false, 8);
                if (crlExt == null) {
                    crlExt = new CRLExtensions();
                }
                crlExt.set("CRLReasonCode", (Object)r);
            }
            PKIHeader tmpHdr = null;
            tmpHdr = (PKIHeader)attrSet.getValue("TMP_MSG_HDR");
            AlgorithmId algId = null;
            String algorithmName = (String)attrSet.getValue("x509.info.algorithmName", null);
            algId = (AlgorithmId)attrSet.getValue("x509.info.algorithmID", null);
            if (algId == null) {
                if ("SHA1withRSA".equalsIgnoreCase(algorithmName)) {
                    algId = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
                } else if ("MD5withRSA".equalsIgnoreCase(algorithmName)) {
                    algId = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
                } else if ("MD2withRSA".equalsIgnoreCase(algorithmName)) {
                    algId = new AlgorithmId(AlgorithmId.md2WithRSAEncryption_oid);
                } else if ("sha1WithDSA".equalsIgnoreCase(algorithmName)) {
                    algId = new AlgorithmId(AlgorithmId.sha1WithDSA_oid);
                }
            }
            KeyIdentifier ki = (KeyIdentifier)attrSet.getValue("cert.oper.SenderKeyIdentifier", null);
            BigInteger pvNo = (BigInteger)attrSet.getValue("cert.oper.CMP_VERSION");
            PKIHeader pkiHeader = null;
            if (pKey != null || revoPassphrase == null) {
                pkiHeader = new PKIHeader(pvNo, tmpHdr.getSender(), tmpHdr.getRecipient(), new Date(), algId, ki, null, new Long(new Date().getTime()).toString().getBytes(), tmpHdr.getSenderNonce(), null, null, null);
                if (debug != null) {
                    debug.text(0L, className, "writeRevoReq", "private-key-case");
                }
            } else {
                AlgorithmId pbmalgid = this.generateProtectionAlg(PkEeFactory.getProvider());
                pkiHeader = new PKIHeader(pvNo, tmpHdr.getSender(), tmpHdr.getRecipient(), new Date(), pbmalgid, ki, null, new Long(new Date().getTime()).toString().getBytes(), tmpHdr.getSenderNonce(), null, null, itva);
            }
            RevDetails[] revDetails = new RevDetails[]{new RevDetails(certTemplate, reasons2, date, crlExt)};
            RevReqContent revContent = new RevReqContent(revDetails);
            X509CertImpl certToBeRevoked = (X509CertImpl)attrSet.getValue("CERT_X509", null);
            Certificate[] certArray = new Certificate[]{certToBeRevoked};
            if (certToBeRevoked == null) {
                certArray = null;
            }
            PKIMessage pkiMessage = null;
            DerOutputStream dos = new DerOutputStream();
            pkiHeader.encode((OutputStream)dos);
            PKIBody pbody = new PKIBody(PkCmpEventFormatter.getBodyType(req), (Object)revContent);
            pbody.encode((OutputStream)dos);
            DerOutputStream derOut = new DerOutputStream();
            derOut.write((byte)48, dos);
            if (pKey != null || revoPassphrase == null) {
                byte[] ba = derOut.toByteArray();
                byte[] ba1 = null;
                String providerName = null;
                try {
                    if (pKey != null) {
                        providerName = (String)attrSet.getValue("cert.oper.PROVIDER", PkEeFactory.getProvider());
                        Signature sig = Signature.getInstance(algorithmName, providerName);
                        sig.initSign(pKey);
                        sig.update(ba);
                        ba1 = sig.sign();
                    }
                }
                catch (GeneralSecurityException e) {
                    PkException myE = new PkException(e);
                    if (debug == null) throw myE;
                    debug.text(0L, className, "writeRevoReq", myE.getMessage());
                    throw myE;
                }
                pkiMessage = new PKIMessage(pkiHeader, PkCmpEventFormatter.getBodyType(req), (Object)revContent, ba1, certArray);
                pkiMessage.encode(out);
                return;
            }
            pkiMessage = new PKIMessage(pkiHeader, PkCmpEventFormatter.getBodyType(req), (Object)revContent, null, certArray);
            try {
                PKIMessage pkiMessage1 = pkiMessage.protect(revoPassphrase.getBytes());
                pkiMessage1.encode(out);
                return;
            }
            catch (Exception e) {
                PkException myE = new PkException(e);
                if (debug == null) throw myE;
                debug.text(0L, className, "writeRevoReq", myE.getMessage());
                throw myE;
            }
        }
        if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
            Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
            Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
            certTemplate.setValidity(new OptionalValidity(notBefore, notAfter));
        }
        PkCmpEventFormatter.addToTempl(certTemplate, attrSet);
        BigInteger otmp = (BigInteger)attrSet.getValue("x509.info.serialNumber", null);
        Date date = !isFromBrowser ? (Date)attrSet.getValue("revo.badSinceDate") : new Date(2L);
        Integer Intreason = (Integer)attrSet.getValue("revo.reasonFlags", null);
        if (Intreason == null) {
            reasons = null;
        } else {
            int reason = Intreason;
            boolean[] ba = new boolean[8];
            for (int i = 0; i < ba.length; ++i) {
                ba[i] = false;
            }
            if (reason != 8) {
                ba[reason] = true;
            } else {
                removeFromCRL = true;
                ba[0] = true;
            }
            reasons = new ReasonFlags(ba);
        }
        CRLExtensions crlExt = (CRLExtensions)attrSet.getValue("revo.extensions", null);
        if (removeFromCRL) {
            CRLReasonCodeExtension r = new CRLReasonCodeExtension(false, 8);
            if (crlExt == null) {
                crlExt = new CRLExtensions();
            }
            crlExt.set("CRLReasonCode", (Object)r);
        }
        RevDetails[] revDetails = new RevDetails[]{new RevDetails(certTemplate, reasons, date, crlExt)};
        RevReqContent revContent = new RevReqContent(revDetails);
        GeneralName sender = new GeneralName((GeneralNameInterface)new X500Name(""));
        GeneralName recipient = new GeneralName((GeneralNameInterface)new X500Name(""));
        PKIHeader pkiHeader = new PKIHeader(BIG_ONE, sender, recipient, null, null, null, null, null, null, null, null, null);
        PKIMessage pkiMessage = new PKIMessage(pkiHeader, 11, (Object)revContent, null, null);
        if (debug != null) {
            debug.text(0L, className, "writeRevoReq", "bodyType {0}", (Object)new Integer(pkiMessage.getBodyType()));
        }
        pkiMessage.encode(out);
    }

    @Override
    public void writeConfReq(PkConfReqEvent req, OutputStream out) throws IOException {
        PKIMessage msg = (PKIMessage)req.getMsg();
        msg.encode(out);
    }

    @Override
    public void writeConfRep(PkConfRepEvent rep, OutputStream out) throws IOException {
        if (debug != null) {
            debug.text(0L, className, "writeConfRep", "############ from writeConfRep....");
        }
        PKIMessage msg1 = (PKIMessage)rep.getReq().getMsg();
        PKIHeader hdr = msg1.getHeader();
        BigInteger cmpVersion = hdr.getPvno();
        PKIMessage msg = (PKIMessage)rep.getMsg();
        if (cmpVersion.equals(BIG_ONE)) {
            if (msg == null) {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "message is null");
                }
            } else {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "############ from writeConfRep..msg is {0}", (Object)msg);
                }
                msg.encode(out);
            }
        } else if (cmpVersion.equals(BIG_TWO)) {
            if (msg == null) {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "message is null. v2");
                }
                PKIMessage pkiMessage = new PKIMessage(hdr, 19, null, null, null);
                PKIMessage pkiMessage1 = null;
                try {
                    pkiMessage1 = pkiMessage.protect("password1234".getBytes());
                }
                catch (Exception e) {
                    pkiMessage1 = pkiMessage;
                }
                pkiMessage1.encode(out);
            } else {
                if (debug != null) {
                    debug.text(0L, className, "writeConfRep", "############ from writeConfRep..msg is {0}", (Object)msg);
                }
                msg.encode(out);
            }
        }
    }

    @Override
    public void writeRevoRep(PkRevoRepEvent rep, OutputStream out) throws IOException {
        PKIMessage msg = (PKIMessage)rep.getReq().getMsg();
        PKIHeader hdr = msg.getHeader();
        BigInteger cmpVersion = hdr.getPvno();
        PKIStatusInfo status = new PKIStatusInfo(0, null, null);
        RevRepContent revRep = new RevRepContent(new PKIStatusInfo[]{status}, null, null);
        if (cmpVersion.equals(BIG_ONE)) {
            AlgorithmId pbmalgid = this.generateProtectionAlg(PkEeFactory.getProvider());
            PKIHeader pkiHeader = new PKIHeader(hdr.getPvno(), hdr.getRecipient(), hdr.getSender(), null, pbmalgid, null, hdr.getSenderKID(), hdr.getTransactionID(), new Date().toString().getBytes(), hdr.getSenderNonce(), null, null);
            PKIMessage pkiMessage = new PKIMessage(pkiHeader, 12, (Object)revRep, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeRevoRep", "writeRevoRep-header {0}", (Object)pkiHeader);
            }
            try {
                PKIMessage pkiMessage2 = pkiMessage.protect("password".getBytes());
                pkiMessage2.encode(out);
            }
            catch (Exception e) {}
        } else if (cmpVersion.equals(BIG_TWO)) {
            AlgorithmId pbmalgid = this.generateProtectionAlg(PkEeFactory.getProvider());
            PKIHeader pkiHeader = new PKIHeader(hdr.getPvno(), hdr.getRecipient(), hdr.getSender(), null, pbmalgid, null, hdr.getSenderKID(), hdr.getTransactionID(), new Date().toString().getBytes(), hdr.getSenderNonce(), null, null);
            PKIMessage pkiMessage = new PKIMessage(pkiHeader, 12, (Object)revRep, null, null);
            if (debug != null) {
                debug.text(0L, className, "writeRevoRep", "writeRevoRep-header {0}", (Object)pkiHeader);
            }
            try {
                PKIMessage pkiMessage2 = pkiMessage.protect("password".getBytes());
                pkiMessage2.encode(out);
            }
            catch (Exception e) {}
        } else if (debug != null) {
            debug.text(0L, className, "writeRevoRep", "CMP version should be 1 or 2");
        }
    }

    private static PkAttrs getAttrsFromCertReqMessages(CertReqMessages certReqMessages) throws IOException {
        CertReqMsg[] certReqMsgs = certReqMessages.getCertReqMsgs();
        CertRequest certRequest = certReqMsgs[0].getCertReq();
        BigInteger bi = certRequest.getCertReqId();
        PkAttrs attrs = PkCmpEventFormatter.getAttrsFromCertTemplate(certRequest.getCertTemplate());
        attrs.add("cert.oper.certReqId", 2, bi);
        return attrs;
    }

    private static PkAttrs getAttrsFromRevReqContent(RevReqContent revReqContent) throws IOException {
        RevDetails[] details = revReqContent.getRevDetails();
        PkAttrs result = PkCmpEventFormatter.getAttrsFromCertTemplate(details[0].getCertDetails());
        Date badSince = details[0].getBadSinceDate();
        String tmp1 = badSince.toString();
        String tmp2 = new Date(2L).toString();
        int j = tmp1.compareTo(tmp2);
        if (tmp1.compareTo(tmp2) == 0) {
            result.add("FROM_BROWSER", 1, "yes");
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromRevReqContent", "from getAttrsFromCertTemplate. year is 69");
            }
            badSince = new Date();
        } else if (debug != null) {
            debug.text(0L, className, "getAttrsFromRevReqContent", "badSince String is {0}", (Object)tmp1);
            debug.text(0L, className, "getAttrsFromRevReqContent", "new Date(2)  String is {0}", (Object)new Date(2L).toString());
        }
        result.add("revo.badSinceDate", 1, badSince);
        CRLExtensions crlExt = details[0].getCrlEntryDetails();
        boolean reasonSetInExtension = false;
        if (crlExt != null) {
            result.add("revo.extensions", 1, crlExt);
            Extension e = crlExt.get("CRLReasonCode");
            if (e instanceof CRLReasonCodeExtension) {
                result.add("revo.reasonFlags", 1, (Integer)((CRLReasonCodeExtension)e).get("reason"));
                reasonSetInExtension = true;
            }
        }
        if (!reasonSetInExtension) {
            ReasonFlags reasons = details[0].getReason();
            int intreason = 0;
            if (reasons != null && reasons.getReasonFlags() != null) {
                boolean[] ba = reasons.getReasonFlags().toBooleanArray();
                intreason = 0;
                for (int i = 0; i < ba.length; ++i) {
                    if (!ba[i]) continue;
                    intreason = i;
                    break;
                }
            }
            result.add("revo.reasonFlags", 1, new Integer(intreason));
        }
        return result;
    }

    private static PkAttrs getAttrsFromRevReqContent(RevReqContentv2 revReqContent) throws IOException {
        RevDetailsv2[] details = revReqContent.getRevDetails();
        PkAttrs result = PkCmpEventFormatter.getAttrsFromCertTemplate(details[0].getCertDetails());
        Date badSince = new Date();
        String tmp1 = badSince.toString();
        String tmp2 = new Date(2L).toString();
        int j = tmp1.compareTo(tmp2);
        if (tmp1.compareTo(tmp2) == 0) {
            result.add("FROM_BROWSER", 1, "yes");
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromRevReqContent", "from getAttrsFromCertTemplate. year is 69");
            }
            badSince = new Date();
        } else if (debug != null) {
            debug.text(0L, className, "getAttrsFromRevReqContent", "badSince String is {0}", (Object)tmp1);
            debug.text(0L, className, "getAttrsFromRevReqContent", "new Date(2)  String is {0}", (Object)new Date(2L).toString());
        }
        result.add("revo.badSinceDate", 1, badSince);
        CRLExtensions crlExt = details[0].getCrlEntryDetails();
        boolean reasonSetInExtension = false;
        if (crlExt != null) {
            result.add("revo.extensions", 1, crlExt);
            Extension e = crlExt.get("CRLReasonCode");
            if (e instanceof CRLReasonCodeExtension) {
                result.add("revo.reasonFlags", 1, (Integer)((CRLReasonCodeExtension)e).get("reason"));
                reasonSetInExtension = true;
            }
        }
        return result;
    }

    private static PkAttrs getAttrsFromCertTemplate(CertTemplate c) throws IOException {
        PkAttrs result;
        block20: {
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromCertTemplate", "########## from getAttrsFromCertTemplate.");
            }
            result = new PkAttrs();
            BigInteger bi = c.getVersion();
            if (bi != null) {
                PkCmpEventFormatter.add(result, "x509.info.version", new Integer(bi.intValue()));
            }
            PkCmpEventFormatter.add(result, "x509.info.serialNumber", c.getSerialNumber());
            PkCmpEventFormatter.add(result, "x509.info.algorithmID", c.getSigningAlg());
            PkCmpEventFormatter.add(result, "x509.info.issuer", c.getIssuer());
            OptionalValidity v = c.getValidity();
            if (v != null) {
                PkCmpEventFormatter.add(result, "x509.info.validity.notBefore", v.getNotBefore());
                PkCmpEventFormatter.add(result, "x509.info.validity.notAfter", v.getNotAfter());
            }
            PkCmpEventFormatter.add(result, "x509.info.subject", c.getSubject());
            try {
                PkCmpEventFormatter.add(result, "x509.info.key", c.getPublicKey());
            }
            catch (InvalidKeyException e) {
                if (debug == null) break block20;
                debug.exception(1L, className, "getAttrsFromCertTemplate", (Throwable)e);
            }
        }
        byte[] uid = c.getIssuerUID();
        if (uid != null) {
            PkCmpEventFormatter.add(result, "x509.info.issuerID", new UniqueIdentity(uid));
        }
        if ((uid = c.getSubjectUID()) != null) {
            PkCmpEventFormatter.add(result, "x509.info.subjectID", new UniqueIdentity(uid));
        }
        CertificateExtensions ext = null;
        try {
            ext = c.getExtensions();
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromCertTemplate", "######. ext is {0}", (Object)ext);
            }
        }
        catch (Exception e) {
            throw new IOException(PkNLSConstants.CMPEVENT_PROBLEM_GETTING_EXT);
        }
        if (ext == null) {
            return result;
        }
        for (Object o : ext.entrySet()) {
            Map.Entry e;
            if (o instanceof CertificateExtensions) {
                if (debug != null) {
                    debug.text(1L, className, "getAttrsFromCertTemplate", "##### ce ");
                }
                e = (Map.Entry)o;
                if (debug != null) {
                    debug.text(1L, className, "getAttrsFromCertTemplate", "###################### EXT {0}", e.getKey());
                }
                PkCmpEventFormatter.add(result, "x509.info.extensions." + e.getKey(), e.getValue());
                continue;
            }
            if (!(o instanceof Extension)) continue;
            e = (Extension)o;
            if (debug != null) {
                debug.text(0L, className, "getAttrsFromCertTemplate", "##### e.getExtensionId {0}", (Object)e.getExtensionId());
            }
            String extName = null;
            Class extClass = null;
            try {
                extName = OIDMap.getName((ObjectIdentifier)e.getExtensionId());
                extClass = OIDMap.getClass((ObjectIdentifier)e.getExtensionId());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (extName == null) {
                if (!e.getExtensionId().equals(TPKI_ENROLL_OID)) continue;
                result.add("cert.oper.raEnrollment", 2, new Boolean(true));
                if (debug == null) continue;
                debug.text(1L, className, "getAttrsFromCertTemplate", "########## TPKI_RA_ENROLL");
                continue;
            }
            if (debug != null) {
                debug.text(1L, className, "getAttrsFromCertTemplate", "###################### name {0}", (Object)extName);
                debug.text(1L, className, "getAttrsFromCertTemplate", "###################### class {0}", (Object)extClass);
            }
            PkCmpEventFormatter.add(result, extName, e);
        }
        return result;
    }

    private static void add(PkAttrs attrs, String name, Object value) {
        attrs.add(name, 1, value);
    }

    private X509CertImpl getCert(CertRepMessage certRepMessage, PrivateKey privateKey) throws PkException, IOException {
        byte[] encodedCert;
        block18: {
            boolean privateKeyAvailable = privateKey != null;
            CertResponse[] responses = certRepMessage.getResponse();
            PKIStatusInfo pkiStatus = responses[0].getStatusInfo();
            switch (pkiStatus.getStatus()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new PkException(pkiStatus.toString());
                }
            }
            CertOrEncCert c = responses[0].getCertifiedKeyPair().getCertOrEncCert();
            encodedCert = null;
            if (c.isCertificate()) {
                try {
                    encodedCert = c.getCertificate().getEncoded();
                }
                catch (CertificateEncodingException e) {
                    if (debug != null) {
                        debug.exception(4L, className, "getCert", (Throwable)e);
                    }
                    break block18;
                }
            }
            try {
                if (privateKey != null) {
                    EncryptedValue eV = c.getCertOrEncCert();
                    AlgorithmId symmAlg = eV.getSymmAlg();
                    byte[] encSymmKey = eV.getEncSymmKey();
                    AlgorithmId keyAlg = eV.getKeyAlg();
                    byte[] encValue = eV.getEncValue();
                    if (debug != null) {
                        debug.text(1L, className, "getCert", "encValue = {0}", (Object)new Integer(encValue.length));
                    }
                    Cipher cipher = Cipher.getInstance("RSA", PkEeFactory.getProvider());
                    cipher.init(2, privateKey);
                    byte[] decSymmKey = cipher.doFinal(encSymmKey);
                    for (int i = 0; i < decSymmKey.length; ++i) {
                        if (debug == null) continue;
                        debug.text(1L, className, "getCert", "decSymmKey: {0}", (Object)new Byte(decSymmKey[i]));
                    }
                    Cipher cipher1 = Cipher.getInstance("DESEDE/CBC/PKCS5Padding", PkEeFactory.getProvider());
                    if (symmAlg.getAlgParameters() == null && debug != null) {
                        debug.text(0L, className, "getCert", "symmAlg = {0}", (Object)symmAlg);
                    }
                    IvParameterSpec algore = symmAlg.getAlgParameters().getParameterSpec(IvParameterSpec.class);
                    SecretKeySpec skp = new SecretKeySpec(decSymmKey, "DESede");
                    cipher1.init(2, (Key)skp, algore);
                    if (debug != null) {
                        debug.text(1L, className, "getCert", "cipher1.size  {0}", (Object)new Integer(cipher1.getOutputSize(encValue.length)));
                    }
                    encodedCert = cipher1.doFinal(encValue);
                }
            }
            catch (GeneralSecurityException e) {
                throw new PkException(e);
            }
        }
        if (encodedCert != null) {
            try {
                CertificateFactory cF = CertificateFactory.getInstance("X509", PkEeFactory.getProvider());
                ByteArrayInputStream is = new ByteArrayInputStream(encodedCert);
                return (X509CertImpl)cF.generateCertificate(is);
            }
            catch (NoSuchProviderException e) {
                throw new PkException(e);
            }
            catch (CertificateException e) {
                throw new PkException(e);
            }
        }
        return null;
    }

    private static void addToTempl(CertTemplate c, PkAttrs attrSet) throws IOException {
        String caVendor = (String)attrSet.getValue("cert.oper.CA_VENDOR", null);
        boolean doNotSetAlgId = false;
        if (caVendor != null) {
            doNotSetAlgId = caVendor.equalsIgnoreCase("Entrust");
        }
        PkAttrs.Iter iter = attrSet.iterator();
        while (iter.hasNext()) {
            PkAttr attr = iter.nextAttr();
            String name = attr.getName();
            if (!attr.isApplied() || !attr.isApproved()) continue;
            Object v = attr.getValue();
            if (name.startsWith("x509.info.extensions.")) {
                PkCmpEventFormatter.addExtension(c, attr);
                continue;
            }
            if (name.equals("x509.info.version")) {
                c.setVersion(BigInteger.valueOf(((Integer)v).intValue()));
                continue;
            }
            if (name.equals("x509.info.serialNumber")) {
                c.setSerialNumber((BigInteger)v);
                continue;
            }
            if (name.equals("x509.info.algorithmID")) {
                if (debug != null) {
                    debug.text(0L, className, "addToTempl", "#################>>>>>>>>>>>>>>>>>> from addToTempl, algId {0}", (Object)((AlgorithmId)v));
                }
                if (doNotSetAlgId) continue;
                c.setSigningAlg((AlgorithmId)v);
                continue;
            }
            if (name.equals("x509.info.issuer")) {
                c.setIssuer((X500Name)v);
                continue;
            }
            if (name.equals("x509.info.subject")) {
                c.setSubject((X500Name)v);
                continue;
            }
            if (name.equals("x509.info.key")) {
                c.setPublicKey((PublicKey)v);
                continue;
            }
            if (name.equals("x509.info.certrevopublickey")) {
                c.setPublicKey((PublicKey)v);
                continue;
            }
            if (name.equals("x509.info.issuerID")) {
                c.setIssuerUID(new BitArray(((UniqueIdentity)v).getId()).toByteArray());
                continue;
            }
            if (name.equals("x509.info.subjectID")) {
                c.setSubjectUID(new BitArray(((UniqueIdentity)v).getId()).toByteArray());
                continue;
            }
            if (name.equals("x509.info.validity.notBefore")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)name);
                continue;
            }
            if (name.equals("x509.info.validity.notAfter")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)name);
                continue;
            }
            if (name.equals("revo.reasonFlags")) {
                if (debug == null) continue;
                debug.text(1L, className, "addToTempl", "Unused attribute={0}", (Object)name);
                continue;
            }
            if (name.equals("revo.badSinceDate")) continue;
            throw new PkIoException(PkNLSConstants.CMPEVENT_BAD_ATTR + name);
        }
        if (attrSet.has("x509.info.validity.notBefore") || attrSet.has("x509.info.validity.notAfter")) {
            Date notBefore = (Date)attrSet.getValue("x509.info.validity.notBefore", null);
            Date notAfter = (Date)attrSet.getValue("x509.info.validity.notAfter", null);
            c.setValidity(new OptionalValidity(notBefore, notAfter));
        }
    }

    private static void addExtension(CertTemplate c, PkAttr attr) throws IOException {
        try {
            c.addExtension(new Extension[]{(Extension)attr.getValue()});
        }
        catch (IOException e) {
            throw new PkIoException(PkNLSConstants.CMPEVENT_MODIFY_ATTR_FAIL + attr.getName() + ":" + attr.getValue(), e);
        }
    }

    private static int getBodyType(PkEvent ev) {
        return types.get(ev.getClass());
    }

    private boolean verifyPop(CertReqMessages certReqMessages) throws IOException, PkException {
        boolean verified = false;
        CertReqMsg[] certReqMsgs = certReqMessages.getCertReqMsgs();
        CertRequest certRequest = certReqMsgs[0].getCertReq();
        DerOutputStream dos1 = new DerOutputStream();
        certRequest.encode((OutputStream)dos1);
        byte[] ba = dos1.toByteArray();
        POPOSigningKey pops = (POPOSigningKey)certReqMsgs[0].getPOP().getPOP();
        byte[] signature = pops.getSignature();
        try {
            Signature sig = Signature.getInstance("SHA1withDSA", PkEeFactory.getProvider());
            PublicKey pubKey = certRequest.getCertTemplate().getPublicKey();
            sig.initVerify(pubKey);
            sig.update(ba);
            verified = sig.verify(signature);
        }
        catch (Exception e) {
            if (e instanceof PkException) {
                throw (PkException)e;
            }
            throw new PkException(e);
        }
        if (debug != null) {
            debug.text(1L, className, "verifyPop", "from verifyPOP. verified = {0}", (Object)new Boolean(verified));
        }
        return verified;
    }

    private AlgorithmId generateProtectionAlg(String provider) {
        byte[] salt = "this is a salt".getBytes();
        AlgorithmId owf = new AlgorithmId(AlgorithmId.SHA_oid);
        int iterationCount = 1001;
        AlgorithmId mac = new AlgorithmId(AlgorithmId.HmacSHA1_oid);
        PBMParameterSpec pbmspec = new PBMParameterSpec(salt, owf, iterationCount, mac);
        AlgorithmParameters pbmparam = null;
        try {
            pbmparam = AlgorithmParameters.getInstance("PasswordBasedMac", provider);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", e.getMessage());
            }
            System.out.println("ERROR : " + e.toString());
            System.exit(1);
        }
        catch (NoSuchProviderException ee) {
            ee.printStackTrace();
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", ee.getMessage());
            }
            System.out.println("ERROR : " + ee.toString());
            System.exit(1);
        }
        try {
            pbmparam.init((AlgorithmParameterSpec)pbmspec);
        }
        catch (InvalidParameterSpecException e) {
            System.out.println("ERROR : " + e.toString());
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", e.getMessage());
            }
            System.exit(1);
        }
        AlgorithmId pbmalgid = null;
        try {
            pbmalgid = new AlgorithmId(AlgorithmId.PasswordBasedMac_oid, pbmparam.getEncoded());
        }
        catch (IOException e) {
            System.out.println("ERROR : " + e.toString());
            if (debug != null) {
                debug.text(1L, className, "generateProtectionAlg", e.getMessage());
            }
            System.exit(1);
        }
        return pbmalgid;
    }

    static {
        types.put(PkCertReqEvent.class, new Integer(0));
        types.put(PkCertRepEvent.class, new Integer(1));
        types.put(PkInitReqEvent.class, new Integer(0));
        types.put(PkInitRepEvent.class, new Integer(1));
        types.put(PkSecnReqEvent.class, new Integer(2));
        types.put(PkSecnRepEvent.class, new Integer(3));
        types.put(PkKupdReqEvent.class, new Integer(7));
        types.put(PkKupdRepEvent.class, new Integer(8));
        types.put(PkKrecReqEvent.class, new Integer(9));
        types.put(PkKrecRepEvent.class, new Integer(10));
        types.put(PkRevoReqEvent.class, new Integer(11));
        types.put(PkRevoRepEvent.class, new Integer(12));
        types.put(PkXcerReqEvent.class, new Integer(13));
        types.put(PkXcerRepEvent.class, new Integer(14));
        types.put(PkGnrlReqEvent.class, new Integer(21));
        types.put(PkGnrlRepEvent.class, new Integer(22));
    }
}

