/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_TLS_PRF_PARAMS;
import com.ibm.pkcs11.PKCS11Object;
import ibm.security.internal.spec.TlsPrfParameterSpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class PKCS11TlsPrfGenerator
extends KeyGeneratorSpi {
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsPrfGenerator";
    private SessionManager sessionManager = null;
    private Config config = null;
    private KeyMechanismBuilder mechanismBuilder;
    private TlsPrfParameterSpec spec;
    private GeneralKey generalKey;
    private Provider provider;
    private static final SecretKey NULL_KEY = new SecretKey(){

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public String getAlgorithm() {
            return "Generic";
        }
    };

    PKCS11TlsPrfGenerator(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be specified and be an instance of TlsPrfParameterSpec");
        }
        this.spec = (TlsPrfParameterSpec)params;
        SecretKey secretKey = this.spec.getSecret();
        if (secretKey == null) {
            secretKey = NULL_KEY;
        }
        GeneralPKCS11KeyFactory factory = new GeneralPKCS11KeyFactory(this.provider, secretKey.getAlgorithm());
        SecretKey key = null;
        try {
            key = factory.engineTranslateKey(secretKey);
        }
        catch (InvalidKeyException ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)ex);
            }
            throw new InvalidAlgorithmParameterException(ex);
        }
        if (!(key instanceof GeneralKey)) {
            throw new InvalidAlgorithmParameterException("cannot covert to appropriate key from AlgorithmParameterSpec");
        }
        this.generalKey = (GeneralKey)key;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException("params must be specified and be an instance of TlsPrfParameterSpec");
    }

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException("params must be specified and be an instance of TlsPrfParameterSpec");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        byte[] label = null;
        try {
            label = this.spec.getLabel().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int length = this.spec.getOutputLength();
        CK_TLS_PRF_PARAMS params = new CK_TLS_PRF_PARAMS(this.spec.getSeed(), label, length);
        int[] secretKeyTypes = new int[]{};
        Object[] secretKeyValues = new Object[]{};
        PKCS11Object generatedSecret = null;
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            generatedSecret = session.deriveKey(888, params, this.generalKey.getObject(), secretKeyTypes, secretKeyValues);
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey", (Throwable)ex);
            }
            throw new RuntimeException(ex);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return new SecretKeySpec(params.getOutput(), "TlsPrf");
    }
}

