/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.profiling;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DictionaryDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsDataCorruptedException;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.JavaMethod;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.profiling.Messages;
import com.ibm.java.diagnostics.healthcenter.profiling.MethodDictionaryDataImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.MethodTree;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingData;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingDataImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.profiling.ThreadState;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfilingTracePointHandler
implements TracePointHandler {
    private static final Logger TRACE = LogFactory.getTrace(ProfilingTracePointHandler.class);
    private static final String CLASSNAME = ProfilingTracePointHandler.class.getName();
    private AxisPair numberAxisPair = null;
    public static final String STACK_TRACE_TRACEPOINT = "j9jit.16";
    static final String CHECK_PARAMETERS = Messages.getString("ProfilingTracePointHandler.check.parameters");
    private static final DataFactory factory = DataFactory.getFactory();
    public static final int MAX_LABEL_LENGTH = 50;
    private Map<TracedThread, ThreadState> threadMap = new HashMap<TracedThread, ThreadState>();
    private DictionaryDataBuilder<Long, JavaMethod> methodDictionary;
    int methodCount = 0;
    long timeinterval = 2000L;
    double startTime = 0.0;

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASSNAME, "handleTraceStart");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ProfilingLabels.DATA_LABEL);
        if (!(dataBuilder2 instanceof ProfilingData) && dataBuilder2 != null) {
            dataBuilder.removeData(ProfilingLabels.DATA_LABEL);
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
            }
        }
        if (this.numberAxisPair == null) {
            XDataAxis xDataAxis = AxisUtil.prepareXAxis(outputProperties);
            YDataAxis yDataAxis = AxisUtil.prepareNumberAxis(outputProperties);
            this.numberAxisPair = factory.createAxisPair(xDataAxis, yDataAxis);
        }
        this.threadMap.clear();
        this.createMethodDictionary(dataBuilder);
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        ThreadState threadState;
        TracedThread tracedThread = tracePoint.getThread();
        if (!this.threadMap.containsKey(tracedThread)) {
            threadState = new ThreadState();
            this.threadMap.put(tracedThread, threadState);
        } else {
            threadState = this.threadMap.get(tracedThread);
        }
        try {
            this.processTracePoint(tracePoint, threadState, dataBuilder, outputProperties, traceMetaData);
        }
        catch (JavaDiagnosticsDataCorruptedException javaDiagnosticsDataCorruptedException) {
            TRACE.log(Level.WARNING, Messages.getString("ProfilingTracePointHandler.error.processing.trace"), javaDiagnosticsDataCorruptedException);
        }
    }

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
        ThreadState threadState;
        if (tracedThread == null) {
            this.threadMap.clear();
        } else if (this.threadMap.containsKey(tracedThread) && (threadState = this.threadMap.remove(tracedThread)) != null) {
            threadState.clearStack();
        }
    }

    private void createMethodDictionary(DataBuilder dataBuilder) {
        DataBuilder dataBuilder2 = dataBuilder.getData(ProfilingLabels.METHOD_DICTIONARY);
        if (!(dataBuilder2 instanceof DictionaryDataBuilder)) {
            this.methodDictionary = new MethodDictionaryDataImpl(ProfilingLabels.METHOD_DICTIONARY);
            dataBuilder.addData(this.methodDictionary);
        } else {
            this.methodDictionary = (DictionaryDataBuilder)dataBuilder2;
        }
    }

    private SubsystemDataBuilder getProfilingData(DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(ProfilingLabels.DATA_LABEL);
        if (dataBuilder2 instanceof ProfilingDataImpl) {
            subsystemDataBuilder = (ProfilingDataImpl)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createProfilingData(outputProperties, traceMetaData);
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createProfilingData(OutputProperties outputProperties, TraceMetaData traceMetaData) {
        TRACE.entering(CLASSNAME, "createProfilingData");
        StringDataBuilder stringDataBuilder = null;
        if (traceMetaData != null) {
            stringDataBuilder = factory.createStringData(UnitLabels.VERSION);
            stringDataBuilder.addValue(traceMetaData.getVMVersion());
        } else {
            TRACE.logp(Level.WARNING, CLASSNAME, "createProfilingData", Messages.getString("ProfilingTracePointHandler.no.trace"));
        }
        ProfilingDataImpl profilingDataImpl = new ProfilingDataImpl();
        MethodTree methodTree = new MethodTree(outputProperties, traceMetaData);
        profilingDataImpl.addData(stringDataBuilder);
        profilingDataImpl.addData(methodTree);
        TRACE.exiting(CLASSNAME, "createProfilingData");
        return profilingDataImpl;
    }

    private void processTracePoint(TracePoint tracePoint, ThreadState threadState, DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) throws JavaDiagnosticsDataCorruptedException {
        String string = tracePoint.getComponent();
        if ("omrti".equals(string)) {
            this.handleOMRTracePoint(tracePoint, threadState, dataBuilder, outputProperties, traceMetaData);
        } else if ("j9jit".equals(string)) {
            this.handleJITTracePoint(tracePoint, threadState, dataBuilder, outputProperties, traceMetaData);
        } else {
            if ("j9vm".equals(string)) {
                this.handleVMTracePoint(tracePoint);
            }
            this.terminateStackTrace(tracePoint, dataBuilder, outputProperties, traceMetaData);
        }
    }

    private void handleVMTracePoint(TracePoint tracePoint) throws JavaDiagnosticsDataCorruptedException {
        Object[] objectArray = null;
        switch (tracePoint.getID()) {
            case 333: {
                objectArray = tracePoint.getParameters();
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 3);
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                Long l = (Long)objectArray[3];
                if (this.methodDictionary.get(l) == null) {
                    JavaMethod javaMethod = new JavaMethod(string, string2, string3, l);
                    this.methodDictionary.put(l, javaMethod);
                    break;
                }
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null || javaMethod.getClassName() != null) break;
                javaMethod.setName(string, string2, string3);
            }
        }
    }

    private void handleOMRTracePoint(TracePoint tracePoint, ThreadState threadState, DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) throws JavaDiagnosticsDataCorruptedException {
        Object[] objectArray = null;
        switch (tracePoint.getID()) {
            case 8: {
                objectArray = tracePoint.getParameters();
                this.checkMethodProfileCount(tracePoint, dataBuilder, traceMetaData);
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 1);
                this.terminateStackTrace(tracePoint, dataBuilder, outputProperties, traceMetaData);
                ThreadState threadState2 = new ThreadState();
                TracedThread tracedThread = tracePoint.getThread();
                this.threadMap.put(tracedThread, threadState2);
                Long l = (Long)objectArray[0];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState2.setPreviousMethod(javaMethod);
                break;
            }
            case 9: {
                objectArray = tracePoint.getParameters();
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 1);
                Long l = (Long)objectArray[0];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState.setPreviousMethod(javaMethod);
            }
        }
    }

    private void handleJITTracePoint(TracePoint tracePoint, ThreadState threadState, DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) throws JavaDiagnosticsDataCorruptedException {
        Object[] objectArray = null;
        switch (tracePoint.getID()) {
            case 3: {
                break;
            }
            case 15: 
            case 39: {
                objectArray = tracePoint.getParameters();
                this.checkMethodProfileCount(tracePoint, dataBuilder, traceMetaData);
                if (objectArray == null) {
                    return;
                }
                if (tracePoint.getID() == 15) {
                    this.checkParameters(tracePoint, objectArray, 3);
                } else {
                    this.checkParameters(tracePoint, objectArray, 1);
                }
                this.terminateStackTrace(tracePoint, dataBuilder, outputProperties, traceMetaData);
                ThreadState threadState2 = new ThreadState();
                TracedThread tracedThread = tracePoint.getThread();
                this.threadMap.put(tracedThread, threadState2);
                Long l = (Long)objectArray[0];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState2.setPreviousMethod(javaMethod);
                break;
            }
            case 16: {
                objectArray = tracePoint.getParameters();
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 3);
                Long l = (Long)objectArray[0];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState.setPreviousMethod(javaMethod);
                break;
            }
            case 40: {
                objectArray = tracePoint.getParameters();
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 2);
                Long l = (Long)objectArray[0];
                Long l2 = (Long)objectArray[1];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState.setPreviousMethod(javaMethod);
                javaMethod = (JavaMethod)this.methodDictionary.get(l2);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l2);
                    this.methodDictionary.put(l2, javaMethod);
                }
                threadState.setPreviousMethod(javaMethod);
                break;
            }
            case 41: {
                objectArray = tracePoint.getParameters();
                if (objectArray == null) {
                    return;
                }
                this.checkParameters(tracePoint, objectArray, 1);
                Long l = (Long)objectArray[0];
                JavaMethod javaMethod = (JavaMethod)this.methodDictionary.get(l);
                if (javaMethod == null) {
                    javaMethod = new JavaMethod(l);
                    this.methodDictionary.put(l, javaMethod);
                }
                threadState.setPreviousMethod(javaMethod);
            }
        }
    }

    private void checkMethodProfileCount(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        if (this.startTime == 0.0) {
            this.startTime = d;
        }
        ++this.methodCount;
        if (d - this.startTime > (double)this.timeinterval) {
            this.addMethodProfileCount(dataBuilder, tracePoint, this.methodCount, traceMetaData);
            this.methodCount = 0;
            this.startTime = d;
        }
    }

    private void addMethodProfileCount(DataBuilder dataBuilder, TracePoint tracePoint, long l, TraceMetaData traceMetaData) {
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        String string = ProfilingLabels.METHOD_SNAPSHOT;
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.PROFILING);
        if (subsystemDataBuilder != null) {
            Data data = subsystemDataBuilder.getData(string);
            if (data == null) {
                data = new TwoDimensionalDataImpl(string, this.numberAxisPair);
                subsystemDataBuilder.addData((DataBuilder)data);
            }
            DataPointImpl dataPointImpl = new DataPointImpl(0, d, l, this.numberAxisPair);
            ((TwoDimensionalDataBuilder)data).addDataPointBuilder(dataPointImpl);
        }
    }

    private void terminateStackTrace(TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties, TraceMetaData traceMetaData) {
        TracedThread tracedThread = tracePoint.getThread();
        ThreadState threadState = this.threadMap.remove(tracedThread);
        if (threadState == null) {
            return;
        }
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        List<Method> list = threadState.getStack();
        if (list.size() > 0) {
            SubsystemDataBuilder subsystemDataBuilder = this.getProfilingData(dataBuilder, outputProperties, traceMetaData);
            MethodTree methodTree = (MethodTree)subsystemDataBuilder.getData(ProfilingLabels.PROFILE_DATA);
            methodTree.addCallStack(list, d);
        }
        threadState.clearStack();
    }

    private void checkParameters(TracePoint tracePoint, Object[] objectArray, int n) throws JavaDiagnosticsDataCorruptedException {
        if (objectArray.length < n) {
            throw new JavaDiagnosticsDataCorruptedException(MessageFormat.format(CHECK_PARAMETERS, tracePoint.getID(), tracePoint.getComponent(), objectArray.length), 0, 0, "");
        }
    }
}

