/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.profiling;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.Method;
import com.ibm.java.diagnostics.healthcenter.jit.JITTracePointHandler;
import com.ibm.java.diagnostics.healthcenter.profiling.MethodTwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingTableRow;
import com.ibm.java.diagnostics.healthcenter.profiling.SampleCounter;

public class ProfilingTableDataRowImpl
implements ProfilingTableRow {
    private static final Double MAX_PERCENT = new Double(100.0);
    private final MethodTwoDimensionalDataImpl method;
    private final MethodTwoDimensionalDataImpl cumulativeMethod;
    private final SampleCounter totalSamples;
    private boolean isEnabled = true;
    private int jitCount = 0;
    private String hotness = null;

    public ProfilingTableDataRowImpl(MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl, MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl2, SampleCounter sampleCounter) {
        this.method = methodTwoDimensionalDataImpl;
        this.cumulativeMethod = methodTwoDimensionalDataImpl2;
        this.totalSamples = sampleCounter;
    }

    @Override
    public double getCumulativePercentage() {
        double d;
        if (this.cumulativeMethod == null) {
            return 0.0;
        }
        if (this.totalSamples.getSampleCount() == 0L) {
            return 0.0;
        }
        double d2 = this.getCumulativeSampleCount();
        if (d2 > (d = (double)this.totalSamples.getSampleCount())) {
            try {
                DataBuilder dataBuilder = this.cumulativeMethod.getParent().getParent().getData(ProfilingLabels.METHOD_COUNTS);
                long l = 0L;
                for (Data data : dataBuilder.getChildren()) {
                    MethodTwoDimensionalDataImpl methodTwoDimensionalDataImpl;
                    int n;
                    if (!(data instanceof MethodTwoDimensionalDataImpl) || (n = (int)(methodTwoDimensionalDataImpl = (MethodTwoDimensionalDataImpl)data).getTotalY()) == 0) continue;
                    l += (long)n;
                }
                d = l;
                this.totalSamples.setSampleCount((long)d);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        double d3 = d2 / d * MAX_PERCENT;
        return d3;
    }

    @Override
    public int getCumulativeSampleCount() {
        if (this.cumulativeMethod == null) {
            return 0;
        }
        return (int)this.cumulativeMethod.getTotalY();
    }

    @Override
    public long getMethodId() {
        return this.getMethodData().getMethod().getUniqueIdAsNumber();
    }

    @Override
    public String getMethodName() {
        return this.getMethodData().getLabel();
    }

    @Override
    public double getPercentage() {
        if (this.totalSamples.getSampleCount() > 0L) {
            return (double)this.getSampleCount() / (double)this.totalSamples.getSampleCount() * MAX_PERCENT;
        }
        return 0.0;
    }

    @Override
    public int getSampleCount() {
        if (this.method == null) {
            return 0;
        }
        return (int)this.method.getTotalY();
    }

    @Override
    public Object[] getRowData() {
        Object[] objectArray = new Object[10];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    public Method getProfiledMethod() {
        return this.getMethodData().getMethod();
    }

    private MethodTwoDimensionalDataImpl getMethodData() {
        if (this.method != null) {
            return this.method;
        }
        if (this.cumulativeMethod != null) {
            return this.cumulativeMethod;
        }
        return null;
    }

    @Override
    public Object get(int n) {
        switch (n) {
            case 0: {
                return this.getMethodData().getID();
            }
            case 1: {
                return this.getMethodName();
            }
            case 2: {
                return this.getSampleCount();
            }
            case 3: {
                return this.getPercentage();
            }
            case 4: {
                return MAX_PERCENT;
            }
            case 5: {
                return this.getCumulativePercentage();
            }
            case 6: {
                return this.getCumulativeSampleCount();
            }
            case 7: {
                return MAX_PERCENT;
            }
            case 8: {
                return this.getJITCount();
            }
            case 9: {
                return this.getHotness();
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ProfilingTableDataRowImpl) {
            ProfilingTableDataRowImpl profilingTableDataRowImpl = (ProfilingTableDataRowImpl)object;
            return this.getMethodData().getID().equals(profilingTableDataRowImpl.getMethodData().getID());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.getMethodData().getID().hashCode();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Override
    public int getJITCount() {
        return this.jitCount;
    }

    public void setJITCount(int n) {
        this.jitCount = n;
    }

    @Override
    public String getHotness() {
        return this.hotness;
    }

    public void setHotness(int n) {
        this.hotness = JITTracePointHandler.convertHotnessToString(n);
    }
}

