/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodtrace.parser;

import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemData;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePointHandler;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracedThread;
import com.ibm.java.diagnostics.healthcenter.methodtrace.Messages;
import com.ibm.java.diagnostics.healthcenter.methodtrace.MethodTraceLabels;
import com.ibm.java.diagnostics.healthcenter.methodtrace.data.MethodTraceEntryDataPoint;
import com.ibm.java.diagnostics.healthcenter.methodtrace.data.MethodTraceExitDataPoint;
import com.ibm.java.diagnostics.healthcenter.methodtrace.parser.MethodTracePointConstants;
import com.ibm.java.diagnostics.healthcenter.sources.DynamicSource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodTracePointHandler
implements TracePointHandler,
MethodTracePointConstants {
    private static final Logger TRACE = LogFactory.getTrace(MethodTracePointHandler.class);
    private AxisPair axisPair;
    private int sequenceUID = 0;
    private static final DataFactory factory = DataFactory.getFactory();
    private static final String CLASSNAME = MethodTracePointHandler.class.getName();
    private final Map<TwoDimensionalDataBuilder, MethodTraceEntryDataPoint> lastEntryPointMap = new HashMap<TwoDimensionalDataBuilder, MethodTraceEntryDataPoint>();

    @Override
    public void handleMissingData(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracedThread tracedThread, double d, int n, DataBuilder dataBuilder, OutputProperties outputProperties) {
    }

    private SubsystemDataBuilder getMethodTraceSubsystemData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(MethodTraceLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemDataBuilder) {
            subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder2;
        } else {
            subsystemDataBuilder = this.createMethodTraceSubsystemData();
            dataBuilder.addData(subsystemDataBuilder);
        }
        return subsystemDataBuilder;
    }

    private SubsystemDataBuilder createMethodTraceSubsystemData() {
        SubsystemDataBuilder subsystemDataBuilder = factory.createSubsystemData(MethodTraceLabels.DATA_LABEL, "com.ibm.java.diagnostics.healthcenter.methodtrace.perspective.MethodTracePerspective");
        return subsystemDataBuilder;
    }

    @Override
    public void handleTracePoint(DynamicSource dynamicSource, TraceMetaData traceMetaData, TracePoint tracePoint, DataBuilder dataBuilder, OutputProperties outputProperties) {
        assert (tracePoint != null);
        String string = tracePoint.getComponent();
        if ("mt".equals(string)) {
            int n = tracePoint.getID();
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.addMethodEntry(tracePoint, this.getMethodTraceSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.addMethodExit(tracePoint, this.getMethodTraceSubsystemData(dataBuilder), traceMetaData);
                    break;
                }
            }
        }
    }

    private String createFullMethodName(Object[] objectArray) {
        assert (objectArray.length >= 3);
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        String string3 = (String)objectArray[2];
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        string3 = string3.substring(0, string3.lastIndexOf(")") + 1);
        stringBuffer.append(string3);
        return stringBuffer.toString().replaceAll("/", ".");
    }

    private void addMethodEntry(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        String string = this.createFullMethodName(objectArray);
        TracedThread tracedThread = tracePoint.getThread();
        StringDataBuilder stringDataBuilder = this.getMethodBranch(dataBuilder, string);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTimeLine(stringDataBuilder, tracedThread);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        MethodTraceEntryDataPoint methodTraceEntryDataPoint = new MethodTraceEntryDataPoint(this.sequenceUID++, d, string, this.axisPair);
        methodTraceEntryDataPoint.setFullMethodName(this.createFullMethodName(objectArray));
        twoDimensionalDataBuilder.addDataPointBuilder(methodTraceEntryDataPoint);
        this.lastEntryPointMap.put(twoDimensionalDataBuilder, methodTraceEntryDataPoint);
    }

    private void addMethodExit(TracePoint tracePoint, DataBuilder dataBuilder, TraceMetaData traceMetaData) {
        Object[] objectArray = tracePoint.getParameters();
        if (objectArray == null) {
            return;
        }
        String string = this.createFullMethodName(objectArray);
        TracedThread tracedThread = tracePoint.getThread();
        StringDataBuilder stringDataBuilder = this.getMethodBranch(dataBuilder, string);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = this.getTimeLine(stringDataBuilder, tracedThread);
        double d = TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData);
        MethodTraceExitDataPoint methodTraceExitDataPoint = new MethodTraceExitDataPoint(this.sequenceUID++, d, string, this.axisPair);
        twoDimensionalDataBuilder.addDataPointBuilder(methodTraceExitDataPoint);
        MethodTraceEntryDataPoint methodTraceEntryDataPoint = this.lastEntryPointMap.get(twoDimensionalDataBuilder);
        if (methodTraceEntryDataPoint != null) {
            methodTraceEntryDataPoint.setActivityEndDataPoint(methodTraceExitDataPoint);
            methodTraceExitDataPoint.setActivityStartDataPoint(methodTraceEntryDataPoint);
            double d2 = methodTraceExitDataPoint.getRawX() - methodTraceEntryDataPoint.getRawX();
            methodTraceExitDataPoint.setDurationTime(d2);
            methodTraceExitDataPoint.setFullMethodName(this.createFullMethodName(objectArray));
        }
    }

    private StringDataBuilder getMethodBranch(DataBuilder dataBuilder, String string) {
        if (dataBuilder.getData(string) == null) {
            StringDataBuilder stringDataBuilder = factory.createStringData(string);
            dataBuilder.addData(stringDataBuilder);
        }
        return (StringDataBuilder)dataBuilder.getData(string);
    }

    private TwoDimensionalDataBuilder getTimeLine(DataBuilder dataBuilder, TracedThread tracedThread) {
        assert (dataBuilder != null);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = null;
        String string = Long.toHexString(tracedThread.getThreadID());
        String string2 = tracedThread.getThreadName();
        twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)dataBuilder.getData(string);
        if (twoDimensionalDataBuilder == null) {
            twoDimensionalDataBuilder = new TwoDimensionalDataImpl(string, string2, this.axisPair);
            dataBuilder.addData(twoDimensionalDataBuilder);
        }
        return twoDimensionalDataBuilder;
    }

    @Override
    public void handleTraceStart(DynamicSource dynamicSource, TraceMetaData traceMetaData, DataBuilder dataBuilder, OutputProperties outputProperties) {
        Object object;
        Object object2;
        TRACE.entering(CLASSNAME, "handleTraceStart");
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(MethodTraceLabels.DATA_LABEL);
        if (dataBuilder2 instanceof SubsystemData && (object2 = (object = (SubsystemData)((Object)dataBuilder2)).getPerspectiveID()) == null) {
            dataBuilder.removeData(MethodTraceLabels.DATA_LABEL);
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.fine("Internal error: Postprocessed data was not cleared properly - deleting existing data.");
            }
        }
        if (this.axisPair != null) {
            TRACE.logp(Level.WARNING, CLASSNAME, "handleTraceStart", Messages.getString("MethodTraceTracePointHandler.axis.pair.already.exists"));
        }
        object = AxisUtil.prepareXAxis(outputProperties);
        object2 = AxisUtil.prepareBinaryAxis(outputProperties);
        this.axisPair = factory.createAxisPair((XDataAxis)object, (YDataAxis)object2);
        TRACE.exiting(CLASSNAME, "handleTraceStart");
    }
}

