/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.jvmtrace;

import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.DaysFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.AbstractClockCyclesConverter;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;

public class ClockCyclesToDaysConverter
extends AbstractClockCyclesConverter {
    private static final double MILLISECONDS_PER_DAY = 8.64E7;
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(UnitLabels.CLOCKCYCLES, UnitLabels.TIMESTAMP, UnitLabels.DAYS);

    public ClockCyclesToDaysConverter(TraceMetaData traceMetaData) {
        this(traceMetaData, true);
    }

    public ClockCyclesToDaysConverter(TraceMetaData traceMetaData, boolean bl) {
        super(traceMetaData, bl);
    }

    @Override
    protected double getConversionConstant() {
        return 8.64E7;
    }

    @Override
    public String unconvertedFormat(double d) {
        return DaysFormatter.format(d);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return DaysFormatter.format(d);
    }

    @Override
    public double parseUnconverted(String string) {
        return DaysFormatter.parse(string);
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }
}

