/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection;

import com.ibm.java.diagnostics.healthcenter.connection.ConnectionType;
import com.ibm.java.diagnostics.healthcenter.connection.HealthCenterConnectionException;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.connection.NewConnectionPreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class ConnectionProperties {
    private static final int NUMBER_PORTS_TO_SCAN = 101;
    private static final String EMPTY_STRING = "";
    private static final String LOCALHOST = "localhost";
    private static final String INVALID_HOSTNAME_OR_PORT = Messages.getString("NewConnectionModel.invalid.hostname.or.port");
    private String hostname;
    private String displayableHostname;
    private boolean isLocalhost = false;
    private int port;
    private int selectedPort = -1;
    private boolean scan;
    private boolean retry = false;
    private boolean authenticate = false;
    private String username;
    private String password;
    private boolean useSSL = false;
    private String sslTruststoreLocation;
    private String sslTruststorePassword;
    private String sslTruststoreCertificatePassword;
    private ConnectionType type;
    private static final NewConnectionPreferenceHelper preferenceHelper = new NewConnectionPreferenceHelper();

    public ConnectionProperties() throws HealthCenterConnectionException {
        this(preferenceHelper.getHostName(ConnectionType.JMX), preferenceHelper.getPort(ConnectionType.JMX), preferenceHelper.getDoAutoScan());
    }

    public ConnectionProperties(String string, int n, boolean bl) throws HealthCenterConnectionException {
        if (!this.isHostValid(string) || !this.isPortValid(n)) {
            throw new HealthCenterConnectionException(MessageFormat.format(INVALID_HOSTNAME_OR_PORT, string, n));
        }
        this.setHostname(string);
        this.port = n;
        this.scan = bl;
        this.retry = false;
        this.setConnectionType(ConnectionType.JMX);
    }

    public void setConnectionType(ConnectionType connectionType) {
        if (connectionType != this.type) {
            // empty if block
        }
        this.type = connectionType;
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    public void switchConnection(ConnectionType connectionType) {
        if (connectionType.equals((Object)ConnectionType.MQTT)) {
            this.setHostname(preferenceHelper.getHostName(ConnectionType.MQTT));
            this.port = preferenceHelper.getPort(ConnectionType.MQTT);
        } else {
            this.setHostname(preferenceHelper.getHostName(ConnectionType.JMX));
            this.port = preferenceHelper.getPort(ConnectionType.JMX);
            this.scan = preferenceHelper.getDoAutoScan();
        }
    }

    public void setAuthentication(String string, String string2) {
        this.authenticate = true;
        if (string != null) {
            this.username = string;
        }
        if (string2 != null) {
            this.password = string2;
        }
    }

    public void setSSLvalues(String string, String string2, String string3) {
        if (string != null) {
            this.sslTruststoreLocation = string;
        }
        if (string2 != null) {
            this.sslTruststorePassword = string2;
        }
        if (string3 != null) {
            this.sslTruststoreCertificatePassword = string3;
        }
        this.useSSL = true;
    }

    public String getSSLTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public String getSSLTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public String getSSLTruststoreCertificatePassword() {
        return this.sslTruststoreCertificatePassword;
    }

    public static int convertStringPortToInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.username;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticate;
    }

    public boolean isSSLEnabled() {
        return this.useSSL;
    }

    public boolean setHostname(String string) {
        if (this.isHostValid(string)) {
            String string2 = string.trim();
            if (LOCALHOST.equalsIgnoreCase(string2 = string2.split("\\s")[0])) {
                this.isLocalhost = true;
                try {
                    this.hostname = InetAddress.getLocalHost().getHostName();
                    StringBuffer stringBuffer = new StringBuffer(LOCALHOST);
                    stringBuffer.append(" (");
                    stringBuffer.append(this.hostname);
                    stringBuffer.append(")");
                    this.displayableHostname = stringBuffer.toString();
                }
                catch (UnknownHostException unknownHostException) {
                    this.hostname = string2;
                    this.displayableHostname = string2;
                }
            } else {
                this.isLocalhost = false;
                this.hostname = string2;
                this.displayableHostname = string2;
            }
            return true;
        }
        return false;
    }

    public boolean setPort(int n) {
        boolean bl = this.isPortValid(n);
        if (bl) {
            this.port = n;
        }
        return bl;
    }

    public void setScan(boolean bl) {
        this.scan = bl;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getDisplayableHostName() {
        return this.displayableHostname;
    }

    public boolean isLocalhost() {
        return this.isLocalhost;
    }

    public int getPort() {
        return this.port;
    }

    public boolean shouldAutoScan() {
        return this.scan;
    }

    public void writePreferences(ConnectionType connectionType) {
        preferenceHelper.setHostName(this.hostname, connectionType);
        preferenceHelper.setPort(this.port, connectionType);
        preferenceHelper.setDoAutoScan(this.scan);
    }

    private boolean isPortValid(int n) {
        return n >= 0 && n <= 65535;
    }

    private boolean isHostValid(String string) {
        if (string == null) {
            return false;
        }
        return !string.trim().equals(EMPTY_STRING);
    }

    public boolean validateHostName(String string) {
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    public void setSelectedPort(int n) {
        this.selectedPort = n;
    }

    public int getSelectedPort() {
        return this.selectedPort;
    }

    public void setRetry(boolean bl) {
        this.retry = bl;
    }

    public boolean shouldRetry() {
        return this.retry;
    }

    public void setAuthenticationEnabled(boolean bl) {
        this.authenticate = bl;
    }

    public void setSSLEnabled(boolean bl) {
        this.useSSL = bl;
    }

    public String[] getRecentHosts(ConnectionType connectionType) {
        return preferenceHelper.getRecentHosts(connectionType);
    }

    public int getNumPortsToScan() {
        return 101;
    }
}

