/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.marshalling;

import com.ibm.java.diagnostics.common.datamodel.impl.data.RootDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.MarshallerJob;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostProcessingJob
extends MarshallerJob {
    private static final String ANALYZING = Messages.getString("PostProcessingJob.analyzing");
    private static Logger TRACE = LogFactory.getTrace(PostProcessingJob.class);
    private Marshaller marshaller;

    public PostProcessingJob(RootDataImpl rootDataImpl, OutputProperties outputProperties, Marshaller marshaller) {
        super(ANALYZING, rootDataImpl, outputProperties);
        this.marshaller = marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long run() {
        if (this.marshaller.getPostProcessorChain() == null) {
            this.initialisePostProcessingChain();
        }
        if (this.data == null) {
            return 0L;
        }
        this.data.clearPostprocessedLayer();
        this.data.switchToPostprocessing();
        try {
            for (PostProcessor postProcessor : this.marshaller.getPostProcessorChain()) {
                this.runPostProcessor(postProcessor);
            }
        }
        catch (Throwable throwable) {
            TRACE.log(Level.WARNING, throwable.toString(), throwable);
        }
        finally {
            this.data.switchToParsing();
        }
        try {
            this.notifyDataListeners();
        }
        catch (Throwable throwable) {
            TRACE.log(Level.WARNING, throwable.toString(), throwable);
        }
        return 0L;
    }

    private void runPostProcessor(PostProcessor postProcessor) {
        if (postProcessor != null) {
            try {
                try {
                    postProcessor.postprocess(this.data, this.properties);
                }
                catch (Throwable throwable) {
                    if (TRACE.isLoggable(Level.FINE)) {
                        throwable.printStackTrace();
                    }
                    String string = Messages.getString("PostProcessingJob.error.reported");
                    String string2 = MessageFormat.format(string, postProcessor, throwable);
                    TRACE.log(Level.WARNING, string2, throwable);
                }
            }
            catch (Exception exception) {
                String string = Messages.getString("PostProcessingJob.core.exception");
                String string3 = MessageFormat.format(string, postProcessor.toString(), exception);
                TRACE.warning(string3);
            }
        }
    }

    private void initialisePostProcessingChain() {
        ArrayList<PostProcessor> arrayList = new ArrayList<PostProcessor>();
        String[] stringArray = PostProcessorList.getPostProcessors();
        boolean bl = false;
        if (System.getProperty("com.ibm.java.diagnostics.healthcenter.jit.gui.disabled") != null) {
            bl = true;
        }
        for (String string : stringArray) {
            if (string.equals("com.ibm.java.diagnostics.healthcenter.jit.postprocessor.JITPostProcessor") && bl || string.equals("com.ibm.java.diagnostics.healthcenter.jit.postprocessor.MissingJITDataPostProcessor") && bl) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                arrayList.add((PostProcessor)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!TRACE.isLoggable(Level.WARNING)) continue;
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                if (!TRACE.isLoggable(Level.WARNING)) continue;
                instantiationException.printStackTrace();
            }
        }
        Object[] objectArray = arrayList.toArray(new PostProcessor[arrayList.size()]);
        this.marshaller.setPostProcessorChain((PostProcessor[])objectArray);
    }
}

