/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.impl.datatruncation;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataStoragePreferenceHelper;
import com.ibm.java.diagnostics.healthcenter.impl.datatruncation.DataTruncationJob;
import com.ibm.java.diagnostics.healthcenter.impl.marshalling.HealthCenterThread;
import com.ibm.java.diagnostics.healthcenter.marshalling.Marshaller;
import com.ibm.java.diagnostics.healthcenter.marshalling.util.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class DataTruncationThread
extends HealthCenterThread {
    private static final String THREAD_NAME = Messages.getString("DataIndependentThread.thread.name");
    private static final Logger TRACE = LogFactory.getTrace(DataTruncationThread.class);
    private Preferences preferences = new DataStoragePreferenceHelper().getPreferences();

    public DataTruncationThread(Marshaller marshaller) {
        super(THREAD_NAME, marshaller);
    }

    @Override
    protected int getDefaultTimingInterval() {
        int n = this.preferences.getInt("DataStoragePreferenceHelper.classTruncationJobRunInterval", 15);
        int n2 = n;
        if (n2 <= 0) {
            String string = MessageFormat.format(Messages.getString("DataIndependentThread.invalid.preference"), "DataStoragePreferenceHelper.classTruncationJobRunInterval", n2);
            TRACE.warning(string);
            n2 = 10;
        }
        int n3 = n2 * 1000;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueWork() {
        DataTruncationJob dataTruncationJob = null;
        Data data = this.marshaller.getData(null);
        if (data != null) {
            dataTruncationJob = new DataTruncationJob((DataBuilder)data);
            Object object = this.marshaller.getQueueLock();
            synchronized (object) {
                this.marshaller.addJobToQueue(dataTruncationJob);
            }
        }
    }
}

