/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.threads.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.CountData;
import com.ibm.java.diagnostics.healthcenter.api.impl.CountDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.threads.ThreadData;
import com.ibm.java.diagnostics.healthcenter.api.threads.ThreadsData;
import com.ibm.java.diagnostics.healthcenter.api.threads.impl.ThreadDataImpl;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadLabels;
import java.util.Date;
import java.util.HashMap;
import javax.management.Notification;

public class ThreadsDataImpl
extends HealthCenterDataImpl
implements ThreadsData {
    private Notification threadNotify;
    private Notification threadCountNotify;

    public ThreadsDataImpl(Data data) {
        super(data);
    }

    @Override
    public ThreadData[] getLatestThreads() {
        ThreadData[] threadDataArray = new ThreadData[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.THREADS);
        if (data != null) {
            Data data2 = data.getData(ThreadLabels.THREADS);
            Data data3 = data.getData(ThreadLabels.THREAD_NUMBER);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data2;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)data3;
            if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder2 != null && !twoDimensionalDataBuilder2.isEmpty()) {
                long l = (long)twoDimensionalDataBuilder2.getMaxX().getRawX();
                threadDataArray = this.getThreadsForTime(l);
            }
        }
        return threadDataArray;
    }

    @Override
    public ThreadData[] getThreads() {
        ThreadData[] threadDataArray = new ThreadData[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.THREADS);
        if (data != null) {
            DataPointBuilder[] dataPointBuilderArray = null;
            dataPointBuilderArray = this.getEventData(data, ThreadLabels.THREADS);
            if (dataPointBuilderArray != null) {
                threadDataArray = new ThreadData[dataPointBuilderArray.length];
                int n = 0;
                for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                    ThreadDataPointImpl threadDataPointImpl = (ThreadDataPointImpl)dataPointBuilder;
                    String[] stringArray = new String[]{};
                    TwoDimensionalDataBuilder twoDimensionalDataBuilder = threadDataPointImpl.getMonitors();
                    if (twoDimensionalDataBuilder != null) {
                        DataPointBuilder[] dataPointBuilderArray2 = twoDimensionalDataBuilder.getDataPoints();
                        int n2 = 0;
                        stringArray = new String[dataPointBuilderArray2.length];
                        for (DataPointBuilder dataPointBuilder2 : dataPointBuilderArray2) {
                            stringArray[n2] = dataPointBuilder2.getComment();
                            ++n2;
                        }
                    }
                    threadDataArray[n] = new ThreadDataImpl(threadDataPointImpl.getRawX(), threadDataPointImpl.getComment(), Thread.State.valueOf(threadDataPointImpl.getState()), stringArray, threadDataPointImpl.getContendedMonitor(), threadDataPointImpl.getContendedMonitorOwner(), threadDataPointImpl.getStackElements(), threadDataPointImpl.getMonitorInfo(), threadDataPointImpl.getLockInfo());
                    ++n;
                }
            }
        }
        return threadDataArray;
    }

    @Override
    public CountData[] getThreadCounts() {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.THREADS);
        CountData[] countDataArray = new CountData[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (data != null && (dataPointBuilderArray = this.getEventData(data, ThreadLabels.THREAD_NUMBER)) != null) {
            countDataArray = new CountData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                countDataArray[n] = new CountDataImpl(dataPointBuilder.getRawX(), (long)dataPointBuilder.getRawY());
                ++n;
            }
        }
        return countDataArray;
    }

    @Override
    protected String getRecommendationLabel() {
        return ThreadLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.THREADS;
    }

    @Override
    public boolean deadlockDetected() {
        String[] stringArray;
        for (String string : stringArray = this.getCriticalRecommendations()) {
            if (!string.contains(ThreadLabels.DEADLOCK_DETECTED)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    @Override
    public HashMap<Long, ThreadData[]> getAllThreads() {
        CountData[] countDataArray = this.getThreadCounts();
        HashMap<Long, ThreadData[]> hashMap = new HashMap<Long, ThreadData[]>();
        for (CountData countData : countDataArray) {
            long l = countData.getTime();
            hashMap.put(new Long(l), this.getThreadsForTime(l));
        }
        return hashMap;
    }

    private ThreadData[] getThreadsForTime(long l) {
        ThreadData[] threadDataArray = new ThreadData[]{};
        Data data = this.getJvmData().getTopLevelData(JVMLabels.THREADS);
        if (data != null) {
            Data data2 = data.getData(ThreadLabels.THREADS);
            Data data3 = data.getData(ThreadLabels.THREAD_NUMBER);
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data2;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)data3;
            if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder2 != null && !twoDimensionalDataBuilder2.isEmpty()) {
                DataPointBuilder[] dataPointBuilderArray = null;
                TwoDimensionalDataImpl twoDimensionalDataImpl = new TwoDimensionalDataImpl("data", twoDimensionalDataBuilder.getAxisPair());
                for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = this.getEventData(data, ThreadLabels.THREADS)) {
                    if (dataPointBuilder.getRawX() != (double)l) continue;
                    twoDimensionalDataImpl.addDataPointBuilder(dataPointBuilder);
                }
                dataPointBuilderArray = twoDimensionalDataImpl.getDataPoints();
                if (dataPointBuilderArray != null) {
                    threadDataArray = new ThreadData[dataPointBuilderArray.length];
                    int n = 0;
                    for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                        ThreadDataPointImpl threadDataPointImpl = (ThreadDataPointImpl)dataPointBuilder;
                        String[] stringArray = new String[]{};
                        TwoDimensionalDataBuilder twoDimensionalDataBuilder3 = threadDataPointImpl.getMonitors();
                        if (twoDimensionalDataBuilder3 != null) {
                            DataPointBuilder[] dataPointBuilderArray2 = twoDimensionalDataBuilder3.getDataPoints();
                            int n2 = 0;
                            stringArray = new String[dataPointBuilderArray2.length];
                            for (DataPointBuilder dataPointBuilder2 : dataPointBuilderArray2) {
                                stringArray[n2] = dataPointBuilder2.getComment();
                                ++n2;
                            }
                        }
                        threadDataArray[n] = new ThreadDataImpl(threadDataPointImpl.getRawX(), threadDataPointImpl.getComment(), Thread.State.valueOf(threadDataPointImpl.getState()), stringArray, threadDataPointImpl.getContendedMonitor(), threadDataPointImpl.getContendedMonitorOwner(), threadDataPointImpl.getStackElements());
                        ++n;
                    }
                }
            }
        }
        return threadDataArray;
    }

    static /* synthetic */ long access$000(ThreadsDataImpl threadsDataImpl) {
        return threadsDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date threadTime;
        Date threadCountTime;
        long count = 0L;
        long delay = ThreadsDataImpl.access$000(ThreadsDataImpl.this);

        public Updater(long l) {
            if (l >= ThreadsDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.threadTime = new Date();
                        this.threadCountTime = new Date();
                        if (ThreadsDataImpl.this.getThreads() != null && ThreadsDataImpl.this.getThreads().length > 0 && ThreadsDataImpl.this.getThreads()[ThreadsDataImpl.this.getThreads().length - 1].getTime() != this.threadTime.getTime()) {
                            ThreadsDataImpl.this.threadNotify = new Notification(null, ThreadsDataImpl.this, this.count++);
                            ThreadsDataImpl.this.threadNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.ThreadData");
                            ThreadsDataImpl.this.sendNotification(ThreadsDataImpl.this.threadNotify);
                        }
                        if (ThreadsDataImpl.this.getThreadCounts() != null && ThreadsDataImpl.this.getThreadCounts().length > 0 && ThreadsDataImpl.this.getThreadCounts()[ThreadsDataImpl.this.getThreadCounts().length - 1].getTime() != this.threadCountTime.getTime()) {
                            ThreadsDataImpl.this.threadCountNotify = new Notification(null, ThreadsDataImpl.this, this.count++);
                            ThreadsDataImpl.this.threadCountNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.threads.ThreadCountData");
                            ThreadsDataImpl.this.sendNotification(ThreadsDataImpl.this.threadCountNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

