/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.profiling.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.healthcenter.api.profiling.MethodProfileData;
import com.ibm.java.diagnostics.healthcenter.api.profiling.MethodProfileTime;
import com.ibm.java.diagnostics.healthcenter.api.profiling.MethodProfilingNode;
import com.ibm.java.diagnostics.healthcenter.api.profiling.impl.MethodProfileTimeImpl;
import com.ibm.java.diagnostics.healthcenter.api.profiling.impl.MethodProfilingNodeImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.CallHierarchyNode;
import com.ibm.java.diagnostics.healthcenter.profiling.ForwardMethodNode;
import com.ibm.java.diagnostics.healthcenter.profiling.InvocationHierarchyNode;
import com.ibm.java.diagnostics.healthcenter.profiling.MethodTree;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.profiling.ReverseMethodNode;

public class MethodProfileDataImpl
implements MethodProfileData {
    private String methodName;
    private long methodID;
    private double cumulativePercentage;
    private double percentage;
    private long sampleCount;
    private Data jvmData;

    public MethodProfileDataImpl(Data data, String string, long l, double d, double d2, long l2) {
        this.jvmData = data;
        this.methodName = string;
        this.methodID = l;
        this.cumulativePercentage = d;
        this.percentage = d2;
        this.sampleCount = l2;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public MethodProfilingNode[] getCallingMethods() {
        MethodTree methodTree;
        MethodProfilingNodeImpl methodProfilingNodeImpl = null;
        if (this.jvmData != null && (methodTree = (MethodTree)this.jvmData.getData(ProfilingLabels.PROFILE_DATA)) != null) {
            InvocationHierarchyNode[] invocationHierarchyNodeArray;
            ForwardMethodNode forwardMethodNode = (ForwardMethodNode)methodTree.getMethodsThatCall(Long.toHexString(this.methodID));
            methodProfilingNodeImpl = new MethodProfilingNodeImpl(this.methodName, 100.0);
            for (InvocationHierarchyNode invocationHierarchyNode : invocationHierarchyNodeArray = forwardMethodNode.getCallingMethods()) {
                if (!(invocationHierarchyNode instanceof InvocationHierarchyNode)) continue;
                this.findCallingMethods(invocationHierarchyNode, methodProfilingNodeImpl);
            }
        }
        return methodProfilingNodeImpl.getCallingMethods();
    }

    void findCallingMethods(InvocationHierarchyNode invocationHierarchyNode, MethodProfilingNodeImpl methodProfilingNodeImpl) {
        InvocationHierarchyNode[] invocationHierarchyNodeArray;
        for (InvocationHierarchyNode invocationHierarchyNode2 : invocationHierarchyNodeArray = invocationHierarchyNode.getCallingMethods()) {
            if (!(invocationHierarchyNode2 instanceof InvocationHierarchyNode)) continue;
            MethodProfilingNodeImpl methodProfilingNodeImpl2 = new MethodProfilingNodeImpl(invocationHierarchyNode2.getFullyQualifiedName(), invocationHierarchyNode2.getWeight());
            methodProfilingNodeImpl.addCallingMethod(methodProfilingNodeImpl2);
            methodProfilingNodeImpl2.addCalledMethod(methodProfilingNodeImpl);
            this.findCallingMethods(invocationHierarchyNode2, methodProfilingNodeImpl2);
        }
    }

    @Override
    public double getStackSamplePercentage() {
        return this.cumulativePercentage;
    }

    @Override
    public long getMethodId() {
        return this.methodID;
    }

    @Override
    public double getMethodSamplePercentage() {
        return this.percentage;
    }

    @Override
    public long getMethodSampleCount() {
        return this.sampleCount;
    }

    @Override
    public MethodProfileTime[] getMethodProfileTimes() {
        TwoDimensionalData twoDimensionalData;
        Data data;
        MethodProfileTime[] methodProfileTimeArray = new MethodProfileTime[]{};
        DataPointBuilder[] dataPointBuilderArray = null;
        if (this.jvmData != null && (data = this.jvmData.getData(ProfilingLabels.PROFILE_DATA)) != null && (twoDimensionalData = (TwoDimensionalData)data.getData(Long.toHexString(this.methodID))) != null) {
            dataPointBuilderArray = twoDimensionalData.getDataPoints();
            methodProfileTimeArray = new MethodProfileTime[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                methodProfileTimeArray[n] = new MethodProfileTimeImpl(dataPointBuilder.getRawX());
                ++n;
            }
        }
        return methodProfileTimeArray;
    }

    @Override
    public MethodProfilingNode[] getCalledMethods() {
        MethodTree methodTree;
        MethodProfilingNodeImpl methodProfilingNodeImpl = null;
        if (this.jvmData != null && (methodTree = (MethodTree)this.jvmData.getData(ProfilingLabels.PROFILE_DATA)) != null) {
            CallHierarchyNode[] callHierarchyNodeArray;
            ReverseMethodNode reverseMethodNode = (ReverseMethodNode)methodTree.getMethodsCalledBy(Long.toHexString(this.methodID));
            methodProfilingNodeImpl = new MethodProfilingNodeImpl(this.methodName, 100.0);
            for (CallHierarchyNode callHierarchyNode : callHierarchyNodeArray = reverseMethodNode.getCalledMethods()) {
                if (!(callHierarchyNode instanceof CallHierarchyNode)) continue;
                this.findCalledMethods(callHierarchyNode, methodProfilingNodeImpl);
            }
        }
        return methodProfilingNodeImpl.getCalledMethods();
    }

    void findCalledMethods(CallHierarchyNode callHierarchyNode, MethodProfilingNodeImpl methodProfilingNodeImpl) {
        CallHierarchyNode[] callHierarchyNodeArray;
        for (CallHierarchyNode callHierarchyNode2 : callHierarchyNodeArray = callHierarchyNode.getCalledMethods()) {
            if (!(callHierarchyNode2 instanceof CallHierarchyNode)) continue;
            MethodProfilingNodeImpl methodProfilingNodeImpl2 = new MethodProfilingNodeImpl(callHierarchyNode2.getFullyQualifiedName(), callHierarchyNode2.getWeight());
            methodProfilingNodeImpl.addCalledMethod(methodProfilingNodeImpl2);
            methodProfilingNodeImpl2.addCallingMethod(methodProfilingNodeImpl);
            this.findCalledMethods(callHierarchyNode2, methodProfilingNodeImpl2);
        }
    }
}

