/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.environment.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.StringData;
import com.ibm.java.diagnostics.common.datamodel.data.TableData;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataRow;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.environment.postprocessor.analysis.AnalysingEnvironmentPostprocessor;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.management.Notification;

public class EnvironmentDataImpl
extends HealthCenterDataImpl
implements EnvironmentData {
    Notification environmentNotify;

    public EnvironmentDataImpl(Data data) {
        super(data);
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.ENVIRONMENT;
    }

    @Override
    protected String getRecommendationLabel() {
        return AnalysingEnvironmentPostprocessor.RECOMMENDATION_LABEL;
    }

    @Override
    public String getJavaFullVersion() {
        String string = null;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.FULL_JAVA_VERSION);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public Calendar getHealthCenterAgentLibraryDate() {
        StringData stringData;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null && (stringData = (StringData)data.getData(EnvironmentLabels.NATIVE_LIBRARY_BUILD_DATE)) != null) {
            gregorianCalendar.setTime(new SimpleDateFormat("MMM dd yyyy HH:mm:ss").parse(stringData.getValue(), new ParsePosition(0)));
        }
        return gregorianCalendar;
    }

    @Override
    public String getHealthCenterAgentVersion() {
        StringData stringData;
        String string = null;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null && (stringData = (StringData)data.getData(EnvironmentLabels.AGENT_JAR_VERSION)) != null) {
            string = stringData.getValue();
        }
        return string;
    }

    @Override
    public String getJavaHome() {
        String string = null;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.JAVA_HOME);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public String getJavaVendor() {
        String string = null;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.JAVA_VENDOR);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public String getJavaVersion() {
        String string = null;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.JAVA_VERSION);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public String getJavaVirtualMachineName() {
        String string = null;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.VM_NAME);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public int getProcessId() {
        int n = this.UNSET;
        TableDataRow tableDataRow = this.getJRETableRow(EnvironmentLabels.PID);
        if (tableDataRow != null) {
            n = Integer.parseInt((String)tableDataRow.get(1));
        }
        return n;
    }

    private TableData getJRETable() {
        TableData tableData = null;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null) {
            tableData = (TableData)data.getData(EnvironmentLabels.JRE_INFORMATION);
        }
        return tableData;
    }

    private TableData getConfigurationTable() {
        TableData tableData = null;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null) {
            tableData = (TableData)data.getData(EnvironmentLabels.CONFIGURATION_INFORMATION);
        }
        return tableData;
    }

    private TableDataRow getJRETableRow(String string) {
        TableDataRow tableDataRow = null;
        TableData tableData = this.getJRETable();
        if (tableData != null) {
            tableDataRow = tableData.get(string);
        }
        return tableDataRow;
    }

    private TableDataRow getConfigurationTableRow(String string) {
        TableDataRow tableDataRow = null;
        TableData tableData = this.getConfigurationTable();
        if (tableData != null) {
            tableDataRow = tableData.get(string);
        }
        return tableDataRow;
    }

    private TableData getSystemTable() {
        TableData tableData = null;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null) {
            tableData = (TableData)data.getData(EnvironmentLabels.SYSTEM);
        }
        return tableData;
    }

    private TableDataRow getSystemTableRow(String string) {
        TableDataRow tableDataRow = null;
        TableData tableData = this.getSystemTable();
        if (tableData != null) {
            tableDataRow = tableData.get(string);
        }
        return tableDataRow;
    }

    @Override
    public String getHostName() {
        String string = null;
        TableDataRow tableDataRow = this.getSystemTableRow(EnvironmentLabels.HOSTNAME);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public String getOperatingSystemVersion() {
        String string = null;
        TableDataRow tableDataRow = this.getSystemTableRow(EnvironmentLabels.OS_VERSION);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public String getOperatingSystemName() {
        String string = null;
        TableDataRow tableDataRow = this.getSystemTableRow(EnvironmentLabels.OS);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public int getProcessorCount() {
        int n = this.UNSET;
        TableDataRow tableDataRow = this.getSystemTableRow(EnvironmentLabels.NUMBER_OF_PROCESSORS);
        if (tableDataRow != null) {
            n = Integer.parseInt((String)tableDataRow.get(1));
        }
        return n;
    }

    @Override
    public String getSystemArchitecture() {
        String string = null;
        TableDataRow tableDataRow = this.getSystemTableRow(EnvironmentLabels.ARCHITECTURE);
        if (tableDataRow != null) {
            string = (String)tableDataRow.get(1);
        }
        return string;
    }

    @Override
    public Properties getSystemProperties() {
        TableDataRow[] tableDataRowArray;
        TableDataBuilder tableDataBuilder;
        Properties properties = new Properties();
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null && (tableDataBuilder = (TableDataBuilder)data.getData(EnvironmentLabels.SYSTEM_PROPERTIES)) != null && (tableDataRowArray = tableDataBuilder.getContents()) != null) {
            for (TableDataRow tableDataRow : tableDataRowArray) {
                properties.setProperty((String)tableDataRow.get(0), (String)tableDataRow.get(1));
            }
        }
        return properties;
    }

    @Override
    public Properties getEnvironmentVariables() {
        TableDataRow[] tableDataRowArray;
        TableDataBuilder tableDataBuilder;
        Properties properties = new Properties();
        Data data = this.getJvmData().getTopLevelData(JVMLabels.ENVIRONMENT);
        if (data != null && (tableDataBuilder = (TableDataBuilder)data.getData(EnvironmentLabels.ENVIRONMENT_VARIABLES)) != null && (tableDataRowArray = tableDataBuilder.getContents()) != null) {
            for (TableDataRow tableDataRow : tableDataRowArray) {
                properties.setProperty((String)tableDataRow.get(0), (String)tableDataRow.get(1));
            }
        }
        return properties;
    }

    @Override
    public String[] getBootClasspath() {
        Object object;
        String[] stringArray = new String[]{};
        TableDataRow tableDataRow = this.getConfigurationTableRow(EnvironmentLabels.BOOT_CLASS_PATH);
        if (tableDataRow != null && (object = tableDataRow.get(1)) != null && object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public String[] getClasspath() {
        Object object;
        String[] stringArray = new String[]{};
        TableDataRow tableDataRow = this.getConfigurationTableRow(EnvironmentLabels.CLASS_PATH);
        if (tableDataRow != null && (object = tableDataRow.get(1)) != null && object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public String[] getDumpOptions() {
        Object object;
        String[] stringArray = new String[]{};
        TableDataRow tableDataRow = this.getConfigurationTableRow(EnvironmentLabels.DUMP_OPTIONS);
        if (tableDataRow != null && (object = tableDataRow.get(1)) != null && object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public String[] getJavaCommandLine() {
        Object object;
        String[] stringArray = new String[]{};
        TableDataRow tableDataRow = this.getConfigurationTableRow(EnvironmentLabels.COMMAND_LINE);
        if (tableDataRow != null && (object = tableDataRow.get(1)) != null && object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public String[] getJavaParameters() {
        Object object;
        String[] stringArray = new String[]{};
        TableDataRow tableDataRow = this.getConfigurationTableRow(EnvironmentLabels.JAVA_PARAMETERS);
        if (tableDataRow != null && (object = tableDataRow.get(1)) != null && object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
        }
        return stringArray;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    static /* synthetic */ long access$000(EnvironmentDataImpl environmentDataImpl) {
        return environmentDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        long count = 0L;
        long delay = EnvironmentDataImpl.access$000(EnvironmentDataImpl.this);

        public Updater(long l) {
            if (l >= EnvironmentDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        EnvironmentDataImpl.this.environmentNotify = new Notification(null, EnvironmentDataImpl.this, this.count++);
                        EnvironmentDataImpl.this.environmentNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.environment.EnvironmentData");
                        EnvironmentDataImpl.this.sendNotification(EnvironmentDataImpl.this.environmentNotify);
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

