/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TraceFormatter
extends Formatter {
    private static final String FOUND_EXCEPTION = "Found exception: ";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static long INITIALIZATION_MILLIS;
    private static long LAST_MILLIS;

    @Override
    public String format(LogRecord logRecord) {
        String string = logRecord.getLoggerName();
        if (string.indexOf(46) > -1) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("%4d %5d [%4d] %s %s", logRecord.getMillis() - INITIALIZATION_MILLIS, logRecord.getMillis() - LAST_MILLIS, logRecord.getThreadID(), string, logRecord.getMessage()));
        stringBuffer.append(NEWLINE);
        for (Throwable throwable = logRecord.getThrown(); throwable != null; throwable = throwable.getCause()) {
            stringBuffer.append(FOUND_EXCEPTION);
            stringBuffer.append(throwable.getMessage());
            stringBuffer.append(NEWLINE);
            stringBuffer.append(this.getStackTraceAsString(throwable));
        }
        LAST_MILLIS = logRecord.getMillis();
        return stringBuffer.toString();
    }

    private String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }

    static {
        LAST_MILLIS = INITIALIZATION_MILLIS = System.currentTimeMillis();
    }
}

