/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.axes.XAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NormalisingIdentityConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToGigabytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToKilobytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.BytesToMegabytesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.ClockTimeUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.DateUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.DaysUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.HoursUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.HundredsUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.MillisecondsToSecondsUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.MinutesUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.SecondsUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.util.Messages;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import java.util.logging.Logger;

public class AxisUtil {
    private static final String AMOUNT = "AMOUNT_AXIS";
    private static final String BINARY = "BINARY_AXIS";
    private static final String NUMBER = "NUMBER_AXIS";
    private static final String TIME = "TIME_AXIS";
    private static final Logger TRACE = LogFactory.getTrace(AxisUtil.class);
    protected static final DataFactory factory = DataFactory.getFactory();
    public static final String NORMALISED_TIME = Messages.getString("VGCAxes.time.from.start");
    public static final XAxis X_AXIS = factory.createXAxis(UnitLabels.TIME, UnitLabels.MINUTES);
    public static final YAxis TIME_AXIS = factory.createYAxis(UnitLabels.TIME, UnitLabels.MILLISECONDS);
    public static final YAxis NUMBER_AXIS = factory.createYAxis(UnitLabels.NUMBER, UnitLabels.HASH_SIGN);
    public static final YAxis BINARY_AXIS = factory.createYAxis(UnitLabels.NUMBER, UnitLabels.HASH_SIGN, 1);
    public static final YAxis RATE_AXIS = factory.createYAxis(UnitLabels.RATE, UnitLabels.TIMES_SIGN);
    public static final YAxis PERCENT_AXIS = factory.createYAxis(UnitLabels.PERCENT_LABEL, UnitLabels.PERCENT_SIGN);
    public static final YAxis BYTE_AXIS = factory.createYAxis(UnitLabels.AMOUNT, UnitLabels.BYTES);

    public static XDataAxis prepareXAxis(OutputProperties outputProperties) {
        if (outputProperties.getXDataAxis() == null) {
            XDataAxis xDataAxis = AxisUtil.getXAxis(outputProperties).createDataAxis(outputProperties, UnitLabels.MILLISECONDS_SINCE_EPOCH);
            try {
                xDataAxis.addUnitConverter(new HoursUnitConverter());
                xDataAxis.addUnitConverter(new MinutesUnitConverter());
                xDataAxis.addUnitConverter(new SecondsUnitConverter());
                xDataAxis.addUnitConverter(new DaysUnitConverter());
                xDataAxis.addUnitConverter(new DateUnitConverter(outputProperties));
                xDataAxis.addUnitConverter(new ClockTimeUnitConverter(outputProperties));
                xDataAxis.addUnitConverter(new NormalisingIdentityConverter(xDataAxis.getLabel(), UnitLabels.MILLISECONDS_SINCE_EPOCH, UnitLabels.MILLISECONDS));
                outputProperties.setXDataAxis(xDataAxis);
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(javaDiagnosticsException.toString());
            }
        }
        return outputProperties.getXDataAxis();
    }

    private static XAxis getXAxis(OutputProperties outputProperties) {
        XAxis xAxis = outputProperties.getXAxis();
        if (xAxis == null) {
            xAxis = factory.createXAxis(UnitLabels.TIME, UnitLabels.MINUTES);
            outputProperties.setXAxis(xAxis);
        }
        return xAxis;
    }

    public static YDataAxis prepareTimeAxis(OutputProperties outputProperties) {
        if (outputProperties.getYDataAxis(TIME) == null) {
            YDataAxis yDataAxis = AxisUtil.getTimeAxis(outputProperties).createDataAxis(outputProperties, UnitLabels.MILLISECONDS);
            try {
                MillisecondsToSecondsUnitConverter millisecondsToSecondsUnitConverter = new MillisecondsToSecondsUnitConverter();
                yDataAxis.addUnitConverter(millisecondsToSecondsUnitConverter);
                outputProperties.setYDataAxis(TIME, yDataAxis);
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(javaDiagnosticsException.toString());
            }
        }
        return outputProperties.getYDataAxis(TIME);
    }

    private static YAxis getTimeAxis(OutputProperties outputProperties) {
        YAxis yAxis = outputProperties.getYAxis(TIME);
        if (yAxis == null) {
            yAxis = factory.createYAxis(UnitLabels.TIME, UnitLabels.MILLISECONDS);
            outputProperties.setYAxis(TIME, yAxis);
        }
        return yAxis;
    }

    public static YDataAxis prepareNumberAxis(OutputProperties outputProperties) {
        if (outputProperties.getYDataAxis(NUMBER) == null) {
            YDataAxis yDataAxis = AxisUtil.getNumberAxis(outputProperties).createDataAxis(outputProperties, UnitLabels.HASH_SIGN);
            try {
                HundredsUnitConverter hundredsUnitConverter = new HundredsUnitConverter();
                yDataAxis.addUnitConverter(hundredsUnitConverter);
                outputProperties.setYDataAxis(NUMBER, yDataAxis);
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(javaDiagnosticsException.toString());
            }
        }
        return outputProperties.getYDataAxis(NUMBER);
    }

    private static YAxis getNumberAxis(OutputProperties outputProperties) {
        YAxis yAxis = outputProperties.getYAxis(NUMBER);
        if (yAxis == null) {
            yAxis = factory.createYAxis(UnitLabels.NUMBER, UnitLabels.HASH_SIGN);
            outputProperties.setYAxis(NUMBER, yAxis);
        }
        return yAxis;
    }

    public static YDataAxis prepareBinaryAxis(OutputProperties outputProperties) {
        if (outputProperties.getYDataAxis(BINARY) == null) {
            YDataAxis yDataAxis = AxisUtil.getBinaryAxis(outputProperties).createDataAxis(outputProperties, UnitLabels.HASH_SIGN);
            try {
                HundredsUnitConverter hundredsUnitConverter = new HundredsUnitConverter();
                yDataAxis.addUnitConverter(hundredsUnitConverter);
                outputProperties.setYDataAxis(BINARY, yDataAxis);
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(javaDiagnosticsException.toString());
            }
        }
        return outputProperties.getYDataAxis(BINARY);
    }

    private static YAxis getBinaryAxis(OutputProperties outputProperties) {
        YAxis yAxis = outputProperties.getYAxis(BINARY);
        if (yAxis == null) {
            yAxis = factory.createYAxis(UnitLabels.NUMBER, UnitLabels.HASH_SIGN, 1);
            outputProperties.setYAxis(BINARY, yAxis);
        }
        return yAxis;
    }

    public static YDataAxis prepareAmountAxis(OutputProperties outputProperties) {
        if (outputProperties.getYDataAxis(AMOUNT) == null) {
            YDataAxis yDataAxis = AxisUtil.getAmountAxis(outputProperties).createDataAxis(outputProperties, UnitLabels.BYTES);
            try {
                yDataAxis.addUnitConverter(new BytesToKilobytesUnitConverter());
                yDataAxis.addUnitConverter(new BytesToMegabytesUnitConverter());
                yDataAxis.addUnitConverter(new BytesToGigabytesUnitConverter());
                outputProperties.setYDataAxis(AMOUNT, yDataAxis);
            }
            catch (JavaDiagnosticsException javaDiagnosticsException) {
                TRACE.warning(javaDiagnosticsException.toString());
            }
        }
        return outputProperties.getYDataAxis(AMOUNT);
    }

    private static YAxis getAmountAxis(OutputProperties outputProperties) {
        YAxis yAxis = outputProperties.getYAxis(AMOUNT);
        if (yAxis == null) {
            yAxis = factory.createYAxis(UnitLabels.AMOUNT, UnitLabels.BYTES);
            outputProperties.setYAxis(AMOUNT, yAxis);
        }
        return yAxis;
    }
}

