/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.nativeAdapterData.win32.internal;

import com.ibm.cic.common.commonNativeAdapterData.DelayedProcessingNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeAdapterDataParser;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.NativeAdapterData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.nativeAdapterData.win32.DesktopIconWin32NativeData;
import com.ibm.cic.common.nativeAdapterData.win32.EnvironmentNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryKeyNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.RegistryValueNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.ShortcutNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.SpecialFileNativeData;
import com.ibm.cic.common.nativeAdapterData.win32.internal.IXMLConstants;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;

public class NativeWin32AdapterDataParser
extends ICommonNativeAdapterDataParser
implements IXMLConstants {
    private NativeAdapterData nativeData;
    private IErrorReporter reporter;
    private ICommonNativeAdapterDataParser.ElemStack elemStack;

    public void initialize(IInstallableUnit iu, IErrorReporter errorReporter) {
        this.nativeData = new NativeAdapterData();
        this.reporter = errorReporter;
        this.elemStack = new ICommonNativeAdapterDataParser.ElemStack();
        super.initialize(iu, this.nativeData, this.elemStack, errorReporter);
    }

    public IArtifact startArtifact(String uri, String name, String qName, Attributes attributes, String key) {
        return super.startArtifact(this.elemStack, this.reporter, uri, name, qName, attributes, key);
    }

    public void endArtifact() {
        this.elemStack.pop();
    }

    public IArtifact startArtifactNoKey(String uri, String name, String qName, Attributes attributes, ArtifactCommonAttributes aca) {
        return super.startArtifactNoKey(this.elemStack, this.reporter, uri, name, qName, attributes, aca);
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.elemStack.push((Object)new ICommonNativeAdapterDataParser.ElemStackEntry(name));
        boolean processed = this.processCommonElement(name, attributes);
        if (!processed) {
            if (name.equals("shortcut")) {
                this.handleShortcutAttributes(attributes);
            } else if (name.equals("desktopIcon_win32")) {
                this.handleDesktopIconWin32Attributes(attributes);
            } else if (name.equals("registry")) {
                this.handleRegistryAttributes(attributes);
            } else if (name.equals("key")) {
                this.handleRegistryKeyAttributes(attributes);
            } else if (name.equals("value")) {
                this.handleRegistryValueAttributes(attributes);
            } else if (name.equals("specialFile")) {
                this.handleSpecialFileAttributes(attributes);
            } else if (name.equals("environment")) {
                this.handleEnvironmentAttributes(attributes);
            } else if (name.equals("delayedProcessing")) {
                this.handleDelayedProcessing(attributes);
            } else {
                this.reporter.unexpectedElement(name, attributes);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.elemStack.pop();
    }

    public IAdapterData getAdapterData() {
        return this.nativeData;
    }

    public URL getSchema() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.cic.common.nativeAdapterData.win32");
        Path path = new Path("schema/nativeAdapterData.xsd");
        return FileLocator.find((Bundle)bundle, (IPath)path, null);
    }

    private void handleShortcutAttributes(Attributes attributes) {
        String workingDirectory;
        String description;
        String targetPath;
        String path;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("shortcut", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "shortcut", new String[]{"path", "targetPath", "arguments", "iconPath", "iconIndex", "description", "workingDirectory"})) {
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "path", null);
            hasErrors = true;
        }
        if ((targetPath = attributes.getValue("targetPath")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "targetPath", null);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        if (iconPath == null) {
            this.reporter.checkRequiredAttribute("shortcut", "iconPath", null);
            hasErrors = true;
        }
        String iconIndexStr = attributes.getValue("iconIndex");
        int iconIndex = 0;
        if (iconIndexStr != null) {
            try {
                iconIndex = Integer.parseInt(iconIndexStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.reporter.invalidAttributeValue("shortcut", "iconIndex", iconIndexStr);
                hasErrors = true;
            }
        }
        if ((description = attributes.getValue("description")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "description", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("shortcut", "workingDirectory", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            ShortcutNativeData data = new ShortcutNativeData(path, targetPath, arguments, iconPath, iconIndex, description, workingDirectory);
            this.nativeData.addData((ICommonNativeData)data);
        }
    }

    private void handleDesktopIconWin32Attributes(Attributes attributes) {
        String command;
        String workingDirectory;
        String name;
        String folder;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("desktopIcon_win32", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "desktopIcon_win32", new String[]{"folder", "name", "workingDirectory", "command", "arguments", "iconPath", "iconIndex", "context", "description"})) {
            hasErrors = true;
        }
        if ((folder = attributes.getValue("folder")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "folder", null);
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "name", null);
            hasErrors = true;
        }
        if ((workingDirectory = attributes.getValue("workingDirectory")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "workingDirectory", null);
            hasErrors = true;
        }
        if ((command = attributes.getValue("command")) == null) {
            this.reporter.checkRequiredAttribute("desktopIcon_win32", "command", null);
            hasErrors = true;
        }
        String arguments = attributes.getValue("arguments");
        String iconPath = attributes.getValue("iconPath");
        String iconIndexStr = attributes.getValue("iconIndex");
        int iconIndex = 0;
        if (iconIndexStr != null) {
            try {
                iconIndex = Integer.parseInt(iconIndexStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.reporter.invalidAttributeValue("desktopIcon_win32", "iconIndex", iconIndexStr);
                hasErrors = true;
            }
        }
        String description = attributes.getValue("description");
        if (!hasErrors) {
            DesktopIconWin32NativeData data = new DesktopIconWin32NativeData(folder, name, workingDirectory, command, arguments, iconPath, iconIndex, CicCommonSettings.getAccessRightsMode().isAdminMode(), description);
            this.nativeData.addData((ICommonNativeData)data);
        }
    }

    private void handleRegistryAttributes(Attributes attributes) {
        String accessMask;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("registry", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "registry", new String[]{"name", "value", "type", "replace", "accessMask"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("registry", "name", null);
            hasErrors = true;
        }
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        if (!RegistryValueNativeData.validType(type)) {
            this.reporter.invalidAttributeValue("registry", "type", type);
            hasErrors = true;
        }
        String replaceStr = attributes.getValue("replace");
        boolean replace = false;
        if (replaceStr != null) {
            replace = Boolean.valueOf(replaceStr);
        }
        if (!RegistryNativeData.isValidAccessMask(accessMask = attributes.getValue("accessMask"))) {
            this.reporter.invalidAttributeValue("registry", "accessMask", accessMask);
            hasErrors = true;
        }
        if (!hasErrors) {
            RegistryNativeData data = new RegistryNativeData(name, value, type, replace, accessMask);
            this.nativeData.addData((ICommonNativeData)data);
            this.elemStack.top().data = data;
        }
    }

    private void handleRegistryKeyAttributes(Attributes attributes) {
        String name;
        boolean hasErrors = false;
        if (!this.isRegistrySubElement()) {
            this.reporter.unexpectedElement("key", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "key", new String[]{"name", "value", "type"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("key", "name", null);
            hasErrors = true;
        }
        String value = attributes.getValue("value");
        String type = attributes.getValue("type");
        if (!RegistryValueNativeData.validType(type)) {
            this.reporter.invalidAttributeValue("key", "type", type);
            hasErrors = true;
        }
        if (!hasErrors) {
            RegistryKeyNativeData data = new RegistryKeyNativeData(name, value, type);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private void handleRegistryValueAttributes(Attributes attributes) {
        String type;
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isRegistrySubElement()) {
            this.reporter.unexpectedElement("value", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "value", new String[]{"name", "value", "type"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("value", "name", null);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.reporter.checkRequiredAttribute("value", "value", null);
            hasErrors = true;
        }
        if (!RegistryValueNativeData.validType(type = attributes.getValue("type"))) {
            this.reporter.invalidAttributeValue("value", "type", type);
            hasErrors = true;
        }
        if (!hasErrors) {
            RegistryValueNativeData data = new RegistryValueNativeData(name, value, type);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
        }
    }

    private void handleSpecialFileAttributes(Attributes attributes) {
        String path;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("specialFile", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "specialFile", new String[]{"path", "types"})) {
            hasErrors = true;
        }
        if ((path = attributes.getValue("path")) == null) {
            this.reporter.checkRequiredAttribute("specialFile", "path", null);
            hasErrors = true;
        }
        String typesStr = attributes.getValue("types");
        List types = null;
        if (typesStr == null) {
            this.reporter.checkRequiredAttribute("specialFile", "types", null);
            hasErrors = true;
        } else {
            types = SpecialFileNativeData.parseTypes(typesStr);
            if (types == null) {
                this.reporter.invalidAttributeValue("specialFile", "types", typesStr);
                hasErrors = true;
            }
        }
        if (!hasErrors) {
            SpecialFileNativeData data = new SpecialFileNativeData(path, types);
            this.nativeData.addData((ICommonNativeData)data);
        }
    }

    private void handleEnvironmentAttributes(Attributes attributes) {
        String value;
        String name;
        boolean hasErrors = false;
        if (!this.isTopLevelElement()) {
            this.reporter.unexpectedElement("environment", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "environment", new String[]{"name", "value", "append", "prepend", "context"})) {
            hasErrors = true;
        }
        if ((name = attributes.getValue("name")) == null) {
            this.reporter.checkRequiredAttribute("environment", "name", null);
            hasErrors = true;
        }
        if ((value = attributes.getValue("value")) == null) {
            this.reporter.checkRequiredAttribute("environment", "value", null);
            hasErrors = true;
        }
        String appendStr = attributes.getValue("append");
        boolean append = false;
        if (appendStr != null) {
            append = this.isAttributeTrue(appendStr);
        }
        String prependStr = attributes.getValue("prepend");
        boolean prepend = false;
        if (prependStr != null) {
            prepend = this.isAttributeTrue(prependStr);
        }
        if (!hasErrors) {
            EnvironmentNativeData data = new EnvironmentNativeData(name, value, append, prepend, CicCommonSettings.getAccessRightsMode().isAdminMode());
            this.nativeData.addData((ICommonNativeData)data);
        }
    }

    private void handleDelayedProcessing(Attributes attributes) {
        String file_name;
        boolean hasErrors = false;
        if (!this.isZipSubElement()) {
            this.reporter.unexpectedElement("delayedProcessing", attributes);
            hasErrors = true;
        }
        if (this.hasUnexpectedAttributes(attributes, "delayedProcessing", new String[]{"file"})) {
            hasErrors = true;
        }
        if ((file_name = attributes.getValue("file")) == null) {
            this.reporter.checkRequiredAttribute("delayedProcessing", "file", null);
            hasErrors = true;
        }
        if (!hasErrors) {
            DelayedProcessingNativeData data = new DelayedProcessingNativeData(file_name);
            ICommonNativeData parent = this.elemStack.top((int)-1).data;
            if (parent != null) {
                parent.addChild((ICommonNativeData)data);
            }
            this.elemStack.top().data = data;
        }
    }

    private boolean isRegistrySubElement() {
        ICommonNativeAdapterDataParser.ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("registry") || entry.name.equals("key");
    }

    private boolean isZipSubElement() {
        ICommonNativeAdapterDataParser.ElemStackEntry entry = this.elemStack.top(-1);
        if (entry == null) {
            return false;
        }
        return entry.name.equals("zip");
    }
}

