/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.eclipse.internals.update.configurator;

import com.ibm.cic.eclipse.internals.update.configurator.IPlatformConfiguration;
import com.ibm.cic.eclipse.internals.update.configurator.SiteEntry;
import com.ibm.cic.eclipse.internals.update.configurator.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Configuration
implements IConfigurationConstants {
    private final Map sites = new TreeMap();
    private Date date;
    private long lastModified;
    private URL url;
    private boolean transientConfig;
    private boolean isDirty;
    private Configuration linkedConfig;
    private URL associatedInstallURL;

    public Configuration() {
        this(new Date());
        this.isDirty = true;
    }

    public Configuration(Date date) {
        this.date = date;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void setLinkedConfig(Configuration linkedConfig) {
        SiteEntry[] linkedSites;
        this.linkedConfig = linkedConfig;
        SiteEntry[] siteEntryArray = linkedSites = linkedConfig.getSites();
        int n = linkedSites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry linkedSite = siteEntryArray[n2];
            linkedSite.setUpdateable(false);
            ++n2;
        }
    }

    public Configuration getLinkedConfig() {
        return this.linkedConfig;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void addSiteEntry(String url, SiteEntry site) {
        if (this.sites.get(url = Utils.canonicalizeURL(url)) == null && (this.linkedConfig == null || this.linkedConfig.sites.get(url) == null)) {
            site.setConfig(this);
            this.sites.put(url, site);
        }
    }

    public void removeSiteEntry(String url) {
        url = Utils.canonicalizeURL(url);
        this.sites.remove(url);
    }

    public SiteEntry getSiteEntry(String url) {
        SiteEntry site = (SiteEntry)this.sites.get(url = Utils.canonicalizeURL(url));
        if (site == null && this.linkedConfig != null) {
            site = this.linkedConfig.getSiteEntry(url);
        }
        return site;
    }

    public SiteEntry[] getSites() {
        if (this.linkedConfig == null) {
            return this.sites.values().toArray(new SiteEntry[this.sites.size()]);
        }
        ArrayList combinedSites = new ArrayList(this.sites.values());
        combinedSites.addAll(this.linkedConfig.sites.values());
        return combinedSites.toArray(new SiteEntry[combinedSites.size()]);
    }

    public Element toXML(Document doc) throws CoreException {
        try {
            SiteEntry[] list;
            Element configElement = doc.createElement("config");
            configElement.setAttribute("version", "3.0");
            configElement.setAttribute("date", String.valueOf(this.date.getTime()));
            String transitory = this.isTransient() ? "true" : "false";
            configElement.setAttribute("transient", transitory);
            if (this.linkedConfig != null) {
                configElement.setAttribute("shared_ur", Utils.makeRelative(this.getInstallURL(), this.linkedConfig.getURL()).toExternalForm());
            }
            SiteEntry[] siteEntryArray = list = this.sites.values().toArray(new SiteEntry[0]);
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                SiteEntry element = siteEntryArray[n2];
                if (this.linkedConfig == null || this.linkedConfig.getSiteEntry(element.getURL().toExternalForm()) == null) {
                    Element siteElement = element.toXML(doc);
                    configElement.appendChild(siteElement);
                }
                ++n2;
            }
            return configElement;
        }
        catch (Exception e) {
            throw Utils.newCoreException("", e);
        }
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void setTransient(boolean isTransient) {
        this.transientConfig = isTransient;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        SiteEntry[] sites;
        SiteEntry[] siteEntryArray = sites = this.getSites();
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            SiteEntry site = siteEntryArray[n2];
            if (site.unconfigureFeatureEntry(feature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long lastModified() {
        if (this.lastModified != 0L) {
            return this.lastModified;
        }
        return this.date.getTime();
    }

    public URL getInstallURL() {
        return this.associatedInstallURL;
    }

    public void setInstallLocation(URL installURL) {
        this.associatedInstallURL = installURL;
    }
}

