/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SubjectInfoAccessExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.SubjectInfoAccess";
    public static final String NAME = "SubjectInfoAccess";
    public static final String DESCRIPTIONS = "descriptions";
    private List<AccessDescription> accessDescriptions;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SubjectInfoAccessExtension";

    public SubjectInfoAccessExtension(List<AccessDescription> accessDescriptions) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectInfoAccessExtension", accessDescriptions);
        }
        this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
        this.critical = false;
        this.accessDescriptions = accessDescriptions;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "SubjectInfoAccessExtension");
        }
    }

    public SubjectInfoAccessExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectInfoAccessExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectInfoAccessExtension", "Invalid encoding for SubjectInfoAccessExtension.");
            }
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectInfoAccessExtension", "Invalid encoding for SubjectInfoAccessExtension.");
            }
            throw new IOException("Invalid encoding for SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        while (val.getData().available() != 0) {
            DerValue seq = val.getData().getDerValue();
            AccessDescription accessDescription = new AccessDescription(seq);
            this.accessDescriptions.add(accessDescription);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectInfoAccessExtension");
        }
    }

    public List<AccessDescription> getAccessDescriptions() {
        if (debug != null) {
            debug.entry(16384L, className, "getAccessDescriptions");
            debug.exit(16384L, (Object)className, "getAccessDescriptions", this.accessDescriptions);
        }
        return this.accessDescriptions;
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectInfoAccess_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(DESCRIPTIONS)) {
            if (!(obj instanceof List)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type List.");
                }
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:SubjectInfoAccessExtension.");
            }
            throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = (List)obj;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(DESCRIPTIONS)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", DESCRIPTIONS);
            }
            return this.accessDescriptions;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get_2", DESCRIPTIONS);
        }
        throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(DESCRIPTIONS)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:SubjectInfoAccessExtension.");
            }
            throw new IOException("Attribute name [" + name + "] not recognized by " + "CertAttrSet:SubjectInfoAccessExtension.");
        }
        this.accessDescriptions = new ArrayList<AccessDescription>();
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DESCRIPTIONS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.accessDescriptions.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream ads = new DerOutputStream();
            for (AccessDescription accessDescription : this.accessDescriptions) {
                accessDescription.encode(ads);
            }
            DerOutputStream seq = new DerOutputStream();
            seq.write((byte)48, ads);
            this.extensionValue = seq.toByteArray();
        }
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString() + "SubjectInfoAccess [\n  " + this.accessDescriptions + "\n]\n");
        }
        return super.toString() + "SubjectInfoAccess [\n  " + this.accessDescriptions + "\n]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }
}

