/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.Attribute;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class SubjectDirectoryAttributesExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.SubjectDirectoryAttributes";
    public static final String NAME = "SubjectDirectoryAttributes";
    public static final String NUMBER = "value";
    Attribute[] attributes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.SubjectDirectoryAttributesExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.attributes == null || this.attributes.length == 0) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].encode(bytes);
        }
        os.write((byte)48, bytes);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public SubjectDirectoryAttributesExtension(Attribute[] attribs) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SubjectDirectoryAttributesExtension", attribs);
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        if (attribs == null || attribs.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectDirectoryAttributesExtension", "attribs is null or empty");
            }
            throw new IllegalArgumentException("attribs is null or empty");
        }
        this.attributes = new Attribute[attribs.length];
        for (int i = 0; i < attribs.length; ++i) {
            this.attributes[i] = new Attribute(attribs[i].getOID(), attribs[i].getDerValue());
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    public SubjectDirectoryAttributesExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectDirectoryAttributesExtension");
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        this.attributes = null;
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    public SubjectDirectoryAttributesExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "SubjectDirectoryAttributesExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "SubjectDirectoryAttributesExtension", "SubjectDirectoryAttributes: Illegal argument type");
            }
            throw new IOException("SubjectDirectoryAttributes: Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerInputStream derIn = new DerInputStream(extValue);
        DerValue[] elems = derIn.getSequence(1);
        this.attributes = new Attribute[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            DerOutputStream out = new DerOutputStream();
            elems[i].encode(out);
            DerInputStream derin = new DerInputStream(out.toByteArray());
            this.attributes[i] = new Attribute(derin);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SubjectDirectoryAttributesExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.attributes == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        String s = super.toString() + "SubjectDirectoryAttributes[" + this.attributes.length + "] [\r\n";
        for (int i = 0; i < this.attributes.length; ++i) {
            s = s + "#" + i + this.attributes[i].toString();
        }
        s = s + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof Attribute[])) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Attribute[].");
                }
                throw new IOException("Attribute value should be of type Attribute[].");
            }
            Attribute[] attribs = (Attribute[])obj;
            if (attribs == null || attribs.length == 0) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "obj Attribute[] is null or is empty");
                }
                throw new IllegalArgumentException("obj Attribute[] is null or is empty");
            }
            this.attributes = new Attribute[attribs.length];
            for (int i = 0; i < attribs.length; ++i) {
                this.attributes[i] = new Attribute(attribs[i].getOID(), attribs[i].getDerValue());
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.attributes == null || this.attributes.length == 0) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            Attribute[] attribs = new Attribute[this.attributes.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = new Attribute(this.attributes[i].getOID(), this.attributes[i].getDerValue());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", attribs);
            }
            return attribs;
        }
        if (debug != null) {
            debug.text(16384L, className, "get_2", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
        }
        this.attributes = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

