/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class PolicyConstraintsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyConstraints";
    public static final String NAME = "PolicyConstraints";
    public static final String REQUIRE = "require";
    public static final String INHIBIT = "inhibit";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyConstraintsExtension";

    private void encodeThis() throws IOException {
        DerOutputStream tmp;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.require == -1 && this.inhibit == -1) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream tagged = new DerOutputStream();
        DerOutputStream seq = new DerOutputStream();
        if (this.require != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(BigInteger.valueOf(this.require));
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.inhibit != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(BigInteger.valueOf(this.inhibit));
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PolicyConstraintsExtension(int require, int inhibit) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyConstraintsExtension", new Integer(require), new Integer(inhibit));
        }
        this.require = require;
        this.inhibit = inhibit;
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyConstraintsExtension");
        }
    }

    public PolicyConstraintsExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyConstraintsExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Illegal argument type");
            }
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Sequence tag missing for PolicyConstraint.");
            }
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream in = val.getData();
        while (in != null && in.available() != 0) {
            DerValue next = in.getDerValue();
            if (next.isContextSpecific((byte)0) && !next.isConstructed()) {
                if (this.require != -1) {
                    if (debug != null) {
                        debug.text(16384L, className, "PolicyConstraintsExtension", "Duplicate requireExplicitPolicy found in the PolicyConstraintsExtension");
                    }
                    throw new IOException("Duplicate requireExplicitPolicyfound in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.require = next.getInteger().intValue();
                continue;
            }
            if (next.isContextSpecific((byte)1) && !next.isConstructed()) {
                if (this.inhibit != -1) {
                    if (debug != null) {
                        debug.text(16384L, className, "PolicyConstraintsExtension", "Duplicate inhibitPolicyMapping found in the PolicyConstraintsExtension");
                    }
                    throw new IOException("Duplicate inhibitPolicyMappingfound in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.inhibit = next.getInteger().intValue();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "PolicyConstraintsExtension", "Invalid encoding of PolicyConstraint");
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyConstraintsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "PolicyConstraints: [" + "  Require: ";
        s = this.require == -1 ? s + "unspecified;" : s + this.require + ";";
        s = s + "\tInhibit: ";
        s = this.inhibit == -1 ? s + "unspecified" : s + this.inhibit;
        s = s + " ]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyConstraints_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (!(obj instanceof Integer)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute value should be of type Integer.");
            }
            throw new IOException("Attribute value should be of type Integer.");
        }
        if (name.equalsIgnoreCase(REQUIRE)) {
            this.require = (Integer)obj;
        } else if (name.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = (Integer)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name [" + name + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
            }
            throw new IOException("Attribute name [" + name + "]" + " not recognized by " + "CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(REQUIRE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Integer(this.require));
            }
            return new Integer(this.require);
        }
        if (name.equalsIgnoreCase(INHIBIT)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Integer(this.inhibit));
            }
            return new Integer(this.inhibit);
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(REQUIRE)) {
            this.require = -1;
        } else if (name.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = -1;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PolicyConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(REQUIRE);
        elements.addElement(INHIBIT);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

