/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.SMIME;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMIMEMimeMessage
extends MimeMessage {
    private byte[] messageContent;
    ContentInfo contentInfo;
    CertificationRequest certificationRequest;
    private Certificate[] recipientCerts;
    private String provider = null;
    private boolean oldTypes = true;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEMimeMessage";

    protected SMIMEMimeMessage(Folder folder, InputStream is, int msgnum) throws MessagingException {
        super(folder, is, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, is, new Integer(msgnum)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InputStream is, int msgnum, String provider) throws MessagingException {
        super(folder, is, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, is, new Integer(msgnum), provider};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, int msgnum) throws MessagingException {
        super(folder, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, new Integer(msgnum)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, int msgnum, String provider) throws MessagingException {
        super(folder, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, new Integer(msgnum), provider};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InternetHeaders headers, byte[] content, int msgnum) throws MessagingException {
        super(folder, headers, content, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, headers, content, new Integer(msgnum)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InternetHeaders headers, byte[] content, int msgnum, String provider) throws MessagingException {
        super(folder, headers, content, msgnum);
        if (debug != null) {
            Object[] parms = new Object[]{folder, headers, content, new Integer(msgnum), provider};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session) {
        super(session);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", session);
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, String provider) {
        super(session);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMessage", session, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, InputStream is) throws MessagingException {
        super(session, is);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMessage", session, is);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, InputStream is, String provider) throws MessagingException {
        super(session, is);
        if (debug != null) {
            Object[] parms = new Object[]{session, is, provider};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", parms);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public boolean isSignedDataSignatureOnly() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedDataSignatureOnly");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String basetype = contentType.getBaseType();
            String protocol = contentType.getParameter("protocol");
            if (basetype == null || protocol == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_1", false);
                }
                return false;
            }
            if (basetype.equalsIgnoreCase("multipart/signed") && (protocol.equalsIgnoreCase("application/x-pkcs7-signature") || protocol.equalsIgnoreCase("application/pkcs7-signature"))) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_3", false);
            }
            return false;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedDataSignatureOnly", e);
                debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_4", false);
            }
            return false;
        }
    }

    public boolean isSignedDataCertificateOnly() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedDataCertificateOnly");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String basetype = contentType.getBaseType();
            String smimetype = contentType.getParameter("smime-type");
            if (basetype == null || smimetype == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_1", false);
                }
                return false;
            }
            if ((basetype.equalsIgnoreCase("application/x-pkcs7-mime") || basetype.equalsIgnoreCase("application/pkcs7-mime")) && smimetype.equalsIgnoreCase("certs-only")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_3", false);
            }
            return false;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedDataCertificateOnly", e);
                debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_4", false);
            }
            return false;
        }
    }

    public boolean isSignedData() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedData");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String basetype = contentType.getBaseType();
            String smimetype = contentType.getParameter("smime-type");
            if (basetype == null || smimetype == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedData_1", false);
                }
                return false;
            }
            if ((basetype.equalsIgnoreCase("application/x-pkcs7-mime") || basetype.equalsIgnoreCase("application/pkcs7-mime")) && smimetype.equalsIgnoreCase("signed-data")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedData_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedData_3", false);
            }
            return false;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedData", e);
                debug.exit(16384L, (Object)className, "isSignedData_4", false);
            }
            return false;
        }
    }

    public boolean isEnvelopedData() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isEnvelopedData");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String basetype = contentType.getBaseType();
            String smimetype = contentType.getParameter("smime-type");
            if (basetype == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isEnvelopedData_1", false);
                }
                return false;
            }
            if ((basetype.equalsIgnoreCase("application/x-pkcs7-mime") || basetype.equalsIgnoreCase("application/pkcs7-mime")) && smimetype == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isEnvelopedData_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isEnvelopedData_3", false);
            }
            return false;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "isEnvelopedData", e);
                debug.exit(16384L, (Object)className, "isEnvelopedData", false);
            }
            return false;
        }
    }

    public boolean isCertificationRequest() {
        try {
            ContentType contentType;
            String basetype;
            if (debug != null) {
                debug.entry(16384L, className, "isCertificationRequest");
            }
            if ((basetype = (contentType = new ContentType(this.getContentType())).getBaseType()) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isCertificationRequest_1", false);
                }
                return false;
            }
            if (basetype.equalsIgnoreCase("application/x-pkcs10") || basetype.equalsIgnoreCase("application/pkcs10")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isCertificationRequest_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isCertificationRequest_3", false);
            }
            return false;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "isCertificationRequest", e);
                debug.exit(16384L, (Object)className, "isCertificationRequest_4", false);
            }
            return false;
        }
    }

    private void checkContainedObjects() throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "checkContainedObjects");
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "checkContainedObjects", "ContentInfo object already set for this SMIMEMimeMessage object.");
            }
            throw new PKCSException("ContentInfo object already set for this SMIMEMimeMessage object.");
        }
        if (this.certificationRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "checkContainedObjects", "CertificationRequest object already set for this SMIMEMimeMessage object.");
            }
            throw new PKCSException("CertificationRequest object already set for this SMIMEMimeMessage object.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "checkContainedObjects");
        }
    }

    public void setSMIMEContentType(boolean old) {
        this.oldTypes = old;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public void setCertificationRequest(CertificationRequest certRequest) throws MessagingException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificationRequest", certRequest);
        }
        this.checkContainedObjects();
        if (certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certificationRequest = certRequest;
        String contentType = SMIMEUtils.getContentType(certRequest, this.oldTypes);
        String disposition = SMIMEUtils.getDisposition(certRequest);
        this.setContent(this.certificationRequest, contentType);
        this.setDisposition(disposition);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificationRequest");
        }
    }

    private void addRecipientCertificate(Certificate cert) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addRecipientCertificate", cert);
        }
        if (cert == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[1];
            this.recipientCerts[0] = cert;
        } else {
            int len = this.recipientCerts.length;
            Certificate[] newcerts = new Certificate[len + 1];
            for (int i = 0; i < len; ++i) {
                newcerts[i] = this.recipientCerts[i];
            }
            newcerts[len] = cert;
            this.recipientCerts = newcerts;
        }
        if (debug != null) {
            debug.exit(8192L, className, "addRecipientCertificate_2");
        }
    }

    public void addRecipientCertificate(Certificate[] certs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipientCertificate", certs);
        }
        if (certs == null || certs.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                this.recipientCerts[i] = certs[i];
            }
        } else {
            int i;
            int len = this.recipientCerts.length;
            Certificate[] newcerts = new Certificate[len + certs.length];
            for (i = 0; i < len; ++i) {
                newcerts[i] = this.recipientCerts[i];
            }
            for (i = 0; i < certs.length; ++i) {
                newcerts[len + i] = certs[i];
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipientCertificate_2");
        }
    }

    private void setRecipientCertificate(Certificate cert) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setRecipientCertificate", cert);
        }
        if (cert == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(8192L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(cert);
        if (debug != null) {
            debug.exit(8192L, className, "setRecipientCertificate_2");
        }
    }

    public void setRecipientCertificate(Certificate[] certs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRecipientCertificate", certs);
        }
        if (certs == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(16384L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certs);
        if (debug != null) {
            debug.exit(16384L, className, "setRecipientCertificate_2");
        }
    }

    public void setCertificateOnly(Certificate[] certs) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificateOnly", certs);
        }
        this.checkContainedObjects();
        if (certs == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (certs.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificate array is empty.");
            }
            throw new IllegalArgumentException("Certificate array is empty.");
        }
        SignedData sd = new SignedData(certs, null, this.provider);
        this.contentInfo = new ContentInfo(sd, this.provider);
        String contentType = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String disposition = SMIMEUtils.getDisposition(this.contentInfo);
        this.setContent(this.contentInfo, contentType);
        this.setDisposition(disposition);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificateOnly");
        }
    }

    public void sign(Object message, Certificate signerCert, PrivateKey privateKey, String digestSignatureAlgorithm) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            Object[] parms = new Object[]{message, signerCert, privateKey, digestSignatureAlgorithm};
            debug.entry(16384L, (Object)className, "sign", parms);
        }
        this.checkContainedObjects();
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        byte[] tobesignedBytes = null;
        if (message instanceof String) {
            try {
                tobesignedBytes = ((String)message).getBytes("8859_1");
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "sign", e);
                }
                tobesignedBytes = ((String)message).getBytes();
            }
        } else if (message instanceof byte[]) {
            tobesignedBytes = (byte[])((byte[])message).clone();
        } else if (message instanceof Data) {
            tobesignedBytes = ((Data)message).getData();
        } else if (message instanceof Multipart) {
            Multipart multi = (Multipart)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            multi.writeTo((OutputStream)baos);
            tobesignedBytes = baos.toByteArray();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
            }
            throw new IllegalArgumentException("Message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
        }
        this.messageContent = tobesignedBytes;
        Data data = new Data(this.provider);
        data.setData(tobesignedBytes);
        ContentInfo ci = new ContentInfo(data, this.provider);
        boolean signatureOnly = false;
        SignedData sd = new SignedData(signerCert, ci, digestSignatureAlgorithm, privateKey, signatureOnly, this.provider);
        this.contentInfo = new ContentInfo(sd, this.provider);
        String contentType = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String disposition = SMIMEUtils.getDisposition(this.contentInfo);
        this.setContent(this.contentInfo, contentType);
        this.setDisposition(disposition);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void encrypt(Object message, int encryptionStrength) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", message, new Integer(encryptionStrength));
        }
        String encryptionAlgorithm = SMIME.getEncryptionAlgorithm(encryptionStrength);
        int keySize = SMIME.getEncryptionKeySize(encryptionStrength);
        this.encrypt(message, encryptionAlgorithm, keySize);
        if (debug != null) {
            debug.exit(16384L, className, "encrypt");
        }
    }

    public void encrypt(Object message, String encryptionAlgorithm, int keySize) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        String contentType;
        ByteArrayOutputStream baos;
        if (debug != null) {
            Object[] parms = new Object[]{message, encryptionAlgorithm, new Integer(keySize)};
            debug.entry(16384L, (Object)className, "encrypt", parms);
        }
        this.checkContainedObjects();
        if (encryptionAlgorithm == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "encryptionAlgorithm not specified.");
            }
            throw new IllegalArgumentException("encryptionAlgorithm not specified.");
        }
        if (message == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (this.recipientCerts == null || this.recipientCerts.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "One or more recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more recipient certificates must be specified.");
        }
        byte[] contentBytes = null;
        if (message instanceof String) {
            String pszMessage = (String)message;
            MimeBodyPart part1 = new MimeBodyPart();
            part1.setText(pszMessage);
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            part1.writeTo((OutputStream)baos2);
            contentBytes = baos2.toByteArray();
        } else if (message instanceof Multipart) {
            Multipart multi = (Multipart)message;
            baos = new ByteArrayOutputStream();
            contentType = "Content-Type: " + multi.getContentType() + "\r\n\r\n";
            try {
                baos.write(contentType.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                if (debug != null) {
                    debug.exception(16384L, className, "encrypt", e);
                }
                baos.write(contentType.getBytes());
            }
            multi.writeTo((OutputStream)baos);
            contentBytes = baos.toByteArray();
        } else if (message instanceof SMIMEMimeMessage) {
            SMIMEMimeMessage tempSMIME = (SMIMEMimeMessage)((Object)message);
            if (!tempSMIME.isSignedData()) {
                if (debug != null) {
                    debug.text(16384L, className, "encrypt", "SMIMEMimeMessage must be of type SignedData");
                }
                throw new PKCSException("SMIMEMimeMessage must be of type SignedData");
            }
            baos = new ByteArrayOutputStream();
            tempSMIME.writeTo(baos);
            contentBytes = baos.toByteArray();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
            }
            throw new IllegalArgumentException("message must be an instance of String or Multipart.  Instead message is an instance of " + message.getClass().getName());
        }
        this.messageContent = contentBytes;
        Data data = new Data(this.provider);
        data.setData(contentBytes);
        ContentInfo ci = new ContentInfo(data, this.provider);
        this.contentInfo = ci.encrypt(this.recipientCerts, encryptionAlgorithm, keySize);
        contentType = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String disposition = SMIMEUtils.getDisposition(this.contentInfo);
        String description = SMIMEUtils.getDescription(this.contentInfo);
        this.setContent(this.contentInfo, contentType);
        this.setDisposition(disposition);
        this.setDescription(description);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "encrypt");
        }
    }

    public boolean verify(Certificate signerCert) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", signerCert);
            debug.exit(16384L, (Object)className, "verify", this.verify(signerCert, null));
        }
        return this.verify(signerCert, null);
    }

    public boolean verify(Certificate signerCert, byte[] msg) throws PKCSException, IOException, NoSuchAlgorithmException {
        byte[] tobeverified = null;
        if (debug != null) {
            debug.entry(16384L, className, "verify", signerCert, msg);
        }
        if (this.isSignedDataSignatureOnly()) {
            tobeverified = msg == null ? this.getSignatureOnlyMessage() : (byte[])msg.clone();
            ContentInfo ci = this.getSignatureOnlyContentInfo();
            SignedData sd = (SignedData)ci.getContent();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", sd.verify(signerCert, tobeverified));
            }
            return sd.verify(signerCert, tobeverified);
        }
        if (this.isSignedData()) {
            if (this.contentInfo == null) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "SMIMEMimeMessage does not contain a contentInfo to verify.");
                }
                throw new PKCSException("SMIMEMimeMessage does not contain a contentInfo to verify.");
            }
            if (!this.contentInfo.isSignedData()) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "SMIMEMimeMessage contentInfo is not of type SignedData.");
                }
                throw new PKCSException("SMIMEMimeMessage contentInfo is not of type SignedData.");
            }
            if (msg == null && this.messageContent != null) {
                tobeverified = this.messageContent;
            } else if (msg != null) {
                tobeverified = (byte[])msg.clone();
            }
            SignedData sd = (SignedData)this.contentInfo.getContent();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_2", sd.verify(signerCert, tobeverified));
            }
            return sd.verify(signerCert, tobeverified);
        }
        if (debug != null) {
            debug.text(16384L, className, "verify_2", "SMIMEMimeMessage is not of type signed-data or signed/multipart");
        }
        throw new PKCSException("SMIMEMimeMessage is not of type signed-data or signed/multipart");
    }

    public ContentInfo decrypt(PrivateKey recipientPrivateKey, Certificate recipientCert) throws IOException, PKCSException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, className, "decrypt", recipientPrivateKey, recipientCert);
        }
        if (recipientPrivateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "recipientPrivateKey not specified.");
            }
            throw new IllegalArgumentException("recipientPrivateKey not specified.");
        }
        if (recipientCert == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "recipientCert not specified.");
            }
            throw new IllegalArgumentException("recipientCert not specified.");
        }
        if (!this.isEnvelopedData()) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "SMIMEMimeMessage is not of type enveloped-data");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type enveloped-data");
        }
        ContentInfo ci = (ContentInfo)this.getContent();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", ci.decrypt(recipientPrivateKey, recipientCert));
        }
        return ci.decrypt(recipientPrivateKey, recipientCert);
    }

    private byte[] getSignatureOnlyMessage() throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureOnlyMessage");
        }
        if (!this.isSignedDataSignatureOnly()) {
            if (debug != null) {
                debug.entry(8192L, (Object)className, "getSignatureOnlyMessage", "SMIMEMimeMessage is not of type signature-only SignedData.");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type signature-only SignedData.");
        }
        try {
            Object msgcontent = this.getContent();
            if (msgcontent instanceof MimeMultipart) {
                MimeMultipart mpart = (MimeMultipart)msgcontent;
                int count = mpart.getCount();
                if (count == 2) {
                    MimeBodyPart mbodypart = (MimeBodyPart)mpart.getBodyPart(0);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    mbodypart.writeTo((OutputStream)baos);
                    byte[] retval = baos.toByteArray();
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getSignatureOnlyMessage", retval);
                    }
                    return retval;
                }
                if (debug != null) {
                    debug.text(8192L, className, "getSignatureOnlyMessage", "SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
                }
                throw new PKCSException("SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
            }
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyMessage", "SMIMEMimeMessage does not contain a MimeMultipart object.");
            }
            throw new PKCSException("SMIMEMimeMessage does not contain a MimeMultipart object.");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureOnlyMessage", e);
            }
            throw new PKCSException(e, e.toString());
        }
    }

    private ContentInfo getSignatureOnlyContentInfo() throws PKCSException {
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureOnlyContentInfo");
        }
        if (!this.isSignedDataSignatureOnly()) {
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage is not of type signature-only SignedData.");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type signature-only SignedData.");
        }
        try {
            Object msgcontent = this.getContent();
            if (msgcontent instanceof MimeMultipart) {
                MimeMultipart mpart = (MimeMultipart)msgcontent;
                int count = mpart.getCount();
                if (count == 2) {
                    MimeBodyPart mbodypart = (MimeBodyPart)mpart.getBodyPart(1);
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getSignatureOnlyContentInfo", (ContentInfo)mbodypart.getContent());
                    }
                    return (ContentInfo)mbodypart.getContent();
                }
                if (debug != null) {
                    debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
                }
                throw new PKCSException("SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
            }
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage does not contain a MimeMultipart object.");
            }
            throw new PKCSException("SMIMEMimeMessage does not contain a MimeMultipart object.");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureOnlyContentInfo", e);
            }
            throw new PKCSException(e, e.toString());
        }
    }

    private void setContainedObjects() throws MessagingException {
        try {
            Object msgcontent;
            if (debug != null) {
                debug.entry(8192L, className, "setContainedObjects");
            }
            if ((msgcontent = this.getContent()) != null) {
                if (msgcontent instanceof ContentInfo) {
                    this.contentInfo = (ContentInfo)msgcontent;
                } else if (msgcontent instanceof CertificationRequest) {
                    this.certificationRequest = (CertificationRequest)msgcontent;
                }
            }
            if (this.isSignedDataSignatureOnly() && msgcontent instanceof MimeMultipart) {
                MimeMultipart mpart = (MimeMultipart)msgcontent;
                MimeBodyPart mbodypart = (MimeBodyPart)mpart.getBodyPart(0);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                mbodypart.writeTo((OutputStream)baos);
                this.messageContent = baos.toByteArray();
            }
            if (debug != null) {
                debug.exit(8192L, className, "setContainedObjects");
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(8192L, className, "setContainedObjects", e);
            }
            e.printStackTrace();
            throw new MessagingException(e.toString());
        }
    }

    private void debugContainedObjects() throws MessagingException {
        try {
            if (debug != null) {
                debug.entry(8192L, className, "debugContainedObjects");
            }
            Object msgcontent = this.getContent();
            ContentType contentType = new ContentType(this.getContentType());
            if (debug != null) {
                debug.exit(8192L, className, "debugContainedObjects");
            }
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(8192L, className, "debugContainedObjects", e);
            }
            throw new MessagingException(e.toString());
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if (this.certificationRequest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", this.certificationRequest);
        }
        return this.certificationRequest;
    }

    byte[] getContentBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentBytes");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentBytes_2", (byte[])this.content.clone());
        }
        return (byte[])this.content.clone();
    }

    public String toString() {
        String out = "SMIMEMimeMessage:  ";
        String unknown = "PKCS #7 or #10 message type not set or unknown.";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = this.isSignedData() ? out + "PKCS #7 SignedData message." : (this.isSignedDataSignatureOnly() ? out + "PKCS #7 SignedData signature-only message." : (this.isSignedDataCertificateOnly() ? out + "PKCS #7 SignedData certificate-only message." : (this.isEnvelopedData() ? out + "PKCS #7 EnvelopedData message." : (this.isCertificationRequest() ? out + "PKCS #10 CertificationRequest message." : out + unknown))));
        out = this.contentInfo != null ? out + "\r\n\tContains a ContentInfo object of type " + this.contentInfo.getContentTypeString() + "." : (this.certificationRequest != null ? out + "\r\n\tContains a CertificationRequest object." : out + "\r\n\tDoes not contain a ContentInfo or CertificationRequest object.");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

