/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class IOUtils {
    public static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
        int cc;
        byte[] output = new byte[]{};
        if (length == -1) {
            length = Integer.MAX_VALUE;
        }
        for (int pos = 0; pos < length; pos += cc) {
            int bytesToRead;
            if (pos >= output.length) {
                bytesToRead = Math.min(length - pos, output.length + 1024);
                if (output.length < pos + bytesToRead) {
                    output = Arrays.copyOf(output, pos + bytesToRead);
                }
            } else {
                bytesToRead = output.length - pos;
            }
            if ((cc = is.read(output, pos, bytesToRead)) >= 0) continue;
            if (readAll && length != Integer.MAX_VALUE) {
                throw new EOFException("Detect premature EOF");
            }
            if (output.length == pos) break;
            output = Arrays.copyOf(output, pos);
            break;
        }
        return output;
    }
}

