/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.preferences;

import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsProxy;
import com.ibm.cic.agent.internal.console.preferences.ConPagePrefsBase;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPagePrefsProxy
extends ConPagePrefsBase {
    private ConViewStatus m_statusView;
    private ConViewGroup m_httpGroup;
    private ConViewGroup m_ftpGroup;
    private ConDataCtxtPrefsProxy m_dataCtxtProxy;

    public ConPagePrefsProxy(IConManager manager) {
        super(manager);
    }

    @Override
    protected ConDataCtxtPrefsBase initializeDataContext() {
        this.m_dataCtxtProxy = (ConDataCtxtPrefsProxy)this.conManager().getDataContext(ConDataCtxtPrefsProxy.class);
        return this.m_dataCtxtProxy;
    }

    @Override
    public void init() {
        this.setHeaderView(Messages.PagePreference_Proxy);
        this.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Proxy_Http) + ": " + NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_description, (Object)"HTTP")));
        this.addView((IConView)new ConViewText(""));
        this.m_httpGroup = new ConViewGroup();
        this.m_httpGroup.init();
        this.addView((IConView)this.m_httpGroup);
        this.addView((IConView)new ConViewText(""));
        this.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Proxy_Ftp) + ": " + NLS.bind((String)com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_description, (Object)"FTP")));
        this.addView((IConView)new ConViewText(""));
        this.m_ftpGroup = new ConViewGroup();
        this.m_ftpGroup.init();
        this.addView((IConView)this.m_ftpGroup);
        this.addView((IConView)new ConViewText(""));
        this.m_statusView = new ConViewStatus();
        this.addView((IConView)this.m_statusView);
        super.init();
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.m_statusView.setStatus(this.m_dataCtxtProxy.getValidationStatus());
        this.m_httpGroup.clear();
        int index = 1;
        ConViewListNumbered enableHttpProxy = new ConViewListNumbered(null, true, index++);
        enableHttpProxy.addEntry(ConDataCtxtPrefsProxy.m_enableHttpProxyTag.description(), (AConActionEntry)new ConActFlipEnableHttpProxy(), this.m_dataCtxtProxy.getEnableHttpProxy());
        enableHttpProxy.setNewLineAfterList(false);
        this.m_httpGroup.addView((IConView)enableHttpProxy);
        if (this.m_dataCtxtProxy.getEnableHttpProxy()) {
            ConViewListNumbered useHttpProxy = new ConViewListNumbered(null, true, index++, 1);
            useHttpProxy.addEntry(Messages.PagePreference_Proxy_UseHttpProxy, (AConActionEntry)new ConActionFlipUseSocks(), !this.m_dataCtxtProxy.getUseSocks());
            useHttpProxy.setNewLineAfterList(false);
            this.m_httpGroup.addView((IConView)useHttpProxy);
            if (!this.m_dataCtxtProxy.getUseSocks()) {
                this.m_httpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Proxy_Host) + " " + this.m_dataCtxtProxy.getProxyHost(), 4));
                this.m_httpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Proxy_Port) + " " + this.m_dataCtxtProxy.getProxyPort(), 4));
            }
            ConViewListNumbered useSocks = new ConViewListNumbered(null, true, index++, 1);
            useSocks.addEntry(Messages.PagePreference_Proxy_UseSocks, (AConActionEntry)new ConActionFlipUseSocks(), this.m_dataCtxtProxy.getUseSocks());
            useSocks.setNewLineAfterList(false);
            this.m_httpGroup.addView((IConView)useSocks);
            if (this.m_dataCtxtProxy.getUseSocks()) {
                this.m_httpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Socks_Host) + " " + this.m_dataCtxtProxy.getSocksHost(), 4));
                this.m_httpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Socks_Port) + " " + this.m_dataCtxtProxy.getSocksPort(), 4));
            }
        }
        this.m_ftpGroup.clear();
        ConViewListNumbered enableFtpProxy = new ConViewListNumbered(null, true, index++);
        enableFtpProxy.addEntry(ConDataCtxtPrefsProxy.m_enableFtpProxyTag.description(), (AConActionEntry)new ConActFlipEnableFtpProxy(), this.m_dataCtxtProxy.getEnableFtpProxy());
        enableFtpProxy.setNewLineAfterList(false);
        this.m_ftpGroup.addView((IConView)enableFtpProxy);
        if (this.m_dataCtxtProxy.getEnableFtpProxy()) {
            this.m_ftpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Socks_Host) + " " + this.m_dataCtxtProxy.getSocksHost(), 3));
            this.m_ftpGroup.addView((IConView)new ConViewText(String.valueOf(Messages.PagePreference_Socks_Port) + " " + this.m_dataCtxtProxy.getSocksPort(), 3));
        }
        if (this.m_dataCtxtProxy.getEnableHttpProxy() || this.m_dataCtxtProxy.getEnableFtpProxy()) {
            this.m_ftpGroup.addView((IConView)new ConViewText(""));
            ConViewList hostPortOptions = new ConViewList(Messages.General_OtherOptions, false);
            this.m_ftpGroup.addView((IConView)hostPortOptions);
            if (this.m_dataCtxtProxy.getEnableHttpProxy()) {
                if (!this.m_dataCtxtProxy.getUseSocks()) {
                    hostPortOptions.addEntry(Messages.PagePreference_Proxy_Host_Enter, "H", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Proxy_Host_Enter, (String)Messages.PagePreference_Proxy_Host_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setProxyHost(this.getInput());
                            return Status.OK_STATUS;
                        }
                    }));
                    hostPortOptions.addEntry(Messages.PagePreference_Proxy_Port_Enter, "O", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Proxy_Port_Enter, (String)Messages.PagePreference_Proxy_Port_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            String input = this.getInput();
                            int inputNum = -1;
                            try {
                                inputNum = Integer.valueOf(input);
                            }
                            catch (NumberFormatException numberFormatException) {
                                inputNum = -1;
                            }
                            if (inputNum < 0 || inputNum > 65535) {
                                return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_PortField_OutOfRangeError, new Object[0]);
                            }
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setProxyPort(input);
                            return Status.OK_STATUS;
                        }
                    }));
                } else {
                    hostPortOptions.addEntry(Messages.PagePreference_Socks_Host_Enter, "S", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Socks_Host_Enter, (String)Messages.PagePreference_Socks_Host_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setSocksHost(this.getInput());
                            return Status.OK_STATUS;
                        }
                    }));
                    hostPortOptions.addEntry(Messages.PagePreference_Socks_Port_Enter, "T", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Socks_Port_Enter, (String)Messages.PagePreference_Socks_Port_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            String input = this.getInput();
                            int inputNum = -1;
                            try {
                                inputNum = Integer.valueOf(input);
                            }
                            catch (NumberFormatException numberFormatException) {
                                inputNum = -1;
                            }
                            if (inputNum < 0 || inputNum > 65535) {
                                return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_PortField_OutOfRangeError, new Object[0]);
                            }
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setSocksPort(input);
                            return Status.OK_STATUS;
                        }
                    }));
                }
            }
            if (this.m_dataCtxtProxy.getEnableFtpProxy()) {
                ConViewList socksList = hostPortOptions;
                if (this.m_dataCtxtProxy.getEnableHttpProxy() && !this.m_dataCtxtProxy.getUseSocks()) {
                    socksList = new ConViewList(null, false);
                    this.m_ftpGroup.addView((IConView)socksList);
                }
                if (this.m_dataCtxtProxy.getEnableHttpProxy() && !this.m_dataCtxtProxy.getUseSocks() || !this.m_dataCtxtProxy.getEnableHttpProxy()) {
                    socksList.addEntry(Messages.PagePreference_Socks_Host_Enter, "S", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Socks_Host_Enter, (String)Messages.PagePreference_Socks_Host_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setSocksHost(this.getInput());
                            return Status.OK_STATUS;
                        }
                    }));
                    socksList.addEntry(Messages.PagePreference_Socks_Port_Enter, "T", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.PagePreference_Socks_Port_Enter, (String)Messages.PagePreference_Socks_Port_Des, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

                        protected IStatus processInput() {
                            String input = this.getInput();
                            int inputNum = -1;
                            try {
                                inputNum = Integer.valueOf(input);
                            }
                            catch (NumberFormatException numberFormatException) {
                                inputNum = -1;
                            }
                            if (inputNum < 0 || inputNum > 65535) {
                                return Statuses.ERROR.get(com.ibm.cic.common.core.sharedUI.Messages.ProxyPreferencePage_PortField_OutOfRangeError, new Object[0]);
                            }
                            ConPagePrefsProxy.this.m_dataCtxtProxy.setSocksPort(input);
                            return Status.OK_STATUS;
                        }
                    }));
                }
            }
        }
        super.present(a_output);
    }

    static class ConActFlipEnableFtpProxy
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipEnableFtpProxy() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsProxy context = (ConDataCtxtPrefsProxy)a_conManager.getDataContext(ConDataCtxtPrefsProxy.class);
            if (context.isPreferenceEditable()) {
                context.setEnableFtpProxy(!context.getEnableFtpProxy());
            }
            super.run(a_conManager);
        }
    }

    static class ConActFlipEnableHttpProxy
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipEnableHttpProxy() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsProxy context = (ConDataCtxtPrefsProxy)a_conManager.getDataContext(ConDataCtxtPrefsProxy.class);
            if (context.isPreferenceEditable()) {
                boolean enable = !context.getEnableHttpProxy();
                context.setEnableHttpProxy(enable);
            }
            super.run(a_conManager);
        }
    }

    static class ConActionFlipUseSocks
    extends AConActionEntry {
        ConActionFlipUseSocks() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsProxy context;
            context.setUseSocks(!(context = (ConDataCtxtPrefsProxy)a_conManager.getDataContext(ConDataCtxtPrefsProxy.class)).getUseSocks());
            super.run(a_conManager);
        }
    }
}

