/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.console.manager.licensePanel.AgentLicensePageData;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.console.ConUpdateAgentUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.actions.ConActionSetRestoreReboot;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.manager.JobListManager;
import com.ibm.cic.agent.internal.console.pages.AConPageAgentWizard;
import com.ibm.cic.agent.internal.console.pages.ConPageCustomPanelList;
import com.ibm.cic.agent.internal.console.pages.ConPageCustomPanels;
import com.ibm.cic.agent.internal.console.pages.ConPageFeatures;
import com.ibm.cic.agent.internal.console.pages.ConPageInst;
import com.ibm.cic.agent.internal.console.pages.ConPageInstCompletion;
import com.ibm.cic.agent.internal.console.pages.ConPageInstFix;
import com.ibm.cic.agent.internal.console.pages.ConPageInstInstallLocation;
import com.ibm.cic.agent.internal.console.pages.ConPageInstSharedResourceLocation;
import com.ibm.cic.agent.internal.console.pages.ConPageInstSummary;
import com.ibm.cic.agent.internal.console.pages.ConPageLocaleLangs;
import com.ibm.cic.agent.internal.console.pages.ConPagePreChecks;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.shared.pages.licensePanel.ConLicensePage;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPageWizInstall
extends AConPageAgentWizard {
    public ConPageWizInstall(IConManager manager) {
        super(manager);
        this.setFinishButtonKeyName(new String[]{"I"}, Messages.WizardInstall_InstallBtn);
    }

    @Override
    protected ConDataCtxtInst getContext() {
        return (ConDataCtxtInst)super.getContext();
    }

    public void init() {
        this.setContext(new ConDataCtxtInst(this.conManager()));
        this.conManager().setDataContext((IConDataCtxt)this.getContext());
        AgentInput agentInput = AgentInput.getInstance();
        if (agentInput.getMode() == 1) {
            this.getContext().setAvailableJobs(agentInput.getWizardJobs());
            this.getContext().getSelectedJobs().resetChanged();
        }
        this.addPage(new ConPageInst(this.conManager()));
        this.addPage(new ConPageInstFix(this.conManager()));
        this.addPage(new ConPagePreChecks(this.conManager()));
        this.addPage((AConPage)new ConLicensePage(this.conManager(), new ConLicensePage.Parameters(this.getCancelAction(), AgentLicensePageData.getDeclinedMessage())));
        this.addPage(new ConPageInstSharedResourceLocation(this.conManager()));
        this.addPage(new ConPageInstInstallLocation(this.conManager()));
        this.addPage(new ConPageLocaleLangs(this.conManager()));
        this.addPage(new ConPageFeatures(this.conManager()));
        this.addPage(new ConPageCustomPanelList(this.conManager(), this, WizardType.INSTALL));
        this.addPage(new ConPageCustomPanels(this.conManager(), WizardType.INSTALL));
        this.addPage(new ConPageInstSummary(this.conManager()));
        super.init();
    }

    protected AConActionEntry getFinishAction() {
        return new ConActionDoInstallPackages();
    }

    @Override
    protected IStatus checkForAgentUpdate(boolean[] installNewerIM, IProgressMonitor monitor) {
        AbstractJob selectedAgentJob = this.getSelectedAgentJob();
        if (selectedAgentJob == null) {
            return super.checkForAgentUpdate(installNewerIM, monitor);
        }
        installNewerIM[0] = false;
        AbstractJob[] updateAgentJob = new AbstractJob[1];
        IStatus status = ConUpdateAgentUtils.checkForNewerVersionAgent(this.conManager(), selectedAgentJob, updateAgentJob, monitor);
        if (updateAgentJob[0] != null) {
            if (status.isOK()) {
                installNewerIM[0] = true;
                this.getContext().removeAllSelectedJobs();
                this.getContext().setAvailableJobs(updateAgentJob);
            } else if (status.getCode() == -50) {
                status = Statuses.ST.createMultiStatusWithChild(Status.CANCEL_STATUS, null, new Object[0]);
            }
        }
        return status;
    }

    private AbstractJob getSelectedAgentJob() {
        JobListManager<InstallJob> jobs = this.getContext().getSelectedJobs();
        InstallJob selectedAgentJob = jobs.getSelectedAgentJob();
        if (selectedAgentJob != null) {
            return selectedAgentJob;
        }
        if (AgentInput.getInstance().getMode() == 1 && AgentInstall.getInstance().isAgentInstallerRunning()) {
            InstallJob job = new InstallJob((IOfferingOrFix)Agent.getInstance().getAgentOffering());
            job.setProfile(Agent.getInstance().getAgentProfile());
            job.setSelected(true);
            return job;
        }
        return null;
    }

    public boolean checkForAgentUpdateInWizardModeIfPrefSet() {
        if (AgentInput.getInstance().getMode() != 1 || !Agent.getInstance().searchForAgentUpdate()) {
            return false;
        }
        boolean mandatoryUpdate = false;
        return this.checkForAgentUpdate(mandatoryUpdate);
    }

    class ConActionDoInstallPackages
    extends ConActionSetRestoreReboot {
        IStatus install_result;

        ConActionDoInstallPackages() {
        }

        @Override
        protected void performAction() {
            this.install_result = ConPageWizInstall.this.getContext().installSelectedPackages();
        }

        protected AConPage createNewPage(IConManager a_manager) {
            return new ConPageInstCompletion(a_manager, this.install_result);
        }
    }
}

