/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.ProfileOfferingFix;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.pages.ConPageElementDetails;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.IOfferingOrFix;

public class ConPageViewInstalledPackage
extends AConPage {
    public ConPageViewInstalledPackage(IConManager conManager) {
        super(conManager);
    }

    public void init() {
        this.setHeaderView(com.ibm.cic.agent.core.sharedUI.Messages.InstalledOfferingsDlg_title);
        boolean hasInstalledPkgs = true;
        Profile[] installedProductProfiles = Agent.getInstance().getNormalProfiles();
        if (installedProductProfiles.length == 0) {
            hasInstalledPkgs = false;
            this.addView((IConView)new ConViewText(Messages.ConPageViewInstalledPackage_NoInstallPkg));
            this.addView((IConView)new ConViewText(""));
        } else {
            ConViewTreeList installedPkgTree = new ConViewTreeList(Messages.ConPageViewInstalledPkgDes, 1, false, true);
            InstalledPackageContentProvider contProvider = new InstalledPackageContentProvider();
            installedPkgTree.setContentProvider((IConViewContentProvider)contProvider);
            this.addView((IConView)installedPkgTree);
        }
        ConViewList otherOptions = new ConViewList(hasInstalledPkgs ? Messages.General_OtherOptions : Messages.General_Options, true);
        otherOptions.addEntry(Messages.General_OK, ConCommonCommandKeys.keys_OK, (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        this.addView((IConView)otherOptions);
    }

    static class ConActionDisplayDetails
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActionDisplayDetails() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            Object element = entry.getElement();
            ConPageElementDetails detailPage = ConPageElementDetails.getDetailsPage(a_conManager, element);
            if (detailPage != null) {
                detailPage.setSuggestedInput(ConCommonCommandKeys.keys_OK[0]);
                a_conManager.addPage((AConPage)detailPage);
            }
            super.run(a_conManager);
        }
    }

    static class InstalledPackageContentProvider
    extends AConViewContentProvider {
        InstalledPackageContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof Profile) {
                return ((Profile)element).getProfileId();
            }
            if (element instanceof ProfileOffering) {
                return InstalledPackageContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((ProfileOffering)element).getOffering());
            }
            if (element instanceof ProfileOfferingFix) {
                return InstalledPackageContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((ProfileOfferingFix)element).getFix());
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                return ProfileOffering.getOfferingsFromProfile((Profile)((Profile)parentElement));
            }
            if (parentElement instanceof ProfileOffering) {
                return ProfileOfferingFix.getFixesFromProfileOffering((ProfileOffering)((ProfileOffering)parentElement));
            }
            return null;
        }

        public Object[] getElements() {
            return Agent.getInstance().getSortedProductProfiles(false);
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof Profile || element instanceof ProfileOffering || element instanceof ProfileOfferingFix) {
                return new ConActionDisplayDetails();
            }
            return super.getAction(element);
        }
    }
}

