/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.pages.ConPageElementDetails;
import com.ibm.cic.agent.internal.core.history.HistoryStore;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import java.util.ArrayList;
import java.util.Iterator;
import org.osgi.framework.Version;

public class ConPageViewInstallHistory
extends AConPage {
    private static final String FORMAT_STRING = "%-26s:  %-15s: %-15s %n %-8s %-30s";

    public ConPageViewInstallHistory(IConManager conManager) {
        super(conManager);
    }

    public void init() {
        this.setHeaderView(com.ibm.cic.agent.core.sharedUI.Messages.InstallHistoryView_title);
        boolean hasInstallHistory = true;
        HistoryStore historyStore = Agent.getInstance().getHistoryStore();
        Iterator it = historyStore.getAllProfileInfos();
        if (it == null || !it.hasNext()) {
            hasInstallHistory = false;
        }
        ConViewText desView = new ConViewText(hasInstallHistory ? Messages.ConPageViewInstallHistoryDes : Messages.ConPageViewInstallHistory_NoHistory);
        this.addView((IConView)desView);
        if (hasInstallHistory) {
            ConViewTreeList installHistoryTree = new ConViewTreeList("", 1, false, true, 0, false);
            InstallHistoryContentProvider contProvider = new InstallHistoryContentProvider();
            installHistoryTree.setContentProvider((IConViewContentProvider)contProvider);
            this.addView((IConView)installHistoryTree);
        }
        ConViewList otherOptions = new ConViewList(hasInstallHistory ? Messages.General_OtherOptions : Messages.General_Options, true);
        otherOptions.addEntry(Messages.General_OK, ConCommonCommandKeys.keys_OK, (AConActionEntry)ConActionReturnToPreviousPage.INSTANCE_PREVIOUS);
        this.addView((IConView)otherOptions);
    }

    private String getInstallPackageList(IActivity activity) {
        StringBuffer result = new StringBuffer();
        Iterator it = activity.getAllOfferings();
        while (it.hasNext()) {
            IOfferingInfo offeringInfo = (IOfferingInfo)it.next();
            result.append(offeringInfo.getOfferingName());
            result.append("  ");
            result.append(offeringInfo.getLocalizedVersion());
            Version offeringVersion = offeringInfo.getOfferingVersion();
            if (offeringVersion != null) {
                String offeringVersionStr = offeringVersion.toString();
                boolean showInternalVersion = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
                if (!offeringVersionStr.equals(offeringInfo.getLocalizedVersion()) && showInternalVersion) {
                    result.append("  ");
                    result.append(offeringInfo.getOfferingVersion());
                }
            }
            result.append(", ");
        }
        String return_result = result.toString();
        if (return_result.endsWith(", ")) {
            return_result = return_result.substring(0, result.length() - 2);
        }
        return return_result;
    }

    static class ConActionDisplayDetails
    extends AConActionEntry<ConViewTreeListEntry> {
        ConActionDisplayDetails() {
        }

        public void run(IConManager a_conManager) {
            ConViewTreeListEntry entry = (ConViewTreeListEntry)this.getEntry();
            Object element = entry.getElement();
            ConPageElementDetails detailPage = ConPageElementDetails.getDetailsPage(a_conManager, element);
            if (detailPage != null) {
                detailPage.setSuggestedInput(ConCommonCommandKeys.keys_OK[0]);
                a_conManager.addPage((AConPage)detailPage);
            }
            super.run(a_conManager);
        }
    }

    class InstallHistoryContentProvider
    extends AConViewContentProvider {
        InstallHistoryContentProvider() {
        }

        public String getLabel(Object element) {
            if (element instanceof IActivity) {
                IActivity activity = (IActivity)element;
                return String.format(ConPageViewInstallHistory.FORMAT_STRING, activity.getStartTime(), SharedUIUtils.ACTIVITY_TYPE[activity.getActivityType()], SharedUIUtils.getLocalizedStatus((IActivity)activity), " ", ConPageViewInstallHistory.this.getInstallPackageList(activity));
            }
            return super.getLabel(element);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object[] getElements() {
            ArrayList elements = new ArrayList();
            HistoryStore historyStore = Agent.getInstance().getHistoryStore();
            Iterator it = historyStore.getAllProfileInfos();
            while (it.hasNext()) {
                IProfileInfo profileInfo = (IProfileInfo)it.next();
                Iterator activityIt = profileInfo.getHistory().getActivities();
                while (activityIt.hasNext()) {
                    elements.add(activityIt.next());
                }
            }
            return elements.toArray();
        }

        public AConActionEntry getAction(Object element) {
            if (element instanceof IActivity) {
                return new ConActionDisplayDetails();
            }
            return super.getAction(element);
        }
    }
}

