/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdate;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdateVersionSelector;
import com.ibm.cic.agent.internal.console.pages.ConPageBaseSummary;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewProperties;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConPageUpdateSummary
extends ConPageBaseSummary {
    ConDataCtxtUpdate m_context;
    ConViewTreeList m_profileOfferingFeaturesList;
    ConViewProperties m_targetLocationInformationView;

    public ConPageUpdateSummary(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.General_Header_Summary);
        this.m_targetLocationInformationView = new ConViewProperties(Messages.General_Summary_TargetLocation, null, null);
        this.addView((IConView)this.m_targetLocationInformationView);
        this.m_profileOfferingFeaturesList = new ConViewTreeList(Messages.PageUpdate_Pkg_PgName, 1, false, true);
        UpdateSummaryContentProvider contProvider = new UpdateSummaryContentProvider();
        this.m_profileOfferingFeaturesList.setContentProvider((IConViewContentProvider)contProvider);
        this.addView((IConView)this.m_profileOfferingFeaturesList);
        ConViewList optionsList = new ConViewList(Messages.General_Options);
        this.addGenerateResponseFileEntry(optionsList);
        this.addView((IConView)optionsList);
        super.init();
    }

    @Override
    protected CommandRecorder getCommandRecorder() {
        return this.m_context.getCommandRecorder();
    }

    @Override
    protected String getResponseFileOptionLabel() {
        return Messages.PageUpdate_Summary_GenerateResponseFile;
    }

    public boolean isPageComplete() {
        return this.m_context.getSelectedJobs().containsJobs() || this.m_context.getSelectedInstallFixJobs().containsJobs();
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtUpdate)this.conManager().getDataContext(ConDataCtxtUpdate.class);
        return this.m_context == null;
    }

    public void setVisible(boolean a_visible) {
        if (a_visible) {
            this.m_profileOfferingFeaturesList.refresh();
            this.m_targetLocationInformationView.clear();
            String sharedLocation = CacheLocationManager.getInstance().getCacheLocation();
            this.m_targetLocationInformationView.addProperty(Messages.General_Summary_SharedResourceDirectory, sharedLocation);
        }
        super.setVisible(a_visible);
    }

    static class FeaturesList {
        final boolean m_install;
        final UpdateOfferingJob m_job;

        FeaturesList(boolean i, UpdateOfferingJob j) {
            this.m_install = i;
            this.m_job = j;
        }
    }

    static class FixesList {
        final UpdateOfferingJob m_job;
        final List<InstallJob> m_fixJobList;

        FixesList(UpdateOfferingJob job, List<InstallJob> fixJobList) {
            this.m_job = job;
            this.m_fixJobList = fixJobList;
        }
    }

    class UpdateSummaryContentProvider
    extends AConViewContentProvider {
        ConDataCtxtUpdateVersionSelector m_contextVS;

        UpdateSummaryContentProvider() {
            this.m_contextVS = (ConDataCtxtUpdateVersionSelector)ConPageUpdateSummary.this.conManager().getDataContext(ConDataCtxtUpdateVersionSelector.class);
        }

        protected String getLabelProfileIdAndInstallLocation(Profile p) {
            return NLS.bind((String)Messages.General_Label_ProfileIdAndLocation, (Object)p.getProfileId(), (Object)p.getInstallLocation());
        }

        protected IFeature[] getVisibleFeatures(Collection<IFeature> a_features) {
            ArrayList<IFeature> return_value = new ArrayList<IFeature>();
            for (IFeature feature : a_features) {
                if (!feature.isVisible()) continue;
                return_value.add(feature);
            }
            return return_value.toArray(new IFeature[return_value.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                Profile profile = (Profile)parentElement;
                LinkedHashSet<Object> return_result = new LinkedHashSet<Object>();
                return_result.addAll(ConPageUpdateSummary.this.m_context.getSelectedJobs().getSelectedOfferingJobs(profile));
                List<InstallJob> fixJobs = ConPageUpdateSummary.this.m_context.getSelectedInstallFixJobs().getSelectedFixJobs(profile);
                IOffering[] offerings = this.m_contextVS.getOfferingsToUpdate(profile);
                if (offerings != null) {
                    IOffering[] iOfferingArray = offerings;
                    int n = offerings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOffering installedOffering = iOfferingArray[n2];
                        for (InstallJob fixJob : fixJobs) {
                            IFix fix = fixJob.getFix();
                            if (fix == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)installedOffering)) continue;
                            return_result.add(fixJob);
                        }
                        ++n2;
                    }
                }
                return return_result.toArray();
            }
            if (parentElement instanceof UpdateOfferingJob) {
                IFeature feature;
                IFeature[] InstallFeatures;
                UpdateOfferingJob updateJob = (UpdateOfferingJob)parentElement;
                IOffering update = updateJob.getOffering();
                ArrayList<Object> return_value = new ArrayList<Object>();
                List<InstallJob> fixJobs = ConPageUpdateSummary.this.m_context.getSelectedInstallFixJobs().getSelectedFixJobs(updateJob.getProfile());
                if (!fixJobs.isEmpty()) {
                    LinkedList<InstallJob> fixesAppliedToThisOffering = new LinkedList<InstallJob>();
                    for (InstallJob job : fixJobs) {
                        IFix fix = job.getFix();
                        if (fix == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)update)) continue;
                        fixesAppliedToThisOffering.add(job);
                    }
                    if (!fixesAppliedToThisOffering.isEmpty()) {
                        return_value.add(new FixesList(updateJob, fixesAppliedToThisOffering));
                    }
                }
                if ((InstallFeatures = this.getVisibleFeatures(updateJob.getFeatures())).length > 0) {
                    return_value.add(new FeaturesList(true, updateJob));
                }
                Set featuresToRemove = Agent.getInstance().getInstalledFeatures(updateJob.getProfile(), updateJob.getUpdatedOffering());
                IFeature[] iFeatureArray = InstallFeatures;
                int n = InstallFeatures.length;
                int fix = 0;
                while (fix < n) {
                    IFeature f = iFeatureArray[fix];
                    featuresToRemove.remove(f);
                    ++fix;
                }
                Iterator it = featuresToRemove.iterator();
                if (it.hasNext() && (feature = (IFeature)it.next()).isVisible()) {
                    return_value.add(new FeaturesList(false, updateJob));
                }
                return return_value.toArray();
            }
            if (parentElement instanceof FeaturesList) {
                FeaturesList fl = (FeaturesList)parentElement;
                if (fl.m_install) {
                    return this.getVisibleFeatures(fl.m_job.getFeatures());
                }
                List InstallFeatures = fl.m_job.getFeatures();
                Set featuresToRemove = Agent.getInstance().getInstalledFeatures(fl.m_job.getProfile(), fl.m_job.getUpdatedOffering());
                featuresToRemove.removeAll(InstallFeatures);
                return this.getVisibleFeatures(featuresToRemove);
            }
            if (parentElement instanceof FixesList) {
                return ((FixesList)parentElement).m_fixJobList.toArray();
            }
            return null;
        }

        public Object[] getElements() {
            return ConPageUpdateSummary.this.m_context.getSelectedProfiles().toArray();
        }

        public String getLabel(Object element) {
            if (element instanceof Profile) {
                return this.getLabelProfileIdAndInstallLocation((Profile)element);
            }
            if (element instanceof UpdateOfferingJob) {
                return UpdateSummaryContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((UpdateOfferingJob)element).getUpdatedOffering());
            }
            if (element instanceof IFeature) {
                return OfferingUtil.getFeatureName((IFeature)((IFeature)element));
            }
            if (element instanceof FeaturesList) {
                FeaturesList fl = (FeaturesList)element;
                if (fl.m_install) {
                    return Messages.PageUpdate_Summary_InstallFeature;
                }
                return Messages.PageUpdate_Summary_RemoveFeature;
            }
            if (element instanceof FixesList) {
                return Messages.PageUpdate_Summary_Fixes;
            }
            if (element instanceof InstallJob) {
                return UpdateSummaryContentProvider.getLabelOfferingOrFix((IOfferingOrFix)((InstallJob)element).getOfferingOrFix());
            }
            return super.getLabel(element);
        }
    }
}

