/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.console.ConCommandKeys;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdate;
import com.ibm.cic.agent.internal.console.pages.AConPageElementDetails;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.utils.OutputFormatter;

public class ConPageUpdate
extends AConPageElementDetails {
    ConDataCtxtUpdate context;

    public ConPageUpdate(IConManager conManager) {
        super(conManager);
    }

    public void init() {
        this.setHeaderView(Messages.PageUpdate_Header);
        this.context = (ConDataCtxtUpdate)this.conManager().getDataContext(ConDataCtxtUpdate.class);
        super.init();
    }

    public void present(OutputFormatter outputFmt) {
        this.clear();
        Profile[] profiles = this.context.getAllProductProfiles();
        if (profiles.length > 0) {
            ConViewListNumbered mainList = new ConViewListNumbered(Messages.PageUpdate_SelectPG, true, 1);
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                mainList.addEntry(profile.getProfileId(), (AConActionEntry)new ConActionFlipSelectUpdateProfile(), this.context.getSelectedProfiles().contains(profile)).setContext((Object)profile);
                ++n2;
            }
            this.addView((IConView)mainList);
            this.addElementDescription(this.context.getSelectedProfiles().getSingleSelectedProfile());
            ConViewList otherOptions = new ConViewList(Messages.General_OtherOptions, true);
            if (!this.context.isUpdateAllRequested()) {
                otherOptions.addEntry(Messages.PageUpdate_UpdateAll, ConCommandKeys.keys_Update, (AConActionEntry)new ConActionFlipAll(true));
            }
            if (this.context.getSelectedProfiles().containsProfiles()) {
                otherOptions.addEntry(Messages.PageUpdate_UpdateNone, ConCommandKeys.keys_All, (AConActionEntry)new ConActionFlipAll(false));
            }
            this.addView((IConView)otherOptions);
        } else {
            this.addView((IConView)new ConViewText(Messages.PageUpdate_NoPkgToUpdate, true));
        }
        super.present(outputFmt);
    }

    public boolean isPageComplete() {
        return this.context.getSelectedProfiles().containsProfiles();
    }

    protected boolean hasNext() {
        return this.isPageComplete();
    }

    class ConActionFlipAll
    extends AConActionEntry<ConViewListEntry> {
        boolean select;

        private ConActionFlipAll(boolean s) {
            this.select = s;
        }

        public void run(IConManager a_conManager) {
            ConPageUpdate.this.context.selectAllProfiles(this.select);
            super.run(a_conManager);
        }
    }

    class ConActionFlipSelectUpdateProfile
    extends AConActionEntry<ConViewListEntry> {
        ConActionFlipSelectUpdateProfile() {
        }

        public void run(IConManager a_conManager) {
            Profile profile = (Profile)((ConViewListEntry)this.getEntry()).getContext();
            ConPageUpdate.this.context.flipProfileSelection(profile);
            super.run(a_conManager);
        }
    }
}

