/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.sharedUI.AgentReopenRepositoryUtil;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtOpenRepository;
import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class ConPageOpenRepository
extends AConPage {
    private ConDataCtxtOpenRepository context;

    public ConPageOpenRepository(IConManager manager) {
        super(manager);
    }

    public void init() {
        this.context = (ConDataCtxtOpenRepository)this.conManager().getDataContext(ConDataCtxtOpenRepository.class);
        StringBuilder sb = new StringBuilder();
        sb.append(this.context.getApplication());
        sb.append("> ");
        sb.append(this.context.getOpener().getTitle());
        this.setHeaderView(sb.toString());
        super.init();
    }

    protected void createContents(ConViewGroup contents) {
        this.context = (ConDataCtxtOpenRepository)this.conManager().getDataContext(ConDataCtxtOpenRepository.class);
        AgentReopenRepositoryUtil.RepositoryOpener opener = this.context.getOpener();
        contents.addView((IConView)new ConViewText(this.context.getOpener().getTitleMessage()));
        contents.addView((IConView)new ConViewText(""));
        this.addPrompt(contents, opener);
        contents.addView((IConView)new ConViewText(""));
        contents.addView((IConView)new ConViewText(NLS.bind((String)Messages.ConPageOpenRepository_locationInfo, (Object)this.context.getLocation())));
        contents.addView((IConView)new ConViewText(""));
        ConViewList mainList = new ConViewList(com.ibm.cic.common.core.console.Messages.General_Select);
        mainList.setNewLineAfterList(false);
        mainList.addEntry(Messages.ConPageOpenRepository_continueWithDiskOrRepoAtCurrentLocation, "O", (AConActionEntry)new ConActOpenRepository());
        mainList.addEntry(Messages.ConPageOpenRepository_enterNewLocation, "N", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction((String)Messages.ConPageOpenRepository_enterNewLocationBreadCrumb, (String)Messages.ConPageOpenRepository_enterNewLocationForDiskOrAlternativeRepo, (ConPageEnterPath.ConActionEnterPath)new ConPageEnterPath.ConActionEnterPath(){

            protected IStatus processInput() {
                String input = this.getInput();
                IStatus status = ConPageOpenRepository.this.context.getOpener().openAndValidateRepository(input, (IProgressMonitor)new NullProgressMonitor());
                ConPageOpenRepository.this.context.setEnteredLocation(input);
                ConPageOpenRepository.this.context.setResultStatus(status);
                return status;
            }
        }, (boolean)true, (int)7)).setContext((Object)this.context);
        mainList.addEntry(com.ibm.cic.common.core.console.Messages.General_Dlg_Cancel, ConCommonCommandKeys.keys_Cancel[0], (AConActionEntry)new ConActCancel());
        contents.addView((IConView)mainList);
        this.setSuggestedInput("O");
    }

    private void addPrompt(ConViewGroup contents, AgentReopenRepositoryUtil.RepositoryOpener opener) {
        if (opener.getDiskLabel() != null) {
            contents.addView((IConView)new ConViewText(NLS.bind((String)Messages.ConPageOpenRepository_insertDisk1OrSpecifyAlternative, (Object)opener.getDiskLabel())));
        } else {
            String offeringLabel = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)opener.getOfferingOrFix(), (boolean)false);
            String prompt = opener.getOfferingOrFix() instanceof IOffering ? NLS.bind((String)Messages.ConPageOpenRepository_specifyRepoForPackage, (Object)offeringLabel) : NLS.bind((String)Messages.ConPageOpenRepository_specifyRepoForFix, (Object)offeringLabel);
            contents.addView((IConView)new ConViewText(prompt));
        }
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        this.createContents((ConViewGroup)this);
        super.present(a_output);
    }

    class ConActCancel
    extends ConActionExit {
        ConActCancel() {
        }

        public void run(IConManager a_conManager) {
            ConPageOpenRepository.this.context.setResultStatus(Status.CANCEL_STATUS);
            super.run(a_conManager);
        }
    }

    class ConActOpenRepository
    extends ConActionExit {
        ConActOpenRepository() {
        }

        public boolean shouldExit() {
            return ConPageOpenRepository.this.context.getResultStatus().isOK() || ConPageOpenRepository.this.context.getResultStatus().matches(8);
        }

        public void run(IConManager manager) {
            String path = ConPageOpenRepository.this.context.getLocation().trim();
            IStatus status = ConPageOpenRepository.this.context.getOpener().openAndValidateRepository(path, (IProgressMonitor)new NullProgressMonitor());
            ConPageOpenRepository.this.context.setResultStatus(status);
            int filter = 7;
            if (status.matches(filter)) {
                ConStatusMessageDialog.open((IConManager)manager, (String)ConPageOpenRepository.this.context.getOpener().getTitle(), null, (IStatus)status, (int)filter, (boolean)false);
            }
        }
    }
}

