/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtInst;
import com.ibm.cic.agent.internal.console.pages.ConPageInstSelect;
import com.ibm.cic.agent.internal.console.pages.ConPageWizInstall;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionAddPage;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class ConPageInst
extends AConPage {
    private ConDataCtxtInst m_context;
    private ConViewGroup offeringGroup;
    private ConViewGroup noOfferingMsgGroup;
    private ConViewListNumbered mainList;
    private ConViewList otherOptions;
    private final ConViewStatus m_statusView = new ConViewStatus();
    private boolean firstTimeVisible = true;
    private IStatus agentOfferingApplicabilityStatus;

    public ConPageInst(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageInstall_Header);
        this.m_context = (ConDataCtxtInst)this.conManager().getDataContext(ConDataCtxtInst.class);
        this.offeringGroup = new ConViewGroup();
        this.addView((IConView)this.offeringGroup);
        this.noOfferingMsgGroup = new ConViewGroup();
        this.addView((IConView)this.noOfferingMsgGroup);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        List<InstallJob> packageList = this.m_context.getProposedJobs();
        if (!packageList.isEmpty()) {
            this.noOfferingMsgGroup.clear();
            this.offeringGroup.clear();
            this.mainList = new ConViewListNumbered(Messages.AvailableOfferingPage_description, true, 1);
            this.offeringGroup.addView((IConView)this.mainList);
            this.offeringGroup.addView((IConView)this.m_statusView);
            this.otherOptions = new ConViewList(null, true);
            this.offeringGroup.addView((IConView)this.otherOptions);
            for (InstallJob job : packageList) {
                IOfferingOrFix o = job.getOfferingOrFix();
                this.mainList.addEntry(AConViewContentProvider.getLabelOfferingOrFix((IOfferingOrFix)o), (AConActionEntry)new ConActionSelectPackage(), this.m_context.getSelectedJobs().contains(job)).setContext((Object)job);
            }
            if (this.m_context.displaySearchForOtherVersions()) {
                this.otherOptions.addEntry(Messages.AvailableOfferingSection_checkForLatest_new, "O", (AConActionEntry)new ConActionCheckOtherVersion());
            }
            List<InstallJob> selectedOfferingJobs = this.m_context.getSelectedJobs().getSelectedOfferingJobs();
            if (!SharedUIUtils.haveInstalledOfferings() && !selectedOfferingJobs.isEmpty()) {
                boolean allExtensions = true;
                for (InstallJob job : selectedOfferingJobs) {
                    IOffering offering = job.getOffering();
                    if (Agent.isExtensionOffering((IOfferingOrFix)offering)) continue;
                    allExtensions = false;
                    break;
                }
                if (allExtensions) {
                    ICicStatus allExtensionErrorStatus = Statuses.ERROR.get(AgentUtil.makeUnresolvedRequirementsError((IOffering)selectedOfferingJobs.get(0).getOffering()), new Object[0]);
                    if (this.agentOfferingApplicabilityStatus != null && StatusUtil.isErrorOrCancel((IStatus)this.agentOfferingApplicabilityStatus)) {
                        CicMultiStatus parentStatus = Statuses.ERROR.getMultiStatus();
                        parentStatus.add(this.agentOfferingApplicabilityStatus);
                        parentStatus.add((IStatus)allExtensionErrorStatus);
                        this.m_statusView.setStatus((IStatus)parentStatus);
                    } else {
                        this.m_statusView.setStatus((IStatus)allExtensionErrorStatus);
                    }
                } else {
                    this.m_statusView.setStatus(this.agentOfferingApplicabilityStatus);
                }
            } else {
                this.m_statusView.setStatus(this.agentOfferingApplicabilityStatus);
            }
        } else {
            this.offeringGroup.clear();
            this.noOfferingMsgGroup.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.NoOfferingAvailablePage_label1));
            this.noOfferingMsgGroup.addView((IConView)new ConViewText(""));
        }
        super.present(a_output);
    }

    public boolean isPageComplete() {
        return this.m_context.getSelectedJobs().containOfferingJobs() && !StatusUtil.isErrorOrCancel((IStatus)this.m_statusView.getStatus());
    }

    public void setVisible(boolean a_visible) {
        if (a_visible) {
            List<InstallJob> packageList = this.m_context.getProposedJobs();
            if (!packageList.isEmpty()) {
                List<InstallJob> jobs = this.m_context.getSelectedJobs().getSelectedOfferingJobs();
                this.agentOfferingApplicabilityStatus = AgentUtil.checkAgentOfferingApplicability(jobs);
            }
            if (this.firstTimeVisible) {
                this.firstTimeVisible = false;
                if (AgentInput.getInstance().getMode() == 1) {
                    ConPageWizInstall wizard = (ConPageWizInstall)this.getParent();
                    wizard.checkJobsToleranceForAgent(this.m_context.getProposedJobs());
                }
            }
        }
        super.setVisible(a_visible);
    }

    protected boolean hasNext() {
        return this.isPageComplete();
    }

    private class ConActionCheckOtherVersion
    extends AConActionEntry<ConViewListEntry> {
        private ConActionCheckOtherVersion() {
        }

        public void run(IConManager a_manager) {
            ConPageWizInstall wizard = (ConPageWizInstall)ConPageInst.this.getParent();
            if (wizard.checkForAgentUpdateInWizardModeIfPrefSet()) {
                return;
            }
            IStatus searchStatus = ConPageInst.this.m_context.searchServiceRepositories(false);
            ConStatusMessageDialog.open((IConManager)a_manager, (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, null, (IStatus)searchStatus, (int)5, (boolean)false);
        }
    }

    private class ConActionSelectPackage
    extends ConActionAddPage {
        private ConActionSelectPackage() {
        }

        protected AConPage createNewPage(IConManager a_manager) {
            ConPageWizInstall wizard;
            InstallJob job = (InstallJob)((ConViewListEntry)this.getEntry()).getContext();
            ConPageInst.this.m_context.setProcessedJob(job);
            if (!ConPageInst.this.m_context.isProcessedJobSelected() && (wizard = (ConPageWizInstall)ConPageInst.this.getParent()).checkJobsToleranceForAgent((AbstractJob)job)) {
                return null;
            }
            return new ConPageInstSelect(a_manager);
        }
    }
}

