/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtFeatures;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtUpdate;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewStatus;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConPageFeatures
extends AConPage {
    private ConDataCtxtFeatures m_context;
    private boolean m_anyFeatureIsSelected;
    private IStatus m_status = Status.OK_STATUS;

    public ConPageFeatures(IConManager controller) {
        super(controller);
    }

    public void init() {
        this.setHeaderView(Messages.PageFeatures_Header);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        List<AgentJob> jobs = this.m_context.getSelectedOfferingJobs();
        int startIndex = 1;
        for (AgentJob job : jobs) {
            if (!job.getFeatures().isEmpty()) {
                this.m_anyFeatureIsSelected = true;
            }
            List<IFeature> features = this.m_context.getAllVisibleFeatures(job);
            ConViewListNumbered featureList = new ConViewListNumbered(job.getOfferingOrFix().getName(), true, startIndex);
            if (features != null) {
                startIndex += features.size();
                for (IFeature feature : features) {
                    boolean isSelected = this.m_context.isFeatureSelected(job, feature);
                    featureList.addEntry(feature.getInformation().getName(), (AConActionEntry)new ConActFlipFeatureSelection(), isSelected).setContext((Object)new JobFeature(job, feature, isSelected));
                }
            }
            this.addView((IConView)featureList);
        }
        this.addView((IConView)ConViewText.NEW_LINE);
        ConViewStatus statusView = new ConViewStatus(null, true, this.m_status, 6);
        this.addView((IConView)statusView);
        if (this.m_context.isPageComplete()) {
            this.m_status = Status.OK_STATUS;
        }
        super.present(a_output);
    }

    public boolean isPageComplete() {
        return this.m_anyFeatureIsSelected && this.m_context.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_status = this.m_context.checkDiskSpaceInfoStatus();
        }
        super.setVisible(visible);
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtFeatures)this.conManager().getDataContext(ConDataCtxtFeatures.class);
        ConDataCtxtUpdate ctxt = (ConDataCtxtUpdate)this.conManager().getDataContext(ConDataCtxtUpdate.class);
        return ctxt != null && ctxt.getSingleSelectedProfile() == null || this.m_context.noVisibleFeatures() || AgentUtil.onlyInstallAgent(this.m_context.getSelectedOfferingJobs());
    }

    class ConActFlipFeatureSelection
    extends AConActionEntry<ConViewListEntry> {
        ConActFlipFeatureSelection() {
        }

        public void run(IConManager a_conManager) {
            JobFeature jf = (JobFeature)((ConViewListEntry)this.getEntry()).getContext();
            ConPageFeatures.this.m_status = ConPageFeatures.this.m_context.selectFeature(jf.job, jf.feature, !jf.isSelected);
            super.run(a_conManager);
        }
    }

    private static class JobFeature {
        final AgentJob job;
        final IFeature feature;
        final boolean isSelected;

        public JobFeature(AgentJob job, IFeature feature, boolean isSelected) {
            this.job = job;
            this.feature = feature;
            this.isSelected = isSelected;
        }
    }
}

