/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.pages;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ConCustomPanel;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.custompanel.GeneratedConsoleUICustomPanel;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtCustomPanelList;
import com.ibm.cic.agent.internal.console.pages.AConPageAgentWizard;
import com.ibm.cic.agent.internal.console.pages.ConPageCustomPanelContainer;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewListNumbered;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public class ConPageCustomPanelList
extends AConPage {
    private ConDataCtxtCustomPanelList m_context;
    private final AConPageAgentWizard m_wizard;
    private final WizardType m_wizardType;
    private int m_currentCustomPanelIndex = 0;
    private ConPageCustomPanelContainer m_currentPanelContainer;

    public ConPageCustomPanelList(IConManager controller, AConPageAgentWizard wizard, WizardType wizardType) {
        super(controller);
        this.m_wizard = wizard;
        this.m_wizardType = wizardType;
    }

    public void init() {
        this.setHeaderView(Messages.PageCustomPanelHeader);
        super.init();
    }

    public void present(OutputFormatter a_output) {
        this.clear();
        this.m_currentCustomPanelIndex = 0;
        this.m_currentPanelContainer = null;
        this.setSuggestedInput(String.valueOf(1));
        Map<Profile, Map<IOffering, List<CustomPanelJobPair>>> profileMap = this.m_context.getGroupedNonSkippedConsoleCustomPanels();
        ArrayList<Profile> profileList = new ArrayList<Profile>(1);
        int indent = profileMap.size() > 1 ? 1 : 0;
        int index = 1;
        for (Map.Entry<Profile, Map<IOffering, List<CustomPanelJobPair>>> e1 : profileMap.entrySet()) {
            Profile profile = e1.getKey();
            profileList.add(profile);
            Map<IOffering, List<CustomPanelJobPair>> map = e1.getValue();
            if (profileMap.size() > 1) {
                ConViewText profileText = new ConViewText(NLS.bind((String)Messages.ConDataCtxtCustomPanels_Configuration_For_Packages_In, (Object)profile.getInstallLocation()), true);
                this.addView((IConView)profileText);
            }
            for (Map.Entry<IOffering, List<CustomPanelJobPair>> e2 : map.entrySet()) {
                IOffering offering = e2.getKey();
                List<CustomPanelJobPair> pairs = e2.getValue();
                String header = offering == null ? Messages.ConDataCtxtCustomPanels_Common_Configuration : NLS.bind((String)Messages.ConDataCtxtCustomPanels_Configuration_For_Package, (Object)offering.getName(), (Object)OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering));
                ConViewListNumbered customPanelList = new ConViewListNumbered(header, false, index, indent);
                for (CustomPanelJobPair pair : pairs) {
                    ICustomPanel panel = pair.getPanel();
                    if (!(panel instanceof ConCustomPanel)) continue;
                    ConCustomPanel consolePanel = (ConCustomPanel)panel;
                    IStatus status = consolePanel.getValidationStatus();
                    boolean isComplete = consolePanel.isPageComplete();
                    boolean isVisited = true;
                    if (consolePanel instanceof GeneratedConsoleUICustomPanel) {
                        isVisited = ((GeneratedConsoleUICustomPanel)consolePanel).isVisited();
                    }
                    String statusString = this.getPanelStatusLabel(Messages.ConPageCustomPanelList_StatusComplete);
                    if (!isComplete) {
                        statusString = status.matches(4) && isVisited ? this.getPanelStatusLabel(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Error) : this.getPanelStatusLabel(Messages.ConPageCustomPanelList_StatusIncomplete);
                    } else if (status.matches(2) && isVisited) {
                        statusString = this.getPanelStatusLabel(com.ibm.cic.agent.core.sharedUI.Messages.Severity_Warning);
                    }
                    String panelHeader = consolePanel.getPanelId();
                    customPanelList.addEntry(String.valueOf(statusString) + panelHeader, (AConActionEntry)new ConActionShowCustomPanel()).setContext((Object)pair);
                }
                this.addView((IConView)customPanelList);
                index += pairs.size();
            }
        }
        AgentInput.getInstance().checkUserDataInProfile(profileList);
        super.present(a_output);
    }

    private String getPanelStatusLabel(String statusString) {
        return "[" + statusString + "] ";
    }

    public boolean isPageComplete() {
        List<CustomPanelJobPair> pairs = this.m_context.getNonSkippedConsoleCustomPanels();
        for (CustomPanelJobPair pair : pairs) {
            ConCustomPanel conPanel;
            ICustomPanel panel = pair.getPanel();
            if (!(panel instanceof ConCustomPanel) || (conPanel = (ConCustomPanel)panel).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean skipPage() {
        this.m_context = (ConDataCtxtCustomPanelList)this.conManager().getDataContext(ConDataCtxtCustomPanelList.class);
        return this.m_context.shouldSkipCustomPanelListPage(this.m_wizardType);
    }

    public void dispose() {
        List<CustomPanelJobPair> pairs = this.m_context.getAllConsoleCustomPanels();
        for (CustomPanelJobPair pair : pairs) {
            ICustomPanel panel = pair.getPanel();
            if (!(panel instanceof ConCustomPanel)) continue;
            ((ConCustomPanel)panel).dispose();
        }
    }

    private ConPageCustomPanelContainer generateCustomPanelContainerPage(CustomPanelJobPair pair) {
        return new ConPageCustomPanelContainer(this.conManager(), pair, this);
    }

    public boolean canNavigateToPreviousPanel() {
        return true;
    }

    public void navigateToPreviousPanel() {
        if (this.m_currentCustomPanelIndex == 0) {
            if (this.m_currentPanelContainer != null) {
                this.m_currentPanelContainer.dispose();
            }
            this.conManager().returnToPreviousPage(1);
        } else if (this.m_currentCustomPanelIndex > 0) {
            CustomPanelJobPair previousPanel = this.m_context.getNonSkippedConsoleCustomPanels().get(--this.m_currentCustomPanelIndex);
            this.m_currentPanelContainer.setVisible(false);
            this.m_currentPanelContainer.setCustomPanelJobPair(previousPanel);
            this.m_currentPanelContainer.setVisible(true);
            this.m_currentPanelContainer.init();
        }
    }

    public boolean canNavigateToNextPanel() {
        if (this.m_currentPanelContainer != null) {
            List<CustomPanelJobPair> nonSkippedPanels = this.m_context.getNonSkippedConsoleCustomPanels();
            if (this.m_currentCustomPanelIndex == nonSkippedPanels.size() - 1) {
                return this.isPageComplete();
            }
            return this.m_currentPanelContainer.isPageComplete();
        }
        return true;
    }

    public void navigateToNextPanel() {
        List<CustomPanelJobPair> nonSkippedPanels = this.m_context.getNonSkippedConsoleCustomPanels();
        if (!nonSkippedPanels.isEmpty()) {
            if (this.m_currentCustomPanelIndex == nonSkippedPanels.size() - 1) {
                this.m_currentPanelContainer.dispose();
                this.conManager().returnToPreviousPage(1);
                this.m_wizard.flipToNext();
            } else if (this.m_currentCustomPanelIndex < nonSkippedPanels.size() - 1) {
                CustomPanelJobPair nextPanel = this.m_context.getNonSkippedConsoleCustomPanels().get(++this.m_currentCustomPanelIndex);
                this.m_currentPanelContainer.setVisible(false);
                this.m_currentPanelContainer.setCustomPanelJobPair(nextPanel);
                this.m_currentPanelContainer.setVisible(true);
                this.m_currentPanelContainer.init();
            }
        }
    }

    class ConActionShowCustomPanel
    extends AConActionEntry<ConViewListEntry> {
        ConActionShowCustomPanel() {
        }

        public void run(IConManager a_conManager) {
            ConPageCustomPanelList.this.m_currentCustomPanelIndex = this.getEntryIndexLabel() - 1;
            CustomPanelJobPair pair = (CustomPanelJobPair)((ConViewListEntry)this.getEntry()).getContext();
            ConPageCustomPanelList.this.m_currentPanelContainer = ConPageCustomPanelList.this.generateCustomPanelContainerPage(pair);
            a_conManager.addPage((AConPage)ConPageCustomPanelList.this.m_currentPanelContainer);
            super.run(a_conManager);
        }
    }
}

