/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.manager;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.console.ConUtils;
import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.ConsoleProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class InstalledPackagesForProfile {
    private static final Logger log = Logger.getLogger(InstalledPackagesForProfile.class);
    private final Map<String, List<IOfferingOrFix>> m_installedOfferingOrFix;

    public InstalledPackagesForProfile(Set<Profile> selectedProfiles, AgentJob.AgentJobType jobType) throws CoreException {
        this(selectedProfiles, jobType, false);
    }

    public InstalledPackagesForProfile(Set<Profile> selectedProfiles, AgentJob.AgentJobType jobType, boolean prepareAndResolve) throws CoreException {
        block7: {
            this.m_installedOfferingOrFix = new HashMap<String, List<IOfferingOrFix>>();
            if (selectedProfiles.isEmpty()) {
                return;
            }
            ArrayList<IOfferingOrFix> offeringOrFixesToPrepare = new ArrayList<IOfferingOrFix>();
            HashSet<IOffering> installedOfferingSet = new HashSet<IOffering>();
            for (Profile profile : selectedProfiles) {
                List<IOfferingOrFix> installedOfferingsFixes = this.m_installedOfferingOrFix.get(profile.getProfileId());
                if (installedOfferingsFixes == null) {
                    installedOfferingsFixes = new ArrayList<IOfferingOrFix>();
                    IOffering[] offerings = Agent.getInstance().getInstalledOfferings(profile);
                    installedOfferingSet.addAll(Arrays.asList(offerings));
                    installedOfferingsFixes.addAll(Arrays.asList(offerings));
                    IFix[] fixes = Agent.getInstance().getInstalledFixes(profile);
                    installedOfferingsFixes.addAll(Arrays.asList(fixes));
                    this.m_installedOfferingOrFix.put(profile.getProfileId(), installedOfferingsFixes);
                }
                offeringOrFixesToPrepare.addAll(installedOfferingsFixes);
            }
            IStatus return_status = Status.OK_STATUS;
            IProgressMonitor monitor = ConsoleProgressMonitor.createMonitorWithUnknownWork();
            try {
                monitor.beginTask(Messages.ConDataCtxtUpdateVersionSelector_PrepareInstalledPkg, -1);
                IStatus unloadStatus = Agent.getInstance().unloadAgentBundles((IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(unloadStatus);
                return_status = prepareAndResolve ? SharedUIUtils.prepareAndResolveOfferingsAndFixes(offeringOrFixesToPrepare, (boolean)false, (IProgressMonitor)new SubProgressMonitor(monitor, 0)) : SharedUIUtils.prepareOfferingsAndFixes(offeringOrFixesToPrepare, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                log.statusNotOK(return_status);
                if (!StatusUtil.isErrorOrCancel((IStatus)return_status)) {
                    return_status = ConUtils.performLocationChecks(selectedProfiles, jobType);
                    HashMap repLocationMsgMap = new HashMap();
                    ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet(repLocationMsgMap, (IRepositoryGroup)Agent.getInstance().getRepositoryGroup(), (IOffering[])installedOfferingSet.toArray(new IOffering[installedOfferingSet.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                    break block7;
                }
                throw new CoreException(return_status);
            }
            finally {
                monitor.done();
            }
        }
    }

    public List<IOffering> getInstalledOfferings(IProfile profile) {
        List<IOfferingOrFix> installedOfferingOrFix = this.getInstalledOOF(profile);
        ArrayList<IOffering> return_result = new ArrayList<IOffering>();
        for (IOfferingOrFix offeringOrFix : installedOfferingOrFix) {
            if (!(offeringOrFix instanceof IOffering)) continue;
            return_result.add((IOffering)offeringOrFix);
        }
        return Collections.unmodifiableList(return_result);
    }

    public List<IOfferingOrFix> getInstalledOOF(IProfile profile) {
        List<IOfferingOrFix> list = this.m_installedOfferingOrFix.get(profile.getProfileId());
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(list);
    }
}

